/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers.token_manager;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.managers.token_manager.PNMatchType;
import com.pubnub.api.managers.token_manager.PNResourceType;
import com.pubnub.api.managers.token_manager.TokenManagerProperties;
import com.pubnub.api.vendor.Base64;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class TokenManager {
    private HashMap<String, HashMap<String, HashMap<String, String>>> map;

    public TokenManager() {
        this.initMap();
    }

    private synchronized void initMap() {
        PNResourceType[] resources = new PNResourceType[]{PNResourceType.USER, PNResourceType.SPACE};
        this.map = new HashMap();
        for (PNResourceType resource : resources) {
            HashMap skeletonMap = new HashMap();
            skeletonMap.put(PNMatchType.RESOURCE.toString(), new HashMap());
            skeletonMap.put(PNMatchType.PATTERN.toString(), new HashMap());
            this.map.put(resource.toString(), skeletonMap);
        }
    }

    public synchronized void setToken(String token) throws PubNubException {
        JsonObject unwrappedToken = this.unwrapToken(token);
        this.storeToken(unwrappedToken, token);
    }

    public void setTokens(List<String> tokens) throws PubNubException {
        for (String token : tokens) {
            this.setToken(token);
        }
    }

    public synchronized String getToken(TokenManagerProperties tokenManagerProperties) {
        String resourceToken = this.getTokenByMatch(tokenManagerProperties, PNMatchType.RESOURCE);
        if (resourceToken == null) {
            return this.getTokenByMatch(tokenManagerProperties, PNMatchType.PATTERN);
        }
        return resourceToken;
    }

    public synchronized HashMap<String, HashMap<String, HashMap<String, String>>> getTokens() {
        return this.map;
    }

    public synchronized HashMap<String, HashMap<String, String>> getTokensByResource(PNResourceType resourceType) {
        return this.map.get(resourceType.toString());
    }

    private void storeToken(JsonObject jsonObject, String token) {
        PNMatchType[] matchTypes;
        for (PNMatchType asset : matchTypes = new PNMatchType[]{PNMatchType.RESOURCE, PNMatchType.PATTERN}) {
            JsonObject resObject = jsonObject.get(this.getShortenedMatchType(asset)).getAsJsonObject();
            for (String rType : resObject.keySet()) {
                JsonObject singleResObject = resObject.get(rType).getAsJsonObject();
                for (String rName : singleResObject.keySet()) {
                    if (asset == PNMatchType.PATTERN) {
                        this.map.get(this.getExtendedResourceType(rType)).get(asset.toString()).clear();
                    }
                    this.map.get(this.getExtendedResourceType(rType)).get(asset.toString()).put(rName, token);
                }
            }
        }
    }

    private JsonObject unwrapToken(String token) throws PubNubException {
        try {
            String raw = token;
            raw = raw.replace("_", "/").replace("-", "+");
            byte[] byteArray = Base64.decode(raw.getBytes("UTF-8"), 0);
            CBORFactory f = new CBORFactory();
            ObjectMapper mapper = new ObjectMapper((JsonFactory)f);
            Object o = mapper.readValue(byteArray, Object.class);
            return new JsonParser().parse(new Gson().toJson(o)).getAsJsonObject();
        }
        catch (IOException e) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INVALID_ACCESS_TOKEN).build();
        }
    }

    private String getTokenByMatch(TokenManagerProperties tokenManagerProperties, PNMatchType pnMatchType) {
        if (tokenManagerProperties == null || tokenManagerProperties.getPnResourceType() == null || tokenManagerProperties.getResourceId() == null) {
            return null;
        }
        if (pnMatchType != PNMatchType.PATTERN) {
            String token = this.map.get(tokenManagerProperties.getPnResourceType().toString()).get(pnMatchType.toString()).get(tokenManagerProperties.getResourceId());
            if (token != null) {
                return token;
            }
        } else {
            HashMap<String, String> stringTokenWrapperHashMap = this.map.get(tokenManagerProperties.getPnResourceType().toString()).get(pnMatchType.toString());
            if (!stringTokenWrapperHashMap.keySet().isEmpty()) {
                String firstKey = (String)stringTokenWrapperHashMap.keySet().toArray()[0];
                return stringTokenWrapperHashMap.get(firstKey);
            }
        }
        return null;
    }

    private String getExtendedResourceType(String resourceTypeAbbreviation) {
        switch (resourceTypeAbbreviation) {
            case "usr": {
                return PNResourceType.USER.toString();
            }
            case "spc": {
                return PNResourceType.SPACE.toString();
            }
        }
        return resourceTypeAbbreviation;
    }

    private String getShortenedMatchType(PNMatchType pnMatchType) {
        switch (pnMatchType) {
            case RESOURCE: {
                return "res";
            }
            case PATTERN: {
                return "pat";
            }
        }
        return pnMatchType.toString();
    }
}

