/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.models.server.access_manager.v3;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.models.consumer.access_manager.v3.Channel;
import com.pubnub.api.models.consumer.access_manager.v3.Group;
import com.pubnub.api.models.consumer.access_manager.v3.PNResource;
import com.pubnub.api.models.consumer.access_manager.v3.Space;
import com.pubnub.api.models.consumer.access_manager.v3.User;
import java.util.List;
import java.util.logging.Logger;

public class GrantTokenRequestBody {
    private static final Logger log = Logger.getLogger(GrantTokenRequestBody.class.getName());
    private static final int READ = 1;
    private static final int WRITE = 2;
    private static final int MANAGE = 4;
    private static final int DELETE = 8;
    private static final int CREATE = 16;
    private Integer ttl;
    private List<Channel> channels;
    private List<Group> groups;
    private List<User> users;
    private List<Space> spaces;
    private Object meta;
    private PubNub pubNub;

    public JsonObject assemble() throws PubNubException {
        JsonObject payload = new JsonObject();
        payload.addProperty("ttl", (Number)this.ttl);
        JsonObject permissions = new JsonObject();
        JsonObject resources = new JsonObject();
        JsonObject patterns = new JsonObject();
        this.parse(this.channels, "channels", resources, patterns);
        this.parse(this.groups, "groups", resources, patterns);
        this.parse(this.users, "users", resources, patterns);
        this.parse(this.spaces, "spaces", resources, patterns);
        permissions.add("resources", (JsonElement)resources);
        permissions.add("patterns", (JsonElement)patterns);
        if (this.meta != null) {
            try {
                permissions.add("meta", (JsonElement)this.pubNub.getMapper().convertValue(this.meta, JsonObject.class));
            }
            catch (PubNubException e) {
                throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INVALID_META).build();
            }
        } else {
            permissions.add("meta", (JsonElement)new JsonObject());
        }
        payload.add("permissions", (JsonElement)permissions);
        return payload;
    }

    private void parse(List<? extends PNResource> list, String resourceSetName, JsonObject resources, JsonObject patterns) throws PubNubException {
        if (list != null) {
            for (PNResource pNResource : list) {
                JsonObject resourceObject = new JsonObject();
                JsonObject determinedObject = pNResource.isPatternResource() ? patterns : resources;
                if (determinedObject.has(resourceSetName)) {
                    determinedObject.get(resourceSetName).getAsJsonObject().addProperty(pNResource.getId(), (Number)this.calculateBitmask(pNResource));
                    continue;
                }
                resourceObject.addProperty(pNResource.getId(), (Number)this.calculateBitmask(pNResource));
                determinedObject.add(resourceSetName, (JsonElement)resourceObject);
            }
        }
        if (!resources.has(resourceSetName)) {
            resources.add(resourceSetName, (JsonElement)new JsonObject());
        }
        if (!patterns.has(resourceSetName)) {
            patterns.add(resourceSetName, (JsonElement)new JsonObject());
        }
    }

    private int calculateBitmask(PNResource resource) throws PubNubException {
        int sum = 0;
        if (resource.isRead()) {
            ++sum;
        }
        if (resource.isWrite()) {
            sum += 2;
        }
        if (resource.isManage()) {
            sum += 4;
        }
        if (resource.isDelete()) {
            sum += 8;
        }
        if (resource.isCreate()) {
            sum += 16;
        }
        if (sum == 0) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PERMISSION_MISSING).errormsg("No permissions specified for resource: ".concat(resource.getId())).build();
        }
        return sum;
    }

    GrantTokenRequestBody(Integer ttl, List<Channel> channels, List<Group> groups, List<User> users, List<Space> spaces, Object meta, PubNub pubNub) {
        this.ttl = ttl;
        this.channels = channels;
        this.groups = groups;
        this.users = users;
        this.spaces = spaces;
        this.meta = meta;
        this.pubNub = pubNub;
    }

    public static GrantTokenRequestBodyBuilder builder() {
        return new GrantTokenRequestBodyBuilder();
    }

    public static class GrantTokenRequestBodyBuilder {
        private Integer ttl;
        private List<Channel> channels;
        private List<Group> groups;
        private List<User> users;
        private List<Space> spaces;
        private Object meta;
        private PubNub pubNub;

        GrantTokenRequestBodyBuilder() {
        }

        public GrantTokenRequestBodyBuilder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public GrantTokenRequestBodyBuilder channels(List<Channel> channels) {
            this.channels = channels;
            return this;
        }

        public GrantTokenRequestBodyBuilder groups(List<Group> groups) {
            this.groups = groups;
            return this;
        }

        public GrantTokenRequestBodyBuilder users(List<User> users) {
            this.users = users;
            return this;
        }

        public GrantTokenRequestBodyBuilder spaces(List<Space> spaces) {
            this.spaces = spaces;
            return this;
        }

        public GrantTokenRequestBodyBuilder meta(Object meta) {
            this.meta = meta;
            return this;
        }

        public GrantTokenRequestBodyBuilder pubNub(PubNub pubNub) {
            this.pubNub = pubNub;
            return this;
        }

        public GrantTokenRequestBody build() {
            return new GrantTokenRequestBody(this.ttl, this.channels, this.groups, this.users, this.spaces, this.meta, this.pubNub);
        }

        public String toString() {
            return "GrantTokenRequestBody.GrantTokenRequestBodyBuilder(ttl=" + this.ttl + ", channels=" + this.channels + ", groups=" + this.groups + ", users=" + this.users + ", spaces=" + this.spaces + ", meta=" + this.meta + ", pubNub=" + this.pubNub + ")";
        }
    }
}

