/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.workers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.managers.DuplicationManager;
import com.pubnub.api.managers.ListenerManager;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.models.consumer.PNErrorData;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.message_actions.PNMessageAction;
import com.pubnub.api.models.consumer.objects_api.space.PNSpace;
import com.pubnub.api.models.consumer.objects_api.user.PNUser;
import com.pubnub.api.models.consumer.pubsub.BasePubSubResult;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.api.models.consumer.pubsub.objects.ObjectPayload;
import com.pubnub.api.models.consumer.pubsub.objects.PNMembershipResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNSpaceResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNUserResult;
import com.pubnub.api.models.server.PresenceEnvelope;
import com.pubnub.api.models.server.PublishMetaData;
import com.pubnub.api.models.server.SubscribeMessage;
import com.pubnub.api.vendor.Crypto;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeMessageWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SubscribeMessageWorker.class);
    private final int typeMessage = 0;
    private final int typeSignal = 1;
    private final int typeObject = 2;
    private final int typeMessageAction = 3;
    private PubNub pubnub;
    private ListenerManager listenerManager;
    private LinkedBlockingQueue<SubscribeMessage> queue;
    private DuplicationManager duplicationManager;
    private boolean isRunning;

    public SubscribeMessageWorker(PubNub pubnubInstance, ListenerManager listenerManagerInstance, LinkedBlockingQueue<SubscribeMessage> queueInstance, DuplicationManager dupManager) {
        this.pubnub = pubnubInstance;
        this.listenerManager = listenerManagerInstance;
        this.queue = queueInstance;
        this.duplicationManager = dupManager;
    }

    @Override
    public void run() {
        this.takeMessage();
    }

    private void takeMessage() {
        this.isRunning = true;
        while (this.isRunning) {
            try {
                this.processIncomingPayload(this.queue.take());
            }
            catch (InterruptedException e) {
                this.isRunning = false;
                log.trace("take message interrupted", (Throwable)e);
            }
        }
    }

    private JsonElement processMessage(SubscribeMessage subscribeMessage) {
        JsonElement outputObject;
        String outputText;
        JsonElement input = subscribeMessage.getPayload();
        if (this.pubnub.getConfiguration().getCipherKey() == null) {
            return input;
        }
        if (!subscribeMessage.supportsEncryption()) {
            return input;
        }
        Crypto crypto = new Crypto(this.pubnub.getConfiguration().getCipherKey());
        MapperManager mapper = this.pubnub.getMapper();
        String inputText = mapper.isJsonObject(input) && mapper.hasField(input, "pn_other") ? mapper.elementToString(input, "pn_other") : mapper.elementToString(input);
        try {
            outputText = crypto.decrypt(inputText);
        }
        catch (PubNubException e) {
            PNStatus pnStatus = PNStatus.builder().error(true).errorData(new PNErrorData(e.getMessage(), e)).operation(PNOperationType.PNSubscribeOperation).category(PNStatusCategory.PNDecryptionErrorCategory).build();
            this.listenerManager.announce(pnStatus);
            return null;
        }
        try {
            outputObject = mapper.fromJson(outputText, JsonElement.class);
        }
        catch (PubNubException e) {
            PNStatus pnStatus = PNStatus.builder().error(true).errorData(new PNErrorData(e.getMessage(), e)).operation(PNOperationType.PNSubscribeOperation).category(PNStatusCategory.PNMalformedResponseCategory).build();
            this.listenerManager.announce(pnStatus);
            return null;
        }
        if (mapper.isJsonObject(input) && mapper.hasField(input, "pn_other")) {
            JsonObject objectNode = mapper.getAsObject(input);
            mapper.putOnObject(objectNode, "pn_other", outputObject);
            outputObject = objectNode;
        }
        return outputObject;
    }

    private void processIncomingPayload(SubscribeMessage message) {
        MapperManager mapper = this.pubnub.getMapper();
        String channel = message.getChannel();
        String subscriptionMatch = message.getSubscriptionMatch();
        PublishMetaData publishMetaData = message.getPublishMetaData();
        if (channel != null && channel.equals(subscriptionMatch)) {
            subscriptionMatch = null;
        }
        if (this.pubnub.getConfiguration().isDedupOnSubscribe()) {
            if (this.duplicationManager.isDuplicate(message)) {
                return;
            }
            this.duplicationManager.addEntry(message);
        }
        if (message.getChannel().endsWith("-pnpres")) {
            PresenceEnvelope presencePayload = (PresenceEnvelope)mapper.convertValue(message.getPayload(), PresenceEnvelope.class);
            String strippedPresenceChannel = null;
            String strippedPresenceSubscription = null;
            if (channel != null) {
                strippedPresenceChannel = PubNubUtil.replaceLast(channel, "-pnpres", "");
            }
            if (subscriptionMatch != null) {
                strippedPresenceSubscription = PubNubUtil.replaceLast(subscriptionMatch, "-pnpres", "");
            }
            JsonElement isHereNowRefresh = message.getPayload().getAsJsonObject().get("here_now_refresh");
            PNPresenceEventResult pnPresenceEventResult = PNPresenceEventResult.builder().event(presencePayload.getAction()).actualChannel(subscriptionMatch != null ? channel : null).subscribedChannel(subscriptionMatch != null ? subscriptionMatch : channel).channel(strippedPresenceChannel).subscription(strippedPresenceSubscription).state(presencePayload.getData()).timetoken(publishMetaData.getPublishTimetoken()).occupancy(presencePayload.getOccupancy()).uuid(presencePayload.getUuid()).timestamp(presencePayload.getTimestamp()).join(this.getDelta(message.getPayload().getAsJsonObject().get("join"))).leave(this.getDelta(message.getPayload().getAsJsonObject().get("leave"))).timeout(this.getDelta(message.getPayload().getAsJsonObject().get("timeout"))).hereNowRefresh(isHereNowRefresh != null && isHereNowRefresh.getAsBoolean()).build();
            this.listenerManager.announce(pnPresenceEventResult);
        } else {
            JsonElement extractedMessage = this.processMessage(message);
            if (extractedMessage == null) {
                log.debug("unable to parse payload on #processIncomingMessages");
            }
            BasePubSubResult result = BasePubSubResult.builder().actualChannel(subscriptionMatch != null ? channel : null).subscribedChannel(subscriptionMatch != null ? subscriptionMatch : channel).channel(channel).subscription(subscriptionMatch).timetoken(publishMetaData.getPublishTimetoken()).publisher(message.getIssuingClientId()).userMetadata(message.getUserMetadata()).build();
            if (message.getType() == null) {
                this.listenerManager.announce(new PNMessageResult(result, extractedMessage));
            } else if (message.getType() == 0) {
                this.listenerManager.announce(new PNMessageResult(result, extractedMessage));
            } else if (message.getType() == 1) {
                this.listenerManager.announce(new PNSignalResult(result, extractedMessage));
            } else if (message.getType() == 2) {
                String type;
                ObjectPayload objectPayload = (ObjectPayload)mapper.convertValue(extractedMessage, ObjectPayload.class);
                switch (type = objectPayload.getType()) {
                    case "user": {
                        this.listenerManager.announce(PNUserResult.userBuilder().result(result).event(objectPayload.getEvent()).user((PNUser)mapper.convertValue(objectPayload.getData(), PNUser.class)).build());
                        break;
                    }
                    case "space": {
                        this.listenerManager.announce(PNSpaceResult.spaceBuilder().result(result).event(objectPayload.getEvent()).space((PNSpace)mapper.convertValue(objectPayload.getData(), PNSpace.class)).build());
                        break;
                    }
                    case "membership": {
                        this.listenerManager.announce(PNMembershipResult.membershipBuilder().result(result).event(objectPayload.getEvent()).data(objectPayload.getData()).build());
                        break;
                    }
                }
            } else if (message.getType() == 3) {
                ObjectPayload objectPayload = (ObjectPayload)mapper.convertValue(extractedMessage, ObjectPayload.class);
                JsonObject data = objectPayload.getData().getAsJsonObject();
                if (!data.has("uuid")) {
                    data.addProperty("uuid", result.getPublisher());
                }
                this.listenerManager.announce(PNMessageActionResult.actionBuilder().result(result).event(objectPayload.getEvent()).data((PNMessageAction)mapper.convertValue((JsonElement)data, PNMessageAction.class)).build());
            }
        }
    }

    private List<String> getDelta(JsonElement delta) {
        ArrayList<String> list = new ArrayList<String>();
        if (delta != null) {
            JsonArray jsonArray = delta.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(jsonArray.get(i).getAsString());
            }
        }
        return list;
    }
}

