/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.push;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.endpoints.push.PushService;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNPushType;
import com.pubnub.api.models.consumer.push.PNPushRemoveChannelResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class RemoveChannelsFromPush
extends Endpoint<List<Object>, PNPushRemoveChannelResult> {
    private PNPushType pushType;
    private List<String> channels = new ArrayList<String>();
    private String deviceId;

    public RemoveChannelsFromPush(PubNub pubnub, Retrofit retrofit) {
        super(pubnub, retrofit);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return null;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (this.pushType == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PUSH_TYPE_MISSING).build();
        }
        if (this.deviceId == null || this.deviceId.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_DEVICE_ID_MISSING).build();
        }
        if (this.channels.size() == 0) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
    }

    @Override
    protected Call<List<Object>> doWork(Map<String, String> baseParams) throws PubNubException {
        baseParams.put("type", this.pushType.name().toLowerCase());
        if (this.channels.size() != 0) {
            baseParams.put("remove", PubNubUtil.joinString(this.channels, ","));
        }
        PushService service = (PushService)this.getRetrofit().create(PushService.class);
        return service.modifyChannelsForDevice(this.getPubnub().getConfiguration().getSubscribeKey(), this.deviceId, baseParams);
    }

    @Override
    protected PNPushRemoveChannelResult createResponse(Response<List<Object>> input) throws PubNubException {
        if (input.body() == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PARSING_ERROR).build();
        }
        return PNPushRemoveChannelResult.builder().build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNRemovePushNotificationsFromChannelsOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public RemoveChannelsFromPush pushType(PNPushType pushType) {
        this.pushType = pushType;
        return this;
    }

    public RemoveChannelsFromPush channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public RemoveChannelsFromPush deviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }
}

