/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.interceptors;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class SignatureInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(SignatureInterceptor.class.getName());
    private PubNub pubNub;

    public SignatureInterceptor(PubNub pubNubInstance) {
        this.pubNub = pubNubInstance;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        if (this.pubNub.getConfiguration().getSecretKey() == null) {
            return chain.proceed(originalRequest);
        }
        HttpUrl url = chain.request().url();
        String requestURL = url.encodedPath();
        int timestamp = this.pubNub.getTimestamp();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        String signature = "";
        for (String queryKey : url.queryParameterNames()) {
            queryParams.put(queryKey, url.queryParameter(queryKey));
        }
        queryParams.put("timestamp", String.valueOf(timestamp));
        String signInput = this.pubNub.getConfiguration().getSubscribeKey() + "\n" + this.pubNub.getConfiguration().getPublishKey() + "\n";
        signInput = requestURL.startsWith("/v1/auth/audit") ? signInput + "audit\n" : (requestURL.startsWith("/v1/auth/grant") ? signInput + "grant\n" : signInput + requestURL + "\n");
        signInput = signInput + PubNubUtil.preparePamArguments(queryParams);
        try {
            signature = PubNubUtil.signSHA256(this.pubNub.getConfiguration().getSecretKey(), signInput);
        }
        catch (PubNubException e) {
            log.warning("signature failed on SignatureInterceptor: " + e.toString());
        }
        HttpUrl rebuiltUrl = url.newBuilder().addQueryParameter("timestamp", String.valueOf(timestamp)).addQueryParameter("signature", signature).build();
        Request request = chain.request().newBuilder().url(rebuiltUrl).build();
        return chain.proceed(request);
    }
}

