/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PubNub;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.callbacks.ReconnectionCallback;
import com.pubnub.api.enums.PNReconnectionPolicy;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.PNTimeResult;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectionManager {
    private static final Logger log = LoggerFactory.getLogger(ReconnectionManager.class);
    private static final int INTERVAL = 3;
    private static final int MINEXPONENTIALBACKOFF = 1;
    private static final int MAXEXPONENTIALBACKOFF = 32;
    private ReconnectionCallback callback;
    private PubNub pubnub;
    private int exponentialMultiplier = 1;
    private int failedCalls = 0;
    private static final int MILLISECONDS = 1000;
    private Timer timer;

    public ReconnectionManager(PubNub pubnubInstance) {
        this.pubnub = pubnubInstance;
    }

    public ReconnectionManager setReconnectionListener(ReconnectionCallback reconnectionCallback) {
        this.callback = reconnectionCallback;
        return this;
    }

    public void startPolling() {
        if (this.pubnub.getConfiguration().getReconnectionPolicy() == PNReconnectionPolicy.NONE) {
            log.warn("reconnection policy is disabled, please handle reconnection manually.");
            return;
        }
        this.exponentialMultiplier = 1;
        this.failedCalls = 0;
        this.registerHeartbeatTimer();
    }

    private void registerHeartbeatTimer() {
        this.stopHeartbeatTimer();
        if (this.pubnub.getConfiguration().getReconnectionPolicy() == PNReconnectionPolicy.NONE) {
            log.warn("reconnection policy is disabled, please handle reconnection manually.");
            return;
        }
        int maxRetries = this.pubnub.getConfiguration().getMaximumReconnectionRetries();
        if (maxRetries != -1 && this.failedCalls >= maxRetries) {
            this.callback.onMaxReconnectionExhaustion();
            return;
        }
        this.timer = new Timer();
        int timerInterval = 3;
        if (this.pubnub.getConfiguration().getReconnectionPolicy() == PNReconnectionPolicy.EXPONENTIAL) {
            timerInterval = (int)(Math.pow(2.0, this.exponentialMultiplier) - 1.0);
            if (timerInterval > 32) {
                timerInterval = 1;
                this.exponentialMultiplier = 1;
                log.debug("timerInterval > MAXEXPONENTIALBACKOFF at: " + Calendar.getInstance().getTime().toString());
            } else if (timerInterval < 1) {
                timerInterval = 1;
            }
            log.debug("timerInterval = " + String.valueOf(timerInterval) + " at: " + Calendar.getInstance().getTime().toString());
        }
        if (this.pubnub.getConfiguration().getReconnectionPolicy() == PNReconnectionPolicy.LINEAR) {
            timerInterval = 3;
        }
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ReconnectionManager.this.callTime();
            }
        }, timerInterval * 1000, (long)(timerInterval * 1000));
    }

    private void stopHeartbeatTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void callTime() {
        try {
            this.pubnub.time().async(new PNCallback<PNTimeResult>(){

                @Override
                public void onResponse(PNTimeResult result, PNStatus status) {
                    if (!status.isError()) {
                        ReconnectionManager.this.stopHeartbeatTimer();
                        ReconnectionManager.this.callback.onReconnection();
                    } else {
                        log.debug("callTime() at: " + Calendar.getInstance().getTime().toString());
                        ReconnectionManager.this.exponentialMultiplier++;
                        ReconnectionManager.this.failedCalls++;
                        ReconnectionManager.this.registerHeartbeatTimer();
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

