/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.endpoints.vendor.AppEngineFactory;
import com.pubnub.api.enums.PNLogVerbosity;
import com.pubnub.api.interceptors.SignatureInterceptor;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;

public class RetrofitManager {
    private PubNub pubnub;
    private SignatureInterceptor signatureInterceptor;
    private OkHttpClient transactionClientInstance;
    private OkHttpClient subscriptionClientInstance;
    private Retrofit transactionInstance;
    private Retrofit subscriptionInstance;

    public RetrofitManager(PubNub pubNubInstance) {
        this.pubnub = pubNubInstance;
        this.signatureInterceptor = new SignatureInterceptor(pubNubInstance);
        this.transactionClientInstance = this.createOkHttpClient(this.pubnub.getConfiguration().getNonSubscribeRequestTimeout(), this.pubnub.getConfiguration().getConnectTimeout());
        this.subscriptionClientInstance = this.createOkHttpClient(this.pubnub.getConfiguration().getSubscribeTimeout(), this.pubnub.getConfiguration().getConnectTimeout());
        this.transactionInstance = this.createRetrofit(this.transactionClientInstance);
        this.subscriptionInstance = this.createRetrofit(this.subscriptionClientInstance);
    }

    private OkHttpClient createOkHttpClient(int requestTimeout, int connectTimeOut) {
        PNConfiguration pnConfiguration = this.pubnub.getConfiguration();
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        httpClient.readTimeout((long)requestTimeout, TimeUnit.SECONDS);
        httpClient.connectTimeout((long)connectTimeOut, TimeUnit.SECONDS);
        if (this.pubnub.getConfiguration().getLogVerbosity() == PNLogVerbosity.BODY) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
            httpClient.addInterceptor((Interceptor)logging);
        }
        if (pnConfiguration.getSslSocketFactory() != null && pnConfiguration.getX509ExtendedTrustManager() != null) {
            httpClient.sslSocketFactory(pnConfiguration.getSslSocketFactory(), (X509TrustManager)pnConfiguration.getX509ExtendedTrustManager());
        }
        if (pnConfiguration.getConnectionSpec() != null) {
            httpClient.connectionSpecs(Collections.singletonList(pnConfiguration.getConnectionSpec()));
        }
        if (pnConfiguration.getHostnameVerifier() != null) {
            httpClient.hostnameVerifier(pnConfiguration.getHostnameVerifier());
        }
        if (this.pubnub.getConfiguration().getProxy() != null) {
            httpClient.proxy(this.pubnub.getConfiguration().getProxy());
        }
        if (this.pubnub.getConfiguration().getProxySelector() != null) {
            httpClient.proxySelector(this.pubnub.getConfiguration().getProxySelector());
        }
        if (this.pubnub.getConfiguration().getProxyAuthenticator() != null) {
            httpClient.proxyAuthenticator(this.pubnub.getConfiguration().getProxyAuthenticator());
        }
        httpClient.addInterceptor((Interceptor)this.signatureInterceptor);
        return httpClient.build();
    }

    private Retrofit createRetrofit(OkHttpClient client) {
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder();
        if (this.pubnub.getConfiguration().isGoogleAppEngineNetworking()) {
            retrofitBuilder.callFactory((Call.Factory)new AppEngineFactory.Factory());
        }
        return retrofitBuilder.baseUrl(this.pubnub.getBaseUrl()).addConverterFactory(this.pubnub.getMapper().getConverterFactory()).client(client).build();
    }

    public void destroy() {
        this.closeExecutor(this.transactionClientInstance);
        this.closeExecutor(this.subscriptionClientInstance);
    }

    private void closeExecutor(OkHttpClient client) {
        client.connectionPool().evictAll();
        client.dispatcher().cancelAll();
        ExecutorService executorService = client.dispatcher().executorService();
        executorService.shutdown();
    }

    public Retrofit getTransactionInstance() {
        return this.transactionInstance;
    }

    public Retrofit getSubscriptionInstance() {
        return this.subscriptionInstance;
    }
}

