/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.builder.dto.StateOperation;
import com.pubnub.api.builder.dto.SubscribeOperation;
import com.pubnub.api.builder.dto.UnsubscribeOperation;
import com.pubnub.api.models.SubscriptionItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StateManager {
    private Map<String, SubscriptionItem> channels = new HashMap<String, SubscriptionItem>();
    private Map<String, SubscriptionItem> presenceChannels = new HashMap<String, SubscriptionItem>();
    private Map<String, SubscriptionItem> groups = new HashMap<String, SubscriptionItem>();
    private Map<String, SubscriptionItem> presenceGroups = new HashMap<String, SubscriptionItem>();

    public synchronized void adaptSubscribeBuilder(SubscribeOperation subscribeOperation) {
        SubscriptionItem presenceSubscriptionItem;
        SubscriptionItem subscriptionItem;
        for (String channel : subscribeOperation.getChannels()) {
            subscriptionItem = new SubscriptionItem().setName(channel);
            this.channels.put(channel, subscriptionItem);
            if (!subscribeOperation.isPresenceEnabled()) continue;
            presenceSubscriptionItem = new SubscriptionItem().setName(channel);
            this.presenceChannels.put(channel, presenceSubscriptionItem);
        }
        for (String channelGroup : subscribeOperation.getChannelGroups()) {
            subscriptionItem = new SubscriptionItem().setName(channelGroup);
            this.groups.put(channelGroup, subscriptionItem);
            if (!subscribeOperation.isPresenceEnabled()) continue;
            presenceSubscriptionItem = new SubscriptionItem().setName(channelGroup);
            this.presenceGroups.put(channelGroup, presenceSubscriptionItem);
        }
    }

    public synchronized void adaptStateBuilder(StateOperation stateOperation) {
        for (String channel : stateOperation.getChannels()) {
            SubscriptionItem subscribedChannel = this.channels.get(channel);
            if (subscribedChannel == null) continue;
            subscribedChannel.setState(stateOperation.getState());
        }
        for (String channelGroup : stateOperation.getChannelGroups()) {
            SubscriptionItem subscribedChannelGroup = this.groups.get(channelGroup);
            if (subscribedChannelGroup == null) continue;
            subscribedChannelGroup.setState(stateOperation.getState());
        }
    }

    public synchronized void adaptUnsubscribeBuilder(UnsubscribeOperation unsubscribeOperation) {
        for (String channel : unsubscribeOperation.getChannels()) {
            this.channels.remove(channel);
            this.presenceChannels.remove(channel);
        }
        for (String channelGroup : unsubscribeOperation.getChannelGroups()) {
            this.groups.remove(channelGroup);
            this.presenceGroups.remove(channelGroup);
        }
    }

    public synchronized Map<String, Object> createStatePayload() {
        HashMap<String, Object> stateResponse = new HashMap<String, Object>();
        for (SubscriptionItem channel : this.channels.values()) {
            if (channel.getState() == null) continue;
            stateResponse.put(channel.getName(), channel.getState());
        }
        for (SubscriptionItem channelGroup : this.groups.values()) {
            if (channelGroup.getState() == null) continue;
            stateResponse.put(channelGroup.getName(), channelGroup.getState());
        }
        return stateResponse;
    }

    public synchronized List<String> prepareChannelList(boolean includePresence) {
        return this.prepareMembershipList(this.channels, this.presenceChannels, includePresence);
    }

    public synchronized List<String> prepareChannelGroupList(boolean includePresence) {
        return this.prepareMembershipList(this.groups, this.presenceGroups, includePresence);
    }

    public synchronized boolean isEmpty() {
        return this.channels.isEmpty() && this.presenceChannels.isEmpty() && this.groups.isEmpty() && this.presenceGroups.isEmpty();
    }

    private synchronized List<String> prepareMembershipList(Map<String, SubscriptionItem> dataStorage, Map<String, SubscriptionItem> presenceStorage, boolean includePresence) {
        ArrayList<String> response = new ArrayList<String>();
        for (SubscriptionItem channelGroupItem : dataStorage.values()) {
            response.add(channelGroupItem.getName());
        }
        if (includePresence) {
            for (SubscriptionItem presenceChannelGroupItem : presenceStorage.values()) {
                response.add(presenceChannelGroupItem.getName().concat("-pnpres"));
            }
        }
        return response;
    }
}

