// Generated by delombok at Thu Nov 04 11:41:07 UTC 2021
package com.pubnub.api.endpoints.push;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNPushEnvironment;
import com.pubnub.api.enums.PNPushType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.push.PNPushAddChannelResult;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class AddChannelsToPush extends Endpoint<List<Object>, PNPushAddChannelResult> {
    private PNPushType pushType;
    private List<String> channels;
    private String deviceId;
    private PNPushEnvironment environment;
    private String topic;

    public AddChannelsToPush(PubNub pubnub, TelemetryManager telemetryManager, RetrofitManager retrofit, TokenManager tokenManager) {
        super(pubnub, telemetryManager, retrofit, tokenManager);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return channels;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return null;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (pushType == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PUSH_TYPE_MISSING).build();
        }
        if (deviceId == null || deviceId.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_DEVICE_ID_MISSING).build();
        }
        if (channels == null || channels.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
        if (pushType == PNPushType.APNS2) {
            if (topic == null || topic.isEmpty()) {
                throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PUSH_TOPIC_MISSING).build();
            }
            if (environment == null) {
                environment = PNPushEnvironment.DEVELOPMENT;
            }
        }
    }

    @Override
    protected Call<List<Object>> doWork(Map<String, String> baseParams) throws PubNubException {
        baseParams.put("add", PubNubUtil.joinString(channels, ","));
        if (pushType != PNPushType.APNS2) {
            baseParams.put("type", pushType.toString());
            return this.getRetrofit().getPushService().modifyChannelsForDevice(this.getPubnub().getConfiguration().getSubscribeKey(), deviceId, baseParams);
        } else {
            baseParams.put("environment", environment.name().toLowerCase());
            baseParams.put("topic", topic);
            return this.getRetrofit().getPushService().modifyChannelsForDeviceApns2(this.getPubnub().getConfiguration().getSubscribeKey(), deviceId, baseParams);
        }
    }

    @Override
    protected PNPushAddChannelResult createResponse(Response<List<Object>> input) throws PubNubException {
        if (input.body() == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PARSING_ERROR).build();
        }
        return PNPushAddChannelResult.builder().build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNPushNotificationEnabledChannelsOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    @java.lang.SuppressWarnings("all")
    public AddChannelsToPush pushType(final PNPushType pushType) {
        this.pushType = pushType;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    public AddChannelsToPush channels(final List<String> channels) {
        this.channels = channels;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    public AddChannelsToPush deviceId(final String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    public AddChannelsToPush environment(final PNPushEnvironment environment) {
        this.environment = environment;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    public AddChannelsToPush topic(final String topic) {
        this.topic = topic;
        return this;
    }
}
