// Generated by delombok at Thu Nov 04 11:41:07 UTC 2021
package com.pubnub.api.endpoints.remoteaction;

import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.models.consumer.PNErrorData;
import com.pubnub.api.models.consumer.PNStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public class RetryingRemoteAction<T> implements RemoteAction<T> {
    private final RemoteAction<T> remoteAction;
    private final int maxNumberOfAutomaticRetries;
    private final PNOperationType operationType;
    private final ExecutorService executorService;
    private PNCallback<T> cachedCallback;

    public RetryingRemoteAction(RemoteAction<T> remoteAction, int maxNumberOfAutomaticRetries, PNOperationType operationType, ExecutorService executorService) {
        this.remoteAction = remoteAction;
        this.maxNumberOfAutomaticRetries = maxNumberOfAutomaticRetries;
        this.operationType = operationType;
        this.executorService = executorService;
    }

    public static <T> RetryingRemoteAction<T> autoRetry(RemoteAction<T> remoteAction, int maxNumberOfAutomaticRetries, PNOperationType operationType, ExecutorService executorService) {
        return new RetryingRemoteAction<>(remoteAction, maxNumberOfAutomaticRetries, operationType, executorService);
    }

    @Override
    public T sync() throws PubNubException {
        validate();
        PubNubException thrownException = null;
        for (int i = 0; i < maxNumberOfAutomaticRetries; i++) {
            try {
                return remoteAction.sync();
            } catch (PubNubException ex) {
                thrownException = ex;
            }
        }
        //noinspection ConstantConditions
        throw thrownException;
    }

    @Override
    public void async(@NotNull PNCallback<T> callback) {
        cachedCallback = callback;
        executorService.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    validate();
                } catch (PubNubException ex) {
                    callback.onResponse(null, PNStatus.builder().executedEndpoint(RetryingRemoteAction.this).operation(operationType).error(true).errorData(new PNErrorData(ex.getErrormsg(), ex)).build());
                    return;
                }
                ResultAndStatus<T> lastResultAndStatus = null;
                for (int i = 0; i < maxNumberOfAutomaticRetries; i++) {
                    lastResultAndStatus = syncAsync();
                    if (!lastResultAndStatus.status.isError()) {
                        callback.onResponse(lastResultAndStatus.result, lastResultAndStatus.status);
                        return;
                    }
                }
                //noinspection ConstantConditions
                callback.onResponse(lastResultAndStatus.result, lastResultAndStatus.status);
            }
        });
    }

    @Override
    public void retry() {
        async(cachedCallback);
    }

    @Override
    public void silentCancel() {
        remoteAction.silentCancel();
    }


    private static class ResultAndStatus<T> {
        private final T result;
        private final PNStatus status;

        @java.lang.SuppressWarnings("all")
        public ResultAndStatus(final T result, final PNStatus status) {
            this.result = result;
            this.status = status;
        }

        @java.lang.SuppressWarnings("all")
        public T getResult() {
            return this.result;
        }

        @java.lang.SuppressWarnings("all")
        public PNStatus getStatus() {
            return this.status;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof RetryingRemoteAction.ResultAndStatus)) return false;
            final RetryingRemoteAction.ResultAndStatus<?> other = (RetryingRemoteAction.ResultAndStatus<?>) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$result = this.getResult();
            final java.lang.Object other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) return false;
            final java.lang.Object this$status = this.getStatus();
            final java.lang.Object other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof RetryingRemoteAction.ResultAndStatus;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $result = this.getResult();
            result = result * PRIME + ($result == null ? 43 : $result.hashCode());
            final java.lang.Object $status = this.getStatus();
            result = result * PRIME + ($status == null ? 43 : $status.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "RetryingRemoteAction.ResultAndStatus(result=" + this.getResult() + ", status=" + this.getStatus() + ")";
        }
    }

    private ResultAndStatus<T> syncAsync() {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<ResultAndStatus<T>> atomicResultAndStatus = new AtomicReference<>();
        remoteAction.async(new PNCallback<T>() {
            @Override
            public void onResponse(@Nullable T result, @NotNull PNStatus status) {
                atomicResultAndStatus.set(new ResultAndStatus<>(result, status.toBuilder().executedEndpoint(RetryingRemoteAction.this).build()));
                latch.countDown();
            }
        });
        try {
            latch.await();
            return atomicResultAndStatus.get();
        } catch (InterruptedException e) {
            remoteAction.silentCancel();
            return new ResultAndStatus<>(null, PNStatus.builder().category(PNStatusCategory.PNUnknownCategory).operation(operationType).errorData(new PNErrorData(e.getMessage(), e)).error(true).executedEndpoint(this).build());
        }
    }

    private void validate() throws PubNubException {
        if (maxNumberOfAutomaticRetries < 1) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INVALID_ARGUMENTS).errormsg("Number of retries cannot be less than 1").build();
        }
    }
}
