// Generated by delombok at Thu Nov 04 11:41:07 UTC 2021
package com.pubnub.api.models.consumer.push.payload;

import com.pubnub.api.enums.PNPushEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PushPayloadHelper {
    private Map<String, Object> commonPayload;
    private FCMPayload fcmPayload;
    private MPNSPayload mpnsPayload;
    private APNSPayload apnsPayload;

    public Map<String, Object> build() {
        Map<String, Object> payload = new HashMap<>();
        if (apnsPayload != null) {
            Map<String, Object> apnsMap = apnsPayload.toMap();
            if (!apnsMap.isEmpty()) {
                payload.put("pn_apns", apnsMap);
            }
        }
        if (fcmPayload != null) {
            Map<String, Object> fcmMap = fcmPayload.toMap();
            if (!fcmMap.isEmpty()) {
                payload.put("pn_gcm", fcmMap);
            }
        }
        if (mpnsPayload != null) {
            Map<String, Object> mpnsMap = mpnsPayload.toMap();
            if (!mpnsMap.isEmpty()) {
                payload.put("pn_mpns", mpnsMap);
            }
        }
        payload.putAll(filterNonNullEntries(commonPayload));
        return payload;
    }


    public static class APNSPayload implements PushPayloadSerializer {
        private APS aps;
        private List<APNS2Configuration> apns2Configurations;
        private Map<String, Object> custom;

        @Override
        public Map<String, Object> toMap() {
            Map<String, Object> map = new HashMap<>();
            if (aps != null) {
                Map<String, Object> apsMap = aps.toMap();
                if (apsMap != null && !apsMap.isEmpty()) {
                    map.put("aps", apsMap);
                }
            }
            if (apns2Configurations != null) {
                List<Map<String, Object>> pnPushArray = new ArrayList<>();
                for (APNS2Configuration configuration : apns2Configurations) {
                    Map<String, Object> pushItemMap = configuration.toMap();
                    if (pushItemMap != null && !pushItemMap.isEmpty()) {
                        pnPushArray.add(pushItemMap);
                    }
                }
                map.put("pn_push", pnPushArray);
            }
            map.putAll(filterNonNullEntries(custom));
            return map;
        }


        public static class APS implements PushPayloadSerializer {
            private Object alert;
            private Integer badge;
            private String sound;

            @Override
            public Map<String, Object> toMap() {
                Map<String, Object> map = new HashMap<>();
                if (alert != null) {
                    map.put("alert", alert);
                }
                if (badge != null) {
                    map.put("badge", badge);
                }
                if (sound != null) {
                    map.put("sound", sound);
                }
                return map;
            }

            @java.lang.SuppressWarnings("all")
            public APS setAlert(final Object alert) {
                this.alert = alert;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public APS setBadge(final Integer badge) {
                this.badge = badge;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public APS setSound(final String sound) {
                this.sound = sound;
                return this;
            }
        }


        public static class APNS2Configuration implements PushPayloadSerializer {
            private String collapseId;
            private String expiration;
            private List<Target> targets;
            private String version;

            @Override
            public Map<String, Object> toMap() {
                Map<String, Object> map = new HashMap<>();
                if (collapseId != null) {
                    map.put("collapse_id", collapseId);
                }
                if (expiration != null) {
                    map.put("expiration", expiration);
                }
                if (targets != null && !targets.isEmpty()) {
                    List<Map<String, Object>> targetsList = new ArrayList<>();
                    for (Target target : targets) {
                        Map<String, Object> targetMap = target.toMap();
                        if (targetMap != null && !targetMap.isEmpty()) {
                            targetsList.add(targetMap);
                        }
                    }
                    map.put("targets", targetsList);
                }
                if (version != null) {
                    map.put("version", version);
                }
                return map;
            }


            public static class Target implements PushPayloadSerializer {
                private String topic;
                private List<String> excludeDevices;
                private PNPushEnvironment environment;

                @Override
                public Map<String, Object> toMap() {
                    Map<String, Object> map = new HashMap<>();
                    if (topic != null) {
                        map.put("topic", topic);
                    }
                    if (excludeDevices != null && !excludeDevices.isEmpty()) {
                        map.put("excluded_devices", excludeDevices);
                    }
                    if (environment != null) {
                        map.put("environment", environment.name().toLowerCase());
                    }
                    return map;
                }

                @java.lang.SuppressWarnings("all")
                public Target setTopic(final String topic) {
                    this.topic = topic;
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                public Target setExcludeDevices(final List<String> excludeDevices) {
                    this.excludeDevices = excludeDevices;
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                public Target setEnvironment(final PNPushEnvironment environment) {
                    this.environment = environment;
                    return this;
                }
            }

            @java.lang.SuppressWarnings("all")
            public APNS2Configuration setCollapseId(final String collapseId) {
                this.collapseId = collapseId;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public APNS2Configuration setExpiration(final String expiration) {
                this.expiration = expiration;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public APNS2Configuration setTargets(final List<Target> targets) {
                this.targets = targets;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            public APNS2Configuration setVersion(final String version) {
                this.version = version;
                return this;
            }
        }

        @java.lang.SuppressWarnings("all")
        public APNSPayload setAps(final APS aps) {
            this.aps = aps;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public APNSPayload setApns2Configurations(final List<APNS2Configuration> apns2Configurations) {
            this.apns2Configurations = apns2Configurations;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public APNSPayload setCustom(final Map<String, Object> custom) {
            this.custom = custom;
            return this;
        }
    }

    // MPNS
    public static class MPNSPayload implements PushPayloadSerializer {
        private Integer count;
        private String backTitle;
        private String title;
        private String backContent;
        private String type;
        private Map<String, Object> custom;

        @Override
        public Map<String, Object> toMap() {
            Map<String, Object> map = new HashMap<>();
            if (count != null) {
                map.put("count", count);
            }
            if (backTitle != null) {
                map.put("back_title", backTitle);
            }
            if (title != null) {
                map.put("title", title);
            }
            if (backContent != null) {
                map.put("back_content", backContent);
            }
            if (type != null) {
                map.put("type", type);
            }
            map.putAll(filterNonNullEntries(custom));
            return map;
        }

        @java.lang.SuppressWarnings("all")
        public MPNSPayload setCount(final Integer count) {
            this.count = count;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public MPNSPayload setBackTitle(final String backTitle) {
            this.backTitle = backTitle;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public MPNSPayload setTitle(final String title) {
            this.title = title;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public MPNSPayload setBackContent(final String backContent) {
            this.backContent = backContent;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public MPNSPayload setType(final String type) {
            this.type = type;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public MPNSPayload setCustom(final Map<String, Object> custom) {
            this.custom = custom;
            return this;
        }
    }

    // FCM
    public static class FCMPayload implements PushPayloadSerializer {
        private Map<String, Object> custom;
        private Map<String, Object> data;
        private Notification notification;

        @Override
        public Map<String, Object> toMap() {
            Map<String, Object> map = new HashMap<>();
            if (notification != null) {
                Map<String, Object> notificationMap = notification.toMap();
                if (notificationMap != null && !notificationMap.isEmpty()) {
                    map.put("notification", notification.toMap());
                }
            }
            if (data != null && !data.isEmpty()) {
                map.put("data", data);
            }
            map.putAll(filterNonNullEntries(custom));
            return map;
        }


        public static class Notification implements PushPayloadSerializer {
            private Map<String, Object> parametersMap = new HashMap();

            public Notification set(String parameterName, Object parameterValue) {
                parametersMap.put(parameterName, parameterValue);
                return this;
            }

            public Notification setTitle(String title) {
                set("title", title);
                return this;
            }

            public Notification setBody(String body) {
                set("body", body);
                return this;
            }

            public Notification setImage(String image) {
                set("image", image);
                return this;
            }

            public Notification setClickAction(String clickAction) {
                set("click_action", clickAction);
                return this;
            }

            @Override
            public Map<String, Object> toMap() {
                return filterNonNullEntries(parametersMap);
            }

            @java.lang.SuppressWarnings("all")
            public Notification setParametersMap(final Map<String, Object> parametersMap) {
                this.parametersMap = parametersMap;
                return this;
            }
        }

        @java.lang.SuppressWarnings("all")
        public FCMPayload setCustom(final Map<String, Object> custom) {
            this.custom = custom;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public FCMPayload setData(final Map<String, Object> data) {
            this.data = data;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public FCMPayload setNotification(final Notification notification) {
            this.notification = notification;
            return this;
        }
    }

    // todo mapof
    private static Map<String, Object> filterNonNullEntries(Map<String, Object> targetMap) {
        if (targetMap == null) {
            return new HashMap<>();
        }
        Map<String, Object> map = new HashMap<>();
        for (Map.Entry<String, Object> entry : targetMap.entrySet()) {
            if (entry.getValue() != null) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    @java.lang.SuppressWarnings("all")
    public PushPayloadHelper setCommonPayload(final Map<String, Object> commonPayload) {
        this.commonPayload = commonPayload;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    public PushPayloadHelper setFcmPayload(final FCMPayload fcmPayload) {
        this.fcmPayload = fcmPayload;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    public PushPayloadHelper setMpnsPayload(final MPNSPayload mpnsPayload) {
        this.mpnsPayload = mpnsPayload;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    public PushPayloadHelper setApnsPayload(final APNSPayload apnsPayload) {
        this.apnsPayload = apnsPayload;
        return this;
    }
}
