// Generated by delombok at Thu Nov 04 11:41:07 UTC 2021
package com.pubnub.api.models.server.access_manager.v3;

import com.pubnub.api.PubNubException;
import com.pubnub.api.models.TokenBitmask;
import com.pubnub.api.models.consumer.access_manager.v3.ChannelGrant;
import com.pubnub.api.models.consumer.access_manager.v3.ChannelGroupGrant;
import com.pubnub.api.models.consumer.access_manager.v3.PNResource;
import com.pubnub.api.models.consumer.access_manager.v3.UUIDGrant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GrantTokenRequestBody {
    private final Integer ttl;
    private final GrantTokenPermissions permissions;


    private static class GrantTokenPermissions {
        private final GrantTokenPermission resources;
        private final GrantTokenPermission patterns;
        private final Object meta;
        private final String uuid;

        @java.lang.SuppressWarnings("all")
        public GrantTokenPermissions(final GrantTokenPermission resources, final GrantTokenPermission patterns, final Object meta, final String uuid) {
            this.resources = resources;
            this.patterns = patterns;
            this.meta = meta;
            this.uuid = uuid;
        }

        @java.lang.SuppressWarnings("all")
        public GrantTokenPermission getResources() {
            return this.resources;
        }

        @java.lang.SuppressWarnings("all")
        public GrantTokenPermission getPatterns() {
            return this.patterns;
        }

        @java.lang.SuppressWarnings("all")
        public Object getMeta() {
            return this.meta;
        }

        @java.lang.SuppressWarnings("all")
        public String getUuid() {
            return this.uuid;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof GrantTokenRequestBody.GrantTokenPermissions)) return false;
            final GrantTokenRequestBody.GrantTokenPermissions other = (GrantTokenRequestBody.GrantTokenPermissions) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$resources = this.getResources();
            final java.lang.Object other$resources = other.getResources();
            if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) return false;
            final java.lang.Object this$patterns = this.getPatterns();
            final java.lang.Object other$patterns = other.getPatterns();
            if (this$patterns == null ? other$patterns != null : !this$patterns.equals(other$patterns)) return false;
            final java.lang.Object this$meta = this.getMeta();
            final java.lang.Object other$meta = other.getMeta();
            if (this$meta == null ? other$meta != null : !this$meta.equals(other$meta)) return false;
            final java.lang.Object this$uuid = this.getUuid();
            final java.lang.Object other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof GrantTokenRequestBody.GrantTokenPermissions;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $resources = this.getResources();
            result = result * PRIME + ($resources == null ? 43 : $resources.hashCode());
            final java.lang.Object $patterns = this.getPatterns();
            result = result * PRIME + ($patterns == null ? 43 : $patterns.hashCode());
            final java.lang.Object $meta = this.getMeta();
            result = result * PRIME + ($meta == null ? 43 : $meta.hashCode());
            final java.lang.Object $uuid = this.getUuid();
            result = result * PRIME + ($uuid == null ? 43 : $uuid.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "GrantTokenRequestBody.GrantTokenPermissions(resources=" + this.getResources() + ", patterns=" + this.getPatterns() + ", meta=" + this.getMeta() + ", uuid=" + this.getUuid() + ")";
        }
    }


    public static class GrantTokenPermission {
        private final Map<String, Integer> channels;
        private final Map<String, Integer> groups;
        private final Map<String, Integer> uuids;
        private final Map<String, Integer> spaces = Collections.emptyMap();
        private final Map<String, Integer> users = Collections.emptyMap();

        @java.lang.SuppressWarnings("all")
        public GrantTokenPermission(final Map<String, Integer> channels, final Map<String, Integer> groups, final Map<String, Integer> uuids) {
            this.channels = channels;
            this.groups = groups;
            this.uuids = uuids;
        }

        @java.lang.SuppressWarnings("all")
        public Map<String, Integer> getChannels() {
            return this.channels;
        }

        @java.lang.SuppressWarnings("all")
        public Map<String, Integer> getGroups() {
            return this.groups;
        }

        @java.lang.SuppressWarnings("all")
        public Map<String, Integer> getUuids() {
            return this.uuids;
        }

        @java.lang.SuppressWarnings("all")
        public Map<String, Integer> getSpaces() {
            return this.spaces;
        }

        @java.lang.SuppressWarnings("all")
        public Map<String, Integer> getUsers() {
            return this.users;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof GrantTokenRequestBody.GrantTokenPermission)) return false;
            final GrantTokenRequestBody.GrantTokenPermission other = (GrantTokenRequestBody.GrantTokenPermission) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$channels = this.getChannels();
            final java.lang.Object other$channels = other.getChannels();
            if (this$channels == null ? other$channels != null : !this$channels.equals(other$channels)) return false;
            final java.lang.Object this$groups = this.getGroups();
            final java.lang.Object other$groups = other.getGroups();
            if (this$groups == null ? other$groups != null : !this$groups.equals(other$groups)) return false;
            final java.lang.Object this$uuids = this.getUuids();
            final java.lang.Object other$uuids = other.getUuids();
            if (this$uuids == null ? other$uuids != null : !this$uuids.equals(other$uuids)) return false;
            final java.lang.Object this$spaces = this.getSpaces();
            final java.lang.Object other$spaces = other.getSpaces();
            if (this$spaces == null ? other$spaces != null : !this$spaces.equals(other$spaces)) return false;
            final java.lang.Object this$users = this.getUsers();
            final java.lang.Object other$users = other.getUsers();
            if (this$users == null ? other$users != null : !this$users.equals(other$users)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof GrantTokenRequestBody.GrantTokenPermission;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $channels = this.getChannels();
            result = result * PRIME + ($channels == null ? 43 : $channels.hashCode());
            final java.lang.Object $groups = this.getGroups();
            result = result * PRIME + ($groups == null ? 43 : $groups.hashCode());
            final java.lang.Object $uuids = this.getUuids();
            result = result * PRIME + ($uuids == null ? 43 : $uuids.hashCode());
            final java.lang.Object $spaces = this.getSpaces();
            result = result * PRIME + ($spaces == null ? 43 : $spaces.hashCode());
            final java.lang.Object $users = this.getUsers();
            result = result * PRIME + ($users == null ? 43 : $users.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "GrantTokenRequestBody.GrantTokenPermission(channels=" + this.getChannels() + ", groups=" + this.getGroups() + ", uuids=" + this.getUuids() + ", spaces=" + this.getSpaces() + ", users=" + this.getUsers() + ")";
        }
    }

    public static GrantTokenRequestBody of(Integer ttl, List<ChannelGrant> channels, List<ChannelGroupGrant> groups, List<UUIDGrant> uuids, Object meta, String uuid) throws PubNubException {
        GrantTokenPermission resources = new GrantTokenPermission(getResources(channels), getResources(groups), getResources(uuids));
        GrantTokenPermission patterns = new GrantTokenPermission(getPatterns(channels), getPatterns(groups), getPatterns(uuids));
        GrantTokenPermissions permissions = new GrantTokenPermissions(resources, patterns, meta == null ? Collections.emptyMap() : meta, uuid);
        return new GrantTokenRequestBody(ttl, permissions);
    }

    private static <T extends PNResource<?>> Map<String, Integer> getResources(List<T> resources) throws PubNubException {
        final Map<String, Integer> result = new HashMap<>();
        for (T resource : resources) {
            if (!resource.isPatternResource()) {
                result.put(resource.getId(), calculateBitmask(resource));
            }
        }
        return result;
    }

    private static <T extends PNResource<?>> Map<String, Integer> getPatterns(List<T> resources) throws PubNubException {
        final Map<String, Integer> result = new HashMap<>();
        for (T resource : resources) {
            if (resource.isPatternResource()) {
                result.put(resource.getId(), calculateBitmask(resource));
            }
        }
        return result;
    }

    private static int calculateBitmask(PNResource<?> resource) throws PubNubException {
        int sum = 0;
        if (resource.isRead()) {
            sum |= TokenBitmask.READ;
        }
        if (resource.isWrite()) {
            sum |= TokenBitmask.WRITE;
        }
        if (resource.isManage()) {
            sum |= TokenBitmask.MANAGE;
        }
        if (resource.isDelete()) {
            sum |= TokenBitmask.DELETE;
        }
        if (resource.isCreate()) {
            sum |= TokenBitmask.CREATE;
        }
        if (resource.isGet()) {
            sum |= TokenBitmask.GET;
        }
        if (resource.isJoin()) {
            sum |= TokenBitmask.JOIN;
        }
        if (resource.isUpdate()) {
            sum |= TokenBitmask.UPDATE;
        }
        return sum;
    }


    @java.lang.SuppressWarnings("all")
    public static class GrantTokenRequestBodyBuilder {
        @java.lang.SuppressWarnings("all")
        private Integer ttl;
        @java.lang.SuppressWarnings("all")
        private List<ChannelGrant> channels;
        @java.lang.SuppressWarnings("all")
        private List<ChannelGroupGrant> groups;
        @java.lang.SuppressWarnings("all")
        private List<UUIDGrant> uuids;
        @java.lang.SuppressWarnings("all")
        private Object meta;
        @java.lang.SuppressWarnings("all")
        private String uuid;

        @java.lang.SuppressWarnings("all")
        GrantTokenRequestBodyBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public GrantTokenRequestBodyBuilder ttl(final Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public GrantTokenRequestBodyBuilder channels(final List<ChannelGrant> channels) {
            this.channels = channels;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public GrantTokenRequestBodyBuilder groups(final List<ChannelGroupGrant> groups) {
            this.groups = groups;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public GrantTokenRequestBodyBuilder uuids(final List<UUIDGrant> uuids) {
            this.uuids = uuids;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public GrantTokenRequestBodyBuilder meta(final Object meta) {
            this.meta = meta;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public GrantTokenRequestBodyBuilder uuid(final String uuid) {
            this.uuid = uuid;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public GrantTokenRequestBody build() throws PubNubException {
            return GrantTokenRequestBody.of(ttl, channels, groups, uuids, meta, uuid);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "GrantTokenRequestBody.GrantTokenRequestBodyBuilder(ttl=" + this.ttl + ", channels=" + this.channels + ", groups=" + this.groups + ", uuids=" + this.uuids + ", meta=" + this.meta + ", uuid=" + this.uuid + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    public static GrantTokenRequestBodyBuilder builder() {
        return new GrantTokenRequestBodyBuilder();
    }

    @java.lang.SuppressWarnings("all")
    public GrantTokenRequestBody(final Integer ttl, final GrantTokenPermissions permissions) {
        this.ttl = ttl;
        this.permissions = permissions;
    }

    @java.lang.SuppressWarnings("all")
    public Integer getTtl() {
        return this.ttl;
    }

    @java.lang.SuppressWarnings("all")
    public GrantTokenPermissions getPermissions() {
        return this.permissions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GrantTokenRequestBody)) return false;
        final GrantTokenRequestBody other = (GrantTokenRequestBody) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$ttl = this.getTtl();
        final java.lang.Object other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !this$ttl.equals(other$ttl)) return false;
        final java.lang.Object this$permissions = this.getPermissions();
        final java.lang.Object other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof GrantTokenRequestBody;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $ttl = this.getTtl();
        result = result * PRIME + ($ttl == null ? 43 : $ttl.hashCode());
        final java.lang.Object $permissions = this.getPermissions();
        result = result * PRIME + ($permissions == null ? 43 : $permissions.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "GrantTokenRequestBody(ttl=" + this.getTtl() + ", permissions=" + this.getPermissions() + ")";
    }
}
