/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.access;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.access_manager.PNAccessManagerGrantResult;
import com.pubnub.api.models.consumer.access_manager.PNAccessManagerKeyData;
import com.pubnub.api.models.server.Envelope;
import com.pubnub.api.models.server.access_manager.AccessManagerGrantPayload;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class Grant
extends Endpoint<Envelope<AccessManagerGrantPayload>, PNAccessManagerGrantResult> {
    private boolean read;
    private boolean write;
    private boolean manage;
    private boolean delete;
    private boolean get;
    private boolean update;
    private boolean join;
    private Integer ttl;
    private List<String> authKeys;
    private List<String> channels;
    private List<String> channelGroups;
    private List<String> uuids = Collections.emptyList();

    public Grant(PubNub pubnub, TelemetryManager telemetryManager, RetrofitManager retrofit, TokenManager tokenManager) {
        super(pubnub, telemetryManager, retrofit, tokenManager);
        this.authKeys = new ArrayList<String>();
        this.channels = new ArrayList<String>();
        this.channelGroups = new ArrayList<String>();
    }

    @Override
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return this.channelGroups;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.getPubnub().getConfiguration().getSecretKey() == null || this.getPubnub().getConfiguration().getSecretKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SECRET_KEY_MISSING).build();
        }
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (this.getPubnub().getConfiguration().getPublishKey() == null || this.getPubnub().getConfiguration().getPublishKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PUBLISH_KEY_MISSING).build();
        }
        if (!(this.channels.isEmpty() && this.channelGroups.isEmpty() || this.uuids.isEmpty())) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INVALID_ARGUMENTS).errormsg("Grants for channels or channelGroups can't be changed together with grants for UUIDs").build();
        }
        if (!this.uuids.isEmpty() && this.authKeys.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INVALID_ARGUMENTS).errormsg("UUIDs grant management require providing non empty authKeys").build();
        }
    }

    @Override
    protected Call<Envelope<AccessManagerGrantPayload>> doWork(Map<String, String> queryParams) throws PubNubException {
        if (this.channels.size() > 0) {
            queryParams.put("channel", PubNubUtil.joinString(this.channels, ","));
        }
        if (this.channelGroups.size() > 0) {
            queryParams.put("channel-group", PubNubUtil.joinString(this.channelGroups, ","));
        }
        if (this.uuids.size() > 0) {
            queryParams.put("target-uuid", PubNubUtil.joinString(this.uuids, ","));
        }
        if (this.authKeys.size() > 0) {
            queryParams.put("auth", PubNubUtil.joinString(this.authKeys, ","));
        }
        if (this.ttl != null && this.ttl >= -1) {
            queryParams.put("ttl", String.valueOf(this.ttl));
        }
        queryParams.put("r", this.read ? "1" : "0");
        queryParams.put("w", this.write ? "1" : "0");
        queryParams.put("m", this.manage ? "1" : "0");
        queryParams.put("d", this.delete ? "1" : "0");
        queryParams.put("g", this.get ? "1" : "0");
        queryParams.put("u", this.update ? "1" : "0");
        queryParams.put("j", this.join ? "1" : "0");
        return this.getRetrofit().getAccessManagerService().grant(this.getPubnub().getConfiguration().getSubscribeKey(), queryParams);
    }

    @Override
    protected PNAccessManagerGrantResult createResponse(Response<Envelope<AccessManagerGrantPayload>> input) throws PubNubException {
        MapperManager mapperManager = this.getPubnub().getMapper();
        PNAccessManagerGrantResult.PNAccessManagerGrantResultBuilder pnAccessManagerGrantResult = PNAccessManagerGrantResult.builder();
        if (input.body() == null || ((Envelope)input.body()).getPayload() == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PARSING_ERROR).build();
        }
        AccessManagerGrantPayload data = (AccessManagerGrantPayload)((Envelope)input.body()).getPayload();
        HashMap<String, Map<String, PNAccessManagerKeyData>> constructedChannels = new HashMap<String, Map<String, PNAccessManagerKeyData>>();
        HashMap<String, Map<String, PNAccessManagerKeyData>> constructedGroups = new HashMap<String, Map<String, PNAccessManagerKeyData>>();
        if (data.getChannel() != null) {
            constructedChannels.put(data.getChannel(), data.getAuthKeys());
        }
        if (this.channelGroups != null) {
            if (this.channelGroups.size() == 1) {
                constructedGroups.put(mapperManager.elementToString(data.getChannelGroups()), data.getAuthKeys());
            } else if (this.channelGroups.size() > 1) {
                Iterator<Object> it = mapperManager.getObjectIterator(data.getChannelGroups());
                while (it.hasNext()) {
                    Map.Entry channelGroup = (Map.Entry)it.next();
                    constructedGroups.put((String)channelGroup.getKey(), this.createKeyMap((JsonElement)channelGroup.getValue()));
                }
            }
        }
        if (data.getChannels() != null) {
            for (String fetchedChannel : data.getChannels().keySet()) {
                constructedChannels.put(fetchedChannel, data.getChannels().get(fetchedChannel).getAuthKeys());
            }
        }
        HashMap<String, Map<String, PNAccessManagerKeyData>> constructedUuids = new HashMap<String, Map<String, PNAccessManagerKeyData>>();
        if (data.getUuids() != null) {
            for (String fetchedUuid : data.getUuids().keySet()) {
                constructedUuids.put(fetchedUuid, data.getUuids().get(fetchedUuid).getAuthKeys());
            }
        }
        return pnAccessManagerGrantResult.subscribeKey(data.getSubscribeKey()).level(data.getLevel()).ttl(data.getTtl()).channels(constructedChannels).channelGroups(constructedGroups).uuids(constructedUuids).build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNAccessManagerGrant;
    }

    @Override
    protected boolean isAuthRequired() {
        return false;
    }

    private Map<String, PNAccessManagerKeyData> createKeyMap(JsonElement input) {
        HashMap<String, PNAccessManagerKeyData> result = new HashMap<String, PNAccessManagerKeyData>();
        MapperManager mapper = this.getPubnub().getMapper();
        Iterator<Map.Entry<String, JsonElement>> it = mapper.getObjectIterator(input, "auths");
        while (it.hasNext()) {
            Map.Entry<String, JsonElement> keyMap = it.next();
            PNAccessManagerKeyData pnAccessManagerKeyData = PNAccessManagerKeyData.builder().manageEnabled(mapper.getAsBoolean(keyMap.getValue(), "m")).writeEnabled(mapper.getAsBoolean(keyMap.getValue(), "w")).readEnabled(mapper.getAsBoolean(keyMap.getValue(), "r")).deleteEnabled(mapper.getAsBoolean(keyMap.getValue(), "d")).getEnabled(mapper.getAsBoolean(keyMap.getValue(), "g")).updateEnabled(mapper.getAsBoolean(keyMap.getValue(), "u")).joinEnabled(mapper.getAsBoolean(keyMap.getValue(), "j")).build();
            result.put(keyMap.getKey(), pnAccessManagerKeyData);
        }
        return result;
    }

    public Grant read(boolean read) {
        this.read = read;
        return this;
    }

    public Grant write(boolean write) {
        this.write = write;
        return this;
    }

    public Grant manage(boolean manage) {
        this.manage = manage;
        return this;
    }

    public Grant delete(boolean delete) {
        this.delete = delete;
        return this;
    }

    public Grant get(boolean get) {
        this.get = get;
        return this;
    }

    public Grant update(boolean update) {
        this.update = update;
        return this;
    }

    public Grant join(boolean join) {
        this.join = join;
        return this;
    }

    public Grant ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public Grant authKeys(List<String> authKeys) {
        this.authKeys = authKeys;
        return this;
    }

    public Grant channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public Grant channelGroups(List<String> channelGroups) {
        this.channelGroups = channelGroups;
        return this;
    }

    public Grant uuids(List<String> uuids) {
        this.uuids = uuids;
        return this;
    }
}

