/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.access;

import com.google.gson.JsonObject;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.access_manager.v3.ChannelGrant;
import com.pubnub.api.models.consumer.access_manager.v3.ChannelGroupGrant;
import com.pubnub.api.models.consumer.access_manager.v3.PNGrantTokenResult;
import com.pubnub.api.models.consumer.access_manager.v3.UUIDGrant;
import com.pubnub.api.models.server.access_manager.v3.GrantTokenRequestBody;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class GrantToken
extends Endpoint<JsonObject, PNGrantTokenResult> {
    private Integer ttl;
    private Object meta;
    private String authorizedUUID;
    private List<ChannelGrant> channels = Collections.emptyList();
    private List<ChannelGroupGrant> channelGroups = Collections.emptyList();
    private List<UUIDGrant> uuids = Collections.emptyList();

    public GrantToken(PubNub pubnub, TelemetryManager telemetryManager, RetrofitManager retrofit, TokenManager tokenManager) {
        super(pubnub, telemetryManager, retrofit, tokenManager);
    }

    @Override
    protected List<String> getAffectedChannels() {
        ArrayList<String> affectedChannels = new ArrayList<String>();
        for (ChannelGrant channelGrant : this.channels) {
            affectedChannels.add(channelGrant.getId());
        }
        return affectedChannels;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        ArrayList<String> affectedChannelGroups = new ArrayList<String>();
        for (ChannelGroupGrant channelGroupGrant : this.channelGroups) {
            affectedChannelGroups.add(channelGroupGrant.getId());
        }
        return affectedChannelGroups;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.getPubnub().getConfiguration().getSecretKey() == null || this.getPubnub().getConfiguration().getSecretKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SECRET_KEY_MISSING).build();
        }
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (PubNubUtil.isNullOrEmpty(this.channels) && PubNubUtil.isNullOrEmpty(this.channelGroups) && PubNubUtil.isNullOrEmpty(this.uuids)) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_RESOURCES_MISSING).build();
        }
        if (this.ttl == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_TTL_MISSING).build();
        }
    }

    @Override
    protected Call<JsonObject> doWork(Map<String, String> queryParams) throws PubNubException {
        GrantTokenRequestBody requestBody = GrantTokenRequestBody.builder().ttl(this.ttl).channels(this.channels).groups(this.channelGroups).uuids(this.uuids).meta(this.meta).uuid(this.authorizedUUID).build();
        return this.getRetrofit().getAccessManagerService().grantToken(this.getPubnub().getConfiguration().getSubscribeKey(), requestBody, queryParams);
    }

    @Override
    protected PNGrantTokenResult createResponse(Response<JsonObject> input) throws PubNubException {
        if (input.body() == null) {
            return null;
        }
        return new PNGrantTokenResult(((JsonObject)input.body()).getAsJsonObject("data").get("token").getAsString());
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNAccessManagerGrantToken;
    }

    @Override
    protected boolean isAuthRequired() {
        return false;
    }

    public GrantToken ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public GrantToken meta(Object meta) {
        this.meta = meta;
        return this;
    }

    public GrantToken authorizedUUID(String authorizedUUID) {
        this.authorizedUUID = authorizedUUID;
        return this;
    }

    public GrantToken channels(List<ChannelGrant> channels) {
        this.channels = channels;
        return this;
    }

    public GrantToken channelGroups(List<ChannelGroupGrant> channelGroups) {
        this.channelGroups = channelGroups;
        return this;
    }

    public GrantToken uuids(List<UUIDGrant> uuids) {
        this.uuids = uuids;
        return this;
    }
}

