/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.files;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.BuilderSteps;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.PNPage;
import com.pubnub.api.models.consumer.files.PNListFilesResult;
import com.pubnub.api.models.server.files.ListFilesResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class ListFiles
extends Endpoint<ListFilesResult, PNListFilesResult> {
    private static final String LIMIT_QUERY_PARAM = "limit";
    private static final String NEXT_PAGE_QUERY_PARAM = "next";
    private static final String DEFAULT_LIMIT = "100";
    private static final int MIN_LIMIT = 1;
    private static final int MAX_LIMIT = 100;
    private final String channel;
    private Integer limit;
    private PNPage.Next next;

    public ListFiles(String channel, PubNub pubnubInstance, TelemetryManager telemetry, RetrofitManager retrofitInstance, TokenManager tokenManager) {
        super(pubnubInstance, telemetry, retrofitInstance, tokenManager);
        this.channel = channel;
    }

    @Override
    protected List<String> getAffectedChannels() {
        return Collections.singletonList(this.channel);
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return null;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (this.channel == null || this.channel.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
        if (this.limit != null && (1 > this.limit || this.limit > 100)) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INVALID_ARGUMENTS).errormsg("Limit should be in range from 1 to 100 (both inclusive)").build();
        }
        if (this.next != null && (this.next.getHash() == null || this.next.getHash().isEmpty())) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INVALID_ARGUMENTS).errormsg("Next should not be an empty string").build();
        }
    }

    @Override
    protected Call<ListFilesResult> doWork(Map<String, String> baseParams) throws PubNubException {
        HashMap<String, String> allParams = new HashMap<String, String>(baseParams);
        if (this.limit != null) {
            allParams.put(LIMIT_QUERY_PARAM, this.limit.toString());
        } else {
            allParams.put(LIMIT_QUERY_PARAM, DEFAULT_LIMIT);
        }
        if (this.next != null) {
            allParams.put(NEXT_PAGE_QUERY_PARAM, PubNubUtil.urlEncode(this.next.getHash()));
        }
        return this.getRetrofit().getFilesService().listFiles(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, this.encodeParams(allParams));
    }

    @Override
    protected PNListFilesResult createResponse(Response<ListFilesResult> input) throws PubNubException {
        if (input.body() == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INTERNAL_ERROR).build();
        }
        return new PNListFilesResult(((ListFilesResult)input.body()).getCount(), PNPage.next(((ListFilesResult)input.body()).getNext()), ((ListFilesResult)input.body()).getStatus(), ((ListFilesResult)input.body()).getData());
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNFileAction;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public ListFiles limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public ListFiles next(PNPage.Next next) {
        this.next = next;
        return this;
    }

    public static class Builder
    implements BuilderSteps.ChannelStep<ListFiles> {
        private final PubNub pubnubInstance;
        private final TelemetryManager telemetry;
        private final RetrofitManager retrofitInstance;
        private final TokenManager tokenManager;

        public Builder(PubNub pubnubInstance, TelemetryManager telemetry, RetrofitManager retrofitInstance, TokenManager tokenManager) {
            this.pubnubInstance = pubnubInstance;
            this.telemetry = telemetry;
            this.retrofitInstance = retrofitInstance;
            this.tokenManager = tokenManager;
        }

        @Override
        public ListFiles channel(String channel) {
            return new ListFiles(channel, this.pubnubInstance, this.telemetry, this.retrofitInstance, this.tokenManager);
        }
    }
}

