/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.files;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.endpoints.remoteaction.RemoteAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.models.consumer.PNErrorData;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.server.files.FileUploadRequestDetails;
import com.pubnub.api.models.server.files.FormField;
import com.pubnub.api.services.S3Service;
import com.pubnub.api.vendor.FileEncryptionUtil;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class UploadFile
implements RemoteAction<Void> {
    private static final Logger log = LoggerFactory.getLogger(UploadFile.class);
    private static final MediaType APPLICATION_OCTET_STREAM = MediaType.get((String)"application/octet-stream");
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String FILE_PART_MULTIPART = "file";
    private final S3Service s3Service;
    private final String fileName;
    private final byte[] content;
    private final String cipherKey;
    private final FormField key;
    private final List<FormField> formParams;
    private final String baseUrl;
    private Call<Void> call;

    UploadFile(S3Service s3Service, String fileName, byte[] content, String cipherKey, FormField key, List<FormField> formParams, String baseUrl) {
        this.s3Service = s3Service;
        this.fileName = fileName;
        this.content = content;
        this.cipherKey = cipherKey;
        this.key = key;
        this.formParams = formParams;
        this.baseUrl = baseUrl;
    }

    private static void addFormParamsWithKeyFirst(FormField keyValue, List<FormField> formParams, MultipartBody.Builder builder) {
        builder.addFormDataPart(keyValue.getKey(), keyValue.getValue());
        for (FormField it : formParams) {
            if (it.getKey().equals(keyValue.getKey())) continue;
            builder.addFormDataPart(it.getKey(), it.getValue());
        }
    }

    private Call<Void> prepareCall() throws PubNubException, IOException {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        UploadFile.addFormParamsWithKeyFirst(this.key, this.formParams, builder);
        MediaType mediaType = this.getMediaType(this.getContentType(this.formParams));
        RequestBody requestBody = this.cipherKey == null ? RequestBody.create((MediaType)mediaType, (byte[])this.content) : RequestBody.create((MediaType)mediaType, (byte[])FileEncryptionUtil.encryptToBytes(this.cipherKey, this.content));
        builder.addFormDataPart(FILE_PART_MULTIPART, this.fileName, requestBody);
        return this.s3Service.upload(this.baseUrl, builder.build());
    }

    @Nullable
    private String getContentType(List<FormField> formFields) {
        String contentType = null;
        for (FormField field : formFields) {
            if (!field.getKey().equalsIgnoreCase(CONTENT_TYPE_HEADER)) continue;
            contentType = field.getValue();
            break;
        }
        return contentType;
    }

    private MediaType getMediaType(@Nullable String contentType) {
        if (contentType == null) {
            return APPLICATION_OCTET_STREAM;
        }
        try {
            return MediaType.get((String)contentType);
        }
        catch (Throwable t) {
            log.warn("Content-Type: " + contentType + " was not recognized by MediaType.get", t);
            return APPLICATION_OCTET_STREAM;
        }
    }

    @Override
    public Void sync() throws PubNubException {
        Response serverResponse;
        try {
            this.call = this.prepareCall();
        }
        catch (IOException e) {
            throw PubNubException.builder().errormsg(e.getMessage()).cause(e).build();
        }
        try {
            serverResponse = this.call.execute();
        }
        catch (IOException e) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PARSING_ERROR).errormsg(e.toString()).affectedCall(this.call).cause(e).build();
        }
        if (!serverResponse.isSuccessful()) {
            throw this.createException((Response<Void>)serverResponse);
        }
        return null;
    }

    @Override
    public void async(final @NotNull PNCallback<Void> callback) {
        try {
            this.call = this.prepareCall();
            this.call.enqueue((Callback)new Callback<Void>(){

                public void onResponse(@NotNull Call<Void> performedCall, @NotNull Response<Void> response) {
                    if (!response.isSuccessful()) {
                        PubNubException ex = UploadFile.this.createException((Response<Void>)response);
                        PNStatusCategory pnStatusCategory = PNStatusCategory.PNUnknownCategory;
                        if (response.code() == 401 || response.code() == 403) {
                            pnStatusCategory = PNStatusCategory.PNAccessDeniedCategory;
                        }
                        if (response.code() == 400) {
                            pnStatusCategory = PNStatusCategory.PNBadRequestCategory;
                        }
                        callback.onResponse(null, UploadFile.this.createStatusResponse(pnStatusCategory, (Response<Void>)response, ex));
                        return;
                    }
                    callback.onResponse(null, UploadFile.this.createStatusResponse(PNStatusCategory.PNAcknowledgmentCategory, (Response<Void>)response, null));
                }

                public void onFailure(@NotNull Call<Void> performedCall, @NotNull Throwable throwable) {
                    PNStatusCategory pnStatusCategory;
                    if (UploadFile.this.call.isCanceled()) {
                        return;
                    }
                    PubNubException.PubNubExceptionBuilder pubnubException = PubNubException.builder().errormsg(throwable.getMessage()).cause(throwable);
                    try {
                        throw throwable;
                    }
                    catch (UnknownHostException networkException) {
                        pubnubException.pubnubError(PubNubErrorBuilder.PNERROBJ_CONNECTION_NOT_SET);
                        pnStatusCategory = PNStatusCategory.PNUnexpectedDisconnectCategory;
                    }
                    catch (SocketException | SSLException exception) {
                        pubnubException.pubnubError(PubNubErrorBuilder.PNERROBJ_CONNECT_EXCEPTION);
                        pnStatusCategory = PNStatusCategory.PNUnexpectedDisconnectCategory;
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        pubnubException.pubnubError(PubNubErrorBuilder.PNERROBJ_SOCKET_TIMEOUT);
                        pnStatusCategory = PNStatusCategory.PNTimeoutCategory;
                    }
                    catch (Throwable throwable1) {
                        pubnubException.pubnubError(PubNubErrorBuilder.PNERROBJ_HTTP_ERROR);
                        pnStatusCategory = performedCall.isCanceled() ? PNStatusCategory.PNCancelledCategory : PNStatusCategory.PNBadRequestCategory;
                    }
                    callback.onResponse(null, UploadFile.this.createStatusResponse(pnStatusCategory, (Response<Void>)null, pubnubException.build()));
                }
            });
        }
        catch (PubNubException | IOException e) {
            callback.onResponse(null, this.createStatusResponse(PNStatusCategory.PNUnknownCategory, null, e));
        }
    }

    @Override
    public void retry() {
    }

    @Override
    public void silentCancel() {
        if (!this.call.isCanceled()) {
            this.call.cancel();
        }
    }

    private PubNubException createException(Response<Void> response) {
        try {
            String responseBodyText = "N/A";
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(response.errorBody().byteStream());
            doc.getDocumentElement().normalize();
            NodeList elements = doc.getElementsByTagName("Message");
            for (int i = 0; i < elements.getLength(); ++i) {
                responseBodyText = elements.item(0).getFirstChild().getNodeValue();
            }
            return PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_HTTP_ERROR).errormsg(responseBodyText).affectedCall(this.call).statusCode(response.code()).build();
        }
        catch (IOException | NullPointerException | ParserConfigurationException | SAXException e) {
            return PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_HTTP_ERROR).errormsg(e.getMessage()).affectedCall(this.call).statusCode(response.code()).cause(e).build();
        }
    }

    private PNStatus createStatusResponse(PNStatusCategory category, Response<Void> response, Exception throwable) {
        PNStatus.PNStatusBuilder pnStatus = PNStatus.builder();
        if (response == null || throwable != null) {
            pnStatus.error(true);
        }
        if (throwable != null) {
            PNErrorData pnErrorData = new PNErrorData(throwable.getMessage(), throwable);
            pnStatus.errorData(pnErrorData);
        }
        if (response != null) {
            pnStatus.statusCode(response.code());
            pnStatus.tlsEnabled(response.raw().request().url().isHttps());
            pnStatus.origin(response.raw().request().url().host());
            pnStatus.clientRequest(response.raw().request());
        }
        pnStatus.operation(this.getOperationType());
        pnStatus.category(category);
        return pnStatus.build();
    }

    private PNOperationType getOperationType() {
        return PNOperationType.PNFileAction;
    }

    static class Factory {
        private final PubNub pubNub;
        private final RetrofitManager retrofitManager;

        Factory(PubNub pubNub, RetrofitManager retrofitManager) {
            this.pubNub = pubNub;
            this.retrofitManager = retrofitManager;
        }

        RemoteAction<Void> create(String fileName, byte[] content, String cipherKey, FileUploadRequestDetails fileUploadRequestDetails) {
            String effectiveCipherKey = FileEncryptionUtil.effectiveCipherKey(this.pubNub, cipherKey);
            return new UploadFile(this.retrofitManager.getS3Service(), fileName, content, effectiveCipherKey, fileUploadRequestDetails.getKeyFormField(), fileUploadRequestDetails.getFormFields(), fileUploadRequestDetails.getUrl());
        }
    }
}

