/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.objects_api.utils;

import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.endpoints.objects_api.utils.HavingCompositeParameterEnricher;
import com.pubnub.api.endpoints.objects_api.utils.ParameterEnricher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Include
implements ParameterEnricher {
    static final String INCLUDE_PARAM_NAME = "include";
    static final String INCLUDE_CUSTOM_PARAM_VALUE = "custom";
    static final String INCLUDE_CHANNEL_PARAM_VALUE = "channel";
    static final String INCLUDE_CHANNEL_CUSTOM_PARAM_VALUE = "channel.custom";
    static final String INCLUDE_UUID_PARAM_VALUE = "uuid";
    static final String INCLUDE_UUID_CUSTOM_PARAM_VALUE = "uuid.custom";
    private final List<String> inclusionFlags = new ArrayList<String>();

    public void addInclusionFlag(String inclusionFlag) {
        this.inclusionFlags.add(inclusionFlag);
    }

    @Override
    public Map<String, String> enrichParameters(Map<String, String> baseParams) {
        HashMap<String, String> enrichedMap = new HashMap<String, String>(baseParams);
        if (!this.inclusionFlags.isEmpty()) {
            enrichedMap.put(INCLUDE_PARAM_NAME, this.join(this.inclusionFlags));
        }
        return enrichedMap;
    }

    private String join(Collection<String> values) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> flagsIterator = values.iterator();
        while (flagsIterator.hasNext()) {
            builder.append(flagsIterator.next());
            if (!flagsIterator.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public static interface HavingUUIDInclude<T extends Endpoint<?, ?>>
    extends UUIDIncludeAware<T>,
    HavingCompositeParameterEnricher {
        @Override
        default public T includeUUID(PNUUIDDetailsLevel uuidDetailsLevel) {
            this.getCompositeParameterEnricher().getInclude().addInclusionFlag(uuidDetailsLevel.paramValue);
            return (T)((Endpoint)((Object)this));
        }
    }

    public static interface UUIDIncludeAware<T extends Endpoint<?, ?>> {
        public T includeUUID(PNUUIDDetailsLevel var1);
    }

    public static enum PNUUIDDetailsLevel {
        UUID("uuid"),
        UUID_WITH_CUSTOM("uuid.custom");

        private final String paramValue;

        private PNUUIDDetailsLevel(String paramValue) {
            this.paramValue = paramValue;
        }
    }

    public static interface HavingChannelInclude<T extends Endpoint<?, ?>>
    extends ChannelIncludeAware<T>,
    HavingCompositeParameterEnricher {
        @Override
        default public T includeChannel(PNChannelDetailsLevel channelDetailsLevel) {
            this.getCompositeParameterEnricher().getInclude().addInclusionFlag(channelDetailsLevel.paramValue);
            return (T)((Endpoint)((Object)this));
        }
    }

    public static interface ChannelIncludeAware<T extends Endpoint<?, ?>> {
        public T includeChannel(PNChannelDetailsLevel var1);
    }

    public static enum PNChannelDetailsLevel {
        CHANNEL("channel"),
        CHANNEL_WITH_CUSTOM("channel.custom");

        private final String paramValue;

        private PNChannelDetailsLevel(String paramValue) {
            this.paramValue = paramValue;
        }
    }

    public static interface HavingCustomInclude<T extends Endpoint<?, ?>>
    extends CustomIncludeAware<T>,
    HavingCompositeParameterEnricher {
        @Override
        default public T includeCustom(boolean includeCustom) {
            if (includeCustom) {
                this.getCompositeParameterEnricher().getInclude().addInclusionFlag(Include.INCLUDE_CUSTOM_PARAM_VALUE);
            }
            return (T)((Endpoint)((Object)this));
        }
    }

    public static interface CustomIncludeAware<T extends Endpoint<?, ?>> {
        public T includeCustom(boolean var1);
    }
}

