/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.objects_api.utils;

public class PNSortKey {
    private final Dir dir;
    private final Key key;

    private PNSortKey(Key key, Dir dir) {
        this.key = key;
        this.dir = dir;
    }

    public static PNSortKey of(Key key, Dir dir) {
        return new PNSortKey(key, dir);
    }

    public static PNSortKey of(Key key) {
        return new PNSortKey(key, Dir.ASC);
    }

    public static PNSortKey asc(Key key) {
        return new PNSortKey(key, Dir.ASC);
    }

    public static PNSortKey desc(Key key) {
        return new PNSortKey(key, Dir.DESC);
    }

    public String toSortParameter() {
        return this.key.fieldName + ":" + this.dir.dir;
    }

    Dir getDir() {
        return this.dir;
    }

    Key getKey() {
        return this.key;
    }

    public static enum Key {
        ID("id"),
        NAME("name"),
        UPDATED("updated");

        private final String fieldName;

        private Key(String fieldName) {
            this.fieldName = fieldName;
        }

        String getFieldName() {
            return this.fieldName;
        }
    }

    public static enum Dir {
        ASC("asc"),
        DESC("desc");

        private final String dir;

        private Dir(String dir) {
            this.dir = dir;
        }

        String getDir() {
            return this.dir;
        }
    }
}

