/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PubNub;
import com.pubnub.api.callbacks.SubscribeCallback;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.objects_api.channel.PNChannelMetadataResult;
import com.pubnub.api.models.consumer.objects_api.membership.PNMembershipResult;
import com.pubnub.api.models.consumer.objects_api.uuid.PNUUIDMetadataResult;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.files.PNFileEventResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import java.util.ArrayList;
import java.util.List;

public class ListenerManager {
    private final List<SubscribeCallback> listeners = new ArrayList<SubscribeCallback>();
    private final PubNub pubnub;

    public ListenerManager(PubNub pubnubInstance) {
        this.pubnub = pubnubInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SubscribeCallback listener) {
        List<SubscribeCallback> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SubscribeCallback listener) {
        List<SubscribeCallback> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SubscribeCallback> getListeners() {
        ArrayList<SubscribeCallback> tempCallbackList = new ArrayList<SubscribeCallback>();
        List<SubscribeCallback> list = this.listeners;
        synchronized (list) {
            tempCallbackList.addAll(this.listeners);
        }
        return tempCallbackList;
    }

    public void announce(PNStatus status) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.status(this.pubnub, status);
        }
    }

    public void announce(PNMessageResult message) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.message(this.pubnub, message);
        }
    }

    public void announce(PNPresenceEventResult presence) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.presence(this.pubnub, presence);
        }
    }

    public void announce(PNSignalResult signal) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.signal(this.pubnub, signal);
        }
    }

    public void announce(PNUUIDMetadataResult uuidMetadataResult) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.uuid(this.pubnub, uuidMetadataResult);
        }
    }

    public void announce(PNChannelMetadataResult channelMetadataResult) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.channel(this.pubnub, channelMetadataResult);
        }
    }

    public void announce(PNMembershipResult membershipResult) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.membership(this.pubnub, membershipResult);
        }
    }

    public void announce(PNMessageActionResult messageAction) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.messageAction(this.pubnub, messageAction);
        }
    }

    public void announce(PNFileEventResult fileEventResult) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.file(this.pubnub, fileEventResult);
        }
    }
}

