/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.remoteaction;

import com.pubnub.api.PubNubException;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.endpoints.remoteaction.PNFunction;
import com.pubnub.api.endpoints.remoteaction.RemoteAction;
import com.pubnub.api.models.consumer.PNStatus;
import org.jetbrains.annotations.NotNull;

public class MappingRemoteAction<T, U>
implements RemoteAction<U> {
    private final T result;
    private final PNFunction<T, U> function;
    private PNCallback<U> cachedCallback;

    public static <T, U> RemoteAction<U> map(T result, PNFunction<T, U> function) {
        return new MappingRemoteAction<T, U>(result, function);
    }

    private MappingRemoteAction(T result, PNFunction<T, U> function) {
        this.result = result;
        this.function = function;
    }

    @Override
    public U sync() throws PubNubException {
        return this.function.invoke(this.result);
    }

    @Override
    public void async(@NotNull PNCallback<U> callback) {
        this.cachedCallback = callback;
        callback.onResponse(this.function.invoke(this.result), PNStatus.builder().statusCode(200).build());
    }

    @Override
    public void retry() {
        this.async(this.cachedCallback);
    }

    @Override
    public void silentCancel() {
    }
}

