/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.remoteaction;

import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.endpoints.remoteaction.RemoteAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.models.consumer.PNErrorData;
import com.pubnub.api.models.consumer.PNStatus;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RetryingRemoteAction<T>
implements RemoteAction<T> {
    private final RemoteAction<T> remoteAction;
    private final int maxNumberOfAutomaticRetries;
    private final PNOperationType operationType;
    private final ExecutorService executorService;
    private PNCallback<T> cachedCallback;

    public RetryingRemoteAction(RemoteAction<T> remoteAction, int maxNumberOfAutomaticRetries, PNOperationType operationType, ExecutorService executorService) {
        this.remoteAction = remoteAction;
        this.maxNumberOfAutomaticRetries = maxNumberOfAutomaticRetries;
        this.operationType = operationType;
        this.executorService = executorService;
    }

    public static <T> RetryingRemoteAction<T> autoRetry(RemoteAction<T> remoteAction, int maxNumberOfAutomaticRetries, PNOperationType operationType, ExecutorService executorService) {
        return new RetryingRemoteAction<T>(remoteAction, maxNumberOfAutomaticRetries, operationType, executorService);
    }

    @Override
    public T sync() throws PubNubException {
        this.validate();
        PubNubException thrownException = null;
        for (int i = 0; i < this.maxNumberOfAutomaticRetries; ++i) {
            try {
                return this.remoteAction.sync();
            }
            catch (PubNubException ex) {
                thrownException = ex;
                continue;
            }
        }
        throw thrownException;
    }

    @Override
    public void async(final @NotNull PNCallback<T> callback) {
        this.cachedCallback = callback;
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    RetryingRemoteAction.this.validate();
                }
                catch (PubNubException ex) {
                    callback.onResponse(null, PNStatus.builder().executedEndpoint(RetryingRemoteAction.this).operation(RetryingRemoteAction.this.operationType).error(true).errorData(new PNErrorData(ex.getErrormsg(), ex)).build());
                    return;
                }
                ResultAndStatus lastResultAndStatus = null;
                for (int i = 0; i < RetryingRemoteAction.this.maxNumberOfAutomaticRetries; ++i) {
                    lastResultAndStatus = RetryingRemoteAction.this.syncAsync();
                    if (lastResultAndStatus.status.isError()) continue;
                    callback.onResponse(lastResultAndStatus.result, lastResultAndStatus.status);
                    return;
                }
                callback.onResponse(lastResultAndStatus.result, lastResultAndStatus.status);
            }
        });
    }

    @Override
    public void retry() {
        this.async(this.cachedCallback);
    }

    @Override
    public void silentCancel() {
        this.remoteAction.silentCancel();
    }

    private ResultAndStatus<T> syncAsync() {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference atomicResultAndStatus = new AtomicReference();
        this.remoteAction.async(new PNCallback<T>(){

            @Override
            public void onResponse(@Nullable T result, @NotNull PNStatus status) {
                atomicResultAndStatus.set(new ResultAndStatus(result, status.toBuilder().executedEndpoint(RetryingRemoteAction.this).build()));
                latch.countDown();
            }
        });
        try {
            latch.await();
            return (ResultAndStatus)atomicResultAndStatus.get();
        }
        catch (InterruptedException e) {
            this.remoteAction.silentCancel();
            return new ResultAndStatus<Object>(null, PNStatus.builder().category(PNStatusCategory.PNUnknownCategory).operation(this.operationType).errorData(new PNErrorData(e.getMessage(), e)).error(true).executedEndpoint(this).build());
        }
    }

    private void validate() throws PubNubException {
        if (this.maxNumberOfAutomaticRetries < 1) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INVALID_ARGUMENTS).errormsg("Number of retries cannot be less than 1").build();
        }
    }

    private static class ResultAndStatus<T> {
        private final T result;
        private final PNStatus status;

        public ResultAndStatus(T result, PNStatus status) {
            this.result = result;
            this.status = status;
        }

        public T getResult() {
            return this.result;
        }

        public PNStatus getStatus() {
            return this.status;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultAndStatus)) {
                return false;
            }
            ResultAndStatus other = (ResultAndStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$result = this.getResult();
            T other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            PNStatus this$status = this.getStatus();
            PNStatus other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResultAndStatus;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            PNStatus $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }

        public String toString() {
            return "RetryingRemoteAction.ResultAndStatus(result=" + this.getResult() + ", status=" + this.getStatus() + ")";
        }
    }
}

