/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PubNub;
import com.pubnub.api.callbacks.ReconnectionCallback;
import com.pubnub.api.enums.PNReconnectionPolicy;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedReconnectionManager {
    private static final Logger log = LoggerFactory.getLogger(DelayedReconnectionManager.class);
    private static final int DELAY_SECONDS = 3;
    private static final int MILLISECONDS = 1000;
    private final PNReconnectionPolicy pnReconnectionPolicy;
    private ReconnectionCallback callback;
    private PubNub pubnub;
    private Timer timer;

    public DelayedReconnectionManager(PubNub pubnub) {
        this.pubnub = pubnub;
        this.pnReconnectionPolicy = pubnub.getConfiguration().getReconnectionPolicy();
    }

    public void scheduleDelayedReconnection() {
        this.stop();
        if (this.isReconnectionPolicyUndefined()) {
            return;
        }
        this.timer = new Timer("Delayed Reconnection Manager timer", true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                DelayedReconnectionManager.this.callTime();
            }
        }, 3000L);
    }

    public void setReconnectionListener(ReconnectionCallback reconnectionCallback) {
        this.callback = reconnectionCallback;
    }

    void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private boolean isReconnectionPolicyUndefined() {
        if (this.pnReconnectionPolicy == null || this.pnReconnectionPolicy == PNReconnectionPolicy.NONE) {
            log.warn("reconnection policy is disabled, please handle reconnection manually.");
            return true;
        }
        return false;
    }

    private void callTime() {
        this.stop();
        this.callback.onReconnection();
    }
}

