/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PubNub;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.callbacks.ReconnectionCallback;
import com.pubnub.api.enums.PNReconnectionPolicy;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.PNTimeResult;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectionManager {
    private static final Logger log = LoggerFactory.getLogger(ReconnectionManager.class);
    private static final int LINEAR_INTERVAL = 3;
    private static final int MIN_EXPONENTIAL_BACKOFF = 1;
    private static final int MAX_EXPONENTIAL_BACKOFF = 32;
    private static final int MILLISECONDS = 1000;
    private ReconnectionCallback callback;
    private PubNub pubnub;
    private int exponentialMultiplier = 1;
    private int failedCalls = 0;
    private PNReconnectionPolicy pnReconnectionPolicy;
    private int maxConnectionRetries;
    private Timer timer;

    public ReconnectionManager(PubNub pubnub) {
        this.pubnub = pubnub;
        this.pnReconnectionPolicy = pubnub.getConfiguration().getReconnectionPolicy();
        this.maxConnectionRetries = pubnub.getConfiguration().getMaximumReconnectionRetries();
    }

    public void setReconnectionListener(ReconnectionCallback reconnectionCallback) {
        this.callback = reconnectionCallback;
    }

    public void startPolling() {
        if (this.isReconnectionPolicyUndefined()) {
            return;
        }
        this.exponentialMultiplier = 1;
        this.failedCalls = 0;
        this.registerHeartbeatTimer();
    }

    private void registerHeartbeatTimer() {
        this.stopHeartbeatTimer();
        if (this.isReconnectionPolicyUndefined()) {
            return;
        }
        if (this.maxConnectionRetries != -1 && this.failedCalls >= this.maxConnectionRetries) {
            this.callback.onMaxReconnectionExhaustion();
            return;
        }
        this.timer = new Timer("Reconnection Manager timer", true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ReconnectionManager.this.callTime();
            }
        }, this.getNextInterval() * 1000);
    }

    int getNextInterval() {
        int timerInterval = 3;
        ++this.failedCalls;
        if (this.pnReconnectionPolicy == PNReconnectionPolicy.EXPONENTIAL) {
            ++this.exponentialMultiplier;
            timerInterval = (int)(Math.pow(2.0, this.exponentialMultiplier) - 1.0);
            if (timerInterval > 32) {
                timerInterval = 1;
                this.exponentialMultiplier = 1;
                log.debug("timerInterval > MAXEXPONENTIALBACKOFF at: " + Calendar.getInstance().getTime().toString());
            } else if (timerInterval < 1) {
                timerInterval = 1;
            }
            log.debug("timerInterval = " + timerInterval + " at: " + Calendar.getInstance().getTime().toString());
        }
        if (this.pnReconnectionPolicy == PNReconnectionPolicy.LINEAR) {
            timerInterval = 3;
        }
        return timerInterval;
    }

    private void stopHeartbeatTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void callTime() {
        this.pubnub.time().async(new PNCallback<PNTimeResult>(){

            @Override
            public void onResponse(PNTimeResult result, @NotNull PNStatus status) {
                if (!status.isError()) {
                    ReconnectionManager.this.stopHeartbeatTimer();
                    ReconnectionManager.this.callback.onReconnection();
                } else {
                    log.debug("callTime() at: " + Calendar.getInstance().getTime().toString());
                    ReconnectionManager.this.registerHeartbeatTimer();
                }
            }
        });
    }

    private boolean isReconnectionPolicyUndefined() {
        if (this.pnReconnectionPolicy == null || this.pnReconnectionPolicy == PNReconnectionPolicy.NONE) {
            log.warn("reconnection policy is disabled, please handle reconnection manually.");
            return true;
        }
        return false;
    }
}

