/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.crypto;

import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.crypto.CryptoModuleKt;
import com.pubnub.api.crypto.cryptor.AesCbcCryptor;
import com.pubnub.api.crypto.cryptor.Cryptor;
import com.pubnub.api.crypto.cryptor.HeaderParser;
import com.pubnub.api.crypto.cryptor.LegacyCryptor;
import com.pubnub.api.crypto.cryptor.LegacyCryptorKt;
import com.pubnub.api.crypto.cryptor.ParseResult;
import com.pubnub.api.crypto.data.EncryptedData;
import com.pubnub.api.crypto.data.EncryptedStreamData;
import com.pubnub.api.crypto.exception.PubNubError;
import com.pubnub.api.crypto.exception.PubNubException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0018\u0010\u001a\u001a\u00020\u00102\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0013H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/pubnub/api/crypto/CryptoModule;", "", "primaryCryptor", "Lcom/pubnub/api/crypto/cryptor/Cryptor;", "cryptorsForDecryptionOnly", "", "headerParser", "Lcom/pubnub/api/crypto/cryptor/HeaderParser;", "(Lcom/pubnub/api/crypto/cryptor/Cryptor;Ljava/util/List;Lcom/pubnub/api/crypto/cryptor/HeaderParser;)V", "getCryptorsForDecryptionOnly$pubnub_gson", "()Ljava/util/List;", "getHeaderParser$pubnub_gson", "()Lcom/pubnub/api/crypto/cryptor/HeaderParser;", "getPrimaryCryptor$pubnub_gson", "()Lcom/pubnub/api/crypto/cryptor/Cryptor;", "decrypt", "", "encryptedData", "decryptStream", "Ljava/io/InputStream;", "encrypt", "data", "encryptStream", "stream", "getCryptorById", "cryptorId", "getDecryptedDataForCryptorWithHeader", "parsedHeader", "Lcom/pubnub/api/crypto/cryptor/ParseResult$Success;", "getDecryptedDataForLegacyCryptor", "getLegacyCryptor", "validateData", "", "validateStreamAndReturnBuffered", "Ljava/io/BufferedInputStream;", "Companion", "pubnub-gson"})
public final class CryptoModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cryptor primaryCryptor;
    @NotNull
    private final List<Cryptor> cryptorsForDecryptionOnly;
    @NotNull
    private final HeaderParser headerParser;

    public CryptoModule(@NotNull Cryptor primaryCryptor, @NotNull List<? extends Cryptor> cryptorsForDecryptionOnly, @NotNull HeaderParser headerParser) {
        Intrinsics.checkNotNullParameter((Object)primaryCryptor, (String)"primaryCryptor");
        Intrinsics.checkNotNullParameter(cryptorsForDecryptionOnly, (String)"cryptorsForDecryptionOnly");
        Intrinsics.checkNotNullParameter((Object)headerParser, (String)"headerParser");
        this.primaryCryptor = primaryCryptor;
        this.cryptorsForDecryptionOnly = cryptorsForDecryptionOnly;
        this.headerParser = headerParser;
    }

    public /* synthetic */ CryptoModule(Cryptor cryptor, List list, HeaderParser headerParser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            headerParser = new HeaderParser();
        }
        this(cryptor, list, headerParser);
    }

    @NotNull
    public final Cryptor getPrimaryCryptor$pubnub_gson() {
        return this.primaryCryptor;
    }

    @NotNull
    public final List<Cryptor> getCryptorsForDecryptionOnly$pubnub_gson() {
        return this.cryptorsForDecryptionOnly;
    }

    @NotNull
    public final HeaderParser getHeaderParser$pubnub_gson() {
        return this.headerParser;
    }

    @NotNull
    public final byte[] encrypt(@NotNull byte[] data) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.validateData(data);
        EncryptedData encryptedData = this.primaryCryptor.encrypt(data);
        byte[] metadata = encryptedData.component1();
        byte[] encryptedData2 = encryptedData.component2();
        if (Arrays.equals(this.primaryCryptor.id(), LegacyCryptorKt.getLEGACY_CRYPTOR_ID())) {
            byArray = encryptedData2;
        } else {
            byte[] cryptorHeader = this.headerParser.createCryptorHeader(this.primaryCryptor.id(), metadata);
            byArray = ArraysKt.plus((byte[])cryptorHeader, (byte[])encryptedData2);
        }
        return byArray;
    }

    @NotNull
    public final byte[] decrypt(@NotNull byte[] encryptedData) {
        byte[] byArray;
        ParseResult<? extends byte[]> parsedData;
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        this.validateData(encryptedData);
        ParseResult<? extends byte[]> parseResult = parsedData = this.headerParser.parseDataWithHeader(encryptedData);
        if (parseResult instanceof ParseResult.NoHeader) {
            byArray = this.getDecryptedDataForLegacyCryptor(encryptedData);
        } else if (parseResult instanceof ParseResult.Success) {
            byArray = this.getDecryptedDataForCryptorWithHeader((ParseResult.Success)parsedData);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        byte[] decryptedData = byArray;
        return decryptedData;
    }

    @NotNull
    public final InputStream encryptStream(@NotNull InputStream stream) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        BufferedInputStream bufferedInputStream = this.validateStreamAndReturnBuffered(stream);
        EncryptedStreamData encryptedStreamData = this.primaryCryptor.encryptStream(bufferedInputStream);
        byte[] metadata = encryptedStreamData.component1();
        InputStream encryptedData = encryptedStreamData.component2();
        if (Arrays.equals(this.primaryCryptor.id(), LegacyCryptorKt.getLEGACY_CRYPTOR_ID())) {
            inputStream = encryptedData;
        } else {
            byte[] cryptorHeader = this.headerParser.createCryptorHeader(this.primaryCryptor.id(), metadata);
            inputStream = new SequenceInputStream(new ByteArrayInputStream(cryptorHeader), encryptedData);
        }
        return inputStream;
    }

    @NotNull
    public final InputStream decryptStream(@NotNull InputStream encryptedData) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        BufferedInputStream bufferedInputStream = this.validateStreamAndReturnBuffered(encryptedData);
        ParseResult<? extends InputStream> parsedHeader = this.headerParser.parseDataWithHeader(bufferedInputStream);
        if (Intrinsics.areEqual(parsedHeader, (Object)ParseResult.NoHeader.INSTANCE)) {
            Cryptor decryptor;
            Object v0;
            block7: {
                Iterable $this$firstOrNull$iv = this.cryptorsForDecryptionOnly;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Cryptor it = (Cryptor)element$iv;
                    boolean bl = false;
                    if (!Arrays.equals(it.id(), LegacyCryptorKt.getLEGACY_CRYPTOR_ID())) continue;
                    v0 = element$iv;
                    break block7;
                }
                v0 = null;
            }
            if ((object = (decryptor = (Cryptor)v0)) == null || (object = object.decryptStream(new EncryptedStreamData(null, bufferedInputStream, 1, null))) == null) {
                throw new PubNubException("LegacyCryptor not registered", PubNubError.UNKNOWN_CRYPTOR, null, 0, null, 28, null);
            }
        } else if (parsedHeader instanceof ParseResult.Success) {
            Object element$iv2;
            block8: {
                Iterable $this$first$iv = this.cryptorsForDecryptionOnly;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Cryptor it = (Cryptor)element$iv2;
                    boolean bl = false;
                    if (!Arrays.equals(it.id(), ((ParseResult.Success)parsedHeader).getCryptoId())) continue;
                    break block8;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Cryptor decryptor = (Cryptor)element$iv2;
            object = decryptor.decryptStream(new EncryptedStreamData(((ParseResult.Success)parsedHeader).getCryptorData(), (InputStream)((ParseResult.Success)parsedHeader).getEncryptedData()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final byte[] getDecryptedDataForLegacyCryptor(byte[] encryptedData) {
        Object object;
        block3: {
            block2: {
                object = this.getLegacyCryptor();
                if (object == null) break block2;
                byte[] byArray = object.decrypt(new EncryptedData(null, encryptedData, 1, null));
                object = byArray;
                if (byArray != null) break block3;
            }
            throw new PubNubException("LegacyCryptor not available", PubNubError.UNKNOWN_CRYPTOR, null, 0, null, 28, null);
        }
        return object;
    }

    private final byte[] getDecryptedDataForCryptorWithHeader(ParseResult.Success<? extends byte[]> parsedHeader) {
        Object object;
        Object decryptedData;
        block3: {
            block2: {
                decryptedData = null;
                byte[] cryptorId = parsedHeader.getCryptoId();
                byte[] cryptorData = parsedHeader.getCryptorData();
                byte[] pureEncryptedData = parsedHeader.getEncryptedData();
                Cryptor cryptor = this.getCryptorById(cryptorId);
                object = cryptor;
                if (object == null) break block2;
                byte[] byArray = object.decrypt(new EncryptedData(cryptorData, pureEncryptedData));
                object = byArray;
                if (byArray != null) break block3;
            }
            throw new PubNubException("No cryptor found", PubNubError.UNKNOWN_CRYPTOR, null, 0, null, 28, null);
        }
        decryptedData = object;
        return decryptedData;
    }

    private final Cryptor getLegacyCryptor() {
        int n = 0;
        byte[] byArray = new byte[4];
        while (n < 4) {
            int n2 = n++;
            byArray[n2] = 0;
        }
        byte[] idOfLegacyCryptor = byArray;
        return this.getCryptorById(idOfLegacyCryptor);
    }

    private final Cryptor getCryptorById(byte[] cryptorId) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.cryptorsForDecryptionOnly;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Cryptor it = (Cryptor)element$iv;
                boolean bl = false;
                if (!Arrays.equals(it.id(), cryptorId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void validateData(byte[] data) {
        if (data.length == 0) {
            throw new PubNubException("Encryption/Decryption of empty data not allowed.", PubNubError.ENCRYPTION_AND_DECRYPTION_OF_EMPTY_DATA_NOT_ALLOWED, null, 0, null, 28, null);
        }
    }

    private final BufferedInputStream validateStreamAndReturnBuffered(InputStream stream) {
        InputStream inputStream = stream;
        int n = 8192;
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
        CryptoModuleKt.checkMinSize(bufferedInputStream, 1, (Function1<? super Integer, Unit>)((Function1)validateStreamAndReturnBuffered.1.INSTANCE));
        return bufferedInputStream;
    }

    @JvmStatic
    @NotNull
    public static final CryptoModule createLegacyCryptoModule(@NotNull String cipherKey, boolean randomIv) {
        return Companion.createLegacyCryptoModule(cipherKey, randomIv);
    }

    @JvmStatic
    @NotNull
    public static final CryptoModule createAesCbcCryptoModule(@NotNull String cipherKey, boolean randomIv) {
        return Companion.createAesCbcCryptoModule(cipherKey, randomIv);
    }

    @JvmStatic
    @NotNull
    public static final CryptoModule createNewCryptoModule(@NotNull Cryptor defaultCryptor, @NotNull List<? extends Cryptor> cryptorsForDecryptionOnly) {
        return Companion.createNewCryptoModule(defaultCryptor, cryptorsForDecryptionOnly);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J \u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/pubnub/api/crypto/CryptoModule$Companion;", "", "()V", "createAesCbcCryptoModule", "Lcom/pubnub/api/crypto/CryptoModule;", "cipherKey", "", "randomIv", "", "createLegacyCryptoModule", "createNewCryptoModule", "defaultCryptor", "Lcom/pubnub/api/crypto/cryptor/Cryptor;", "cryptorsForDecryptionOnly", "", "pubnub-gson"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CryptoModule createLegacyCryptoModule(@NotNull String cipherKey, boolean randomIv) {
            Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
            Object[] objectArray = new Cryptor[]{new LegacyCryptor(cipherKey, randomIv), new AesCbcCryptor(cipherKey)};
            return new CryptoModule(new LegacyCryptor(cipherKey, randomIv), CollectionsKt.listOf((Object[])objectArray), null, 4, null);
        }

        public static /* synthetic */ CryptoModule createLegacyCryptoModule$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.createLegacyCryptoModule(string, bl);
        }

        @JvmStatic
        @NotNull
        public final CryptoModule createAesCbcCryptoModule(@NotNull String cipherKey, boolean randomIv) {
            Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
            Object[] objectArray = new Cryptor[]{new AesCbcCryptor(cipherKey), new LegacyCryptor(cipherKey, randomIv)};
            return new CryptoModule(new AesCbcCryptor(cipherKey), CollectionsKt.listOf((Object[])objectArray), null, 4, null);
        }

        public static /* synthetic */ CryptoModule createAesCbcCryptoModule$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.createAesCbcCryptoModule(string, bl);
        }

        @JvmStatic
        @NotNull
        public final CryptoModule createNewCryptoModule(@NotNull Cryptor defaultCryptor, @NotNull List<? extends Cryptor> cryptorsForDecryptionOnly) {
            Intrinsics.checkNotNullParameter((Object)defaultCryptor, (String)"defaultCryptor");
            Intrinsics.checkNotNullParameter(cryptorsForDecryptionOnly, (String)"cryptorsForDecryptionOnly");
            return new CryptoModule(defaultCryptor, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)defaultCryptor), (Iterable)cryptorsForDecryptionOnly), null, 4, null);
        }

        public static /* synthetic */ CryptoModule createNewCryptoModule$default(Companion companion, Cryptor cryptor, List list, int n, Object object) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.createNewCryptoModule(cryptor, list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

