/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.crypto.cryptor;

import com.pubnub.api.crypto.CryptoModuleKt;
import com.pubnub.api.crypto.cryptor.AesCbcCryptor;
import com.pubnub.api.crypto.cryptor.Cryptor;
import com.pubnub.api.crypto.data.EncryptedData;
import com.pubnub.api.crypto.data.EncryptedStreamData;
import com.pubnub.api.crypto.exception.PubNubError;
import com.pubnub.api.crypto.exception.PubNubException;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/pubnub/api/crypto/cryptor/AesCbcCryptor;", "Lcom/pubnub/api/crypto/cryptor/Cryptor;", "cipherKey", "", "(Ljava/lang/String;)V", "getCipherKey", "()Ljava/lang/String;", "newKey", "Ljavax/crypto/spec/SecretKeySpec;", "createInitializedCipher", "Ljavax/crypto/Cipher;", "iv", "", "mode", "", "createNewKey", "createRandomIv", "decrypt", "encryptedData", "Lcom/pubnub/api/crypto/data/EncryptedData;", "decryptStream", "Ljava/io/InputStream;", "Lcom/pubnub/api/crypto/data/EncryptedStreamData;", "encrypt", "data", "encryptStream", "stream", "id", "sha256", "input", "validateData", "", "validateInputStreamAndReturnBuffered", "Ljava/io/BufferedInputStream;", "pubnub-gson"})
public final class AesCbcCryptor
implements Cryptor {
    @NotNull
    private final String cipherKey;
    @NotNull
    private final SecretKeySpec newKey;

    public AesCbcCryptor(@NotNull String cipherKey) {
        Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
        this.cipherKey = cipherKey;
        this.newKey = this.createNewKey();
    }

    @NotNull
    public final String getCipherKey() {
        return this.cipherKey;
    }

    @Override
    @NotNull
    public byte[] id() {
        byte[] byArray = new byte[]{65, 67, 82, 72};
        return byArray;
    }

    @Override
    @NotNull
    public EncryptedData encrypt(@NotNull byte[] data) {
        EncryptedData encryptedData;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.validateData(data);
        try {
            byte[] ivBytes = this.createRandomIv();
            Cipher cipher = this.createInitializedCipher(ivBytes, 1);
            byte[] byArray = cipher.doFinal(data);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(data)");
            byte[] encryptedData2 = byArray;
            encryptedData = new EncryptedData(ivBytes, encryptedData2);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, 28, null);
        }
        return encryptedData;
    }

    @Override
    @NotNull
    public byte[] decrypt(@NotNull EncryptedData encryptedData) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        this.validateData(encryptedData.getData());
        try {
            byte[] byArray2;
            block5: {
                block4: {
                    byte[] byArray3;
                    byArray2 = encryptedData.getMetadata();
                    if (byArray2 == null) break block4;
                    byte[] it = byArray3 = byArray2;
                    boolean bl = false;
                    byArray2 = (byte[])(it.length == 16 ? byArray3 : null);
                    if (byArray2 != null) break block5;
                }
                throw new PubNubException("Invalid random IV", PubNubError.CRYPTO_ERROR, null, 0, null, 28, null);
            }
            byte[] ivBytes = byArray2;
            Cipher cipher = this.createInitializedCipher(ivBytes, 2);
            byte[] decryptedData = cipher.doFinal(encryptedData.getData());
            Intrinsics.checkNotNullExpressionValue((Object)decryptedData, (String)"{\n            val ivByte\u2026  decryptedData\n        }");
            byArray = decryptedData;
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, 28, null);
        }
        return byArray;
    }

    @Override
    @NotNull
    public EncryptedStreamData encryptStream(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        BufferedInputStream bufferedInputStream = this.validateInputStreamAndReturnBuffered(stream);
        try {
            byte[] ivBytes = this.createRandomIv();
            Cipher cipher = this.createInitializedCipher(ivBytes, 1);
            CipherInputStream cipheredStream = new CipherInputStream(bufferedInputStream, cipher);
            return new EncryptedStreamData(ivBytes, cipheredStream);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, 28, null);
        }
    }

    @Override
    @NotNull
    public InputStream decryptStream(@NotNull EncryptedStreamData encryptedData) {
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        BufferedInputStream bufferedInputStream = this.validateInputStreamAndReturnBuffered(encryptedData.getStream());
        try {
            byte[] byArray;
            block5: {
                block4: {
                    byte[] byArray2;
                    byArray = encryptedData.getMetadata();
                    if (byArray == null) break block4;
                    byte[] it = byArray2 = byArray;
                    boolean bl = false;
                    byArray = (byte[])(it.length == 16 ? byArray2 : null);
                    if (byArray != null) break block5;
                }
                throw new PubNubException("Invalid random IV", PubNubError.CRYPTO_ERROR, null, 0, null, 28, null);
            }
            byte[] ivBytes = byArray;
            Cipher cipher = this.createInitializedCipher(ivBytes, 2);
            return new CipherInputStream(bufferedInputStream, cipher);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, 28, null);
        }
    }

    private final void validateData(byte[] data) {
        if (data.length == 0) {
            throw new PubNubException("Encryption/Decryption of empty data not allowed.", PubNubError.ENCRYPTION_AND_DECRYPTION_OF_EMPTY_DATA_NOT_ALLOWED, null, 0, null, 28, null);
        }
    }

    private final Cipher createInitializedCipher(byte[] iv, int mode) {
        Cipher cipher;
        Cipher it = cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        boolean bl = false;
        it.init(mode, (Key)this.newKey, new IvParameterSpec(iv));
        Cipher cipher2 = cipher;
        Intrinsics.checkNotNullExpressionValue((Object)cipher2, (String)"getInstance(CIPHER_TRANS\u2026ameterSpec(iv))\n        }");
        return cipher2;
    }

    private final SecretKeySpec createNewKey() {
        byte[] byArray = this.cipherKey.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] keyBytes = this.sha256(byArray);
        return new SecretKeySpec(keyBytes, "AES");
    }

    private final byte[] createRandomIv() {
        byte[] ivBytes = new byte[16];
        new SecureRandom().nextBytes(ivBytes);
        return ivBytes;
    }

    private final byte[] sha256(byte[] input) {
        byte[] byArray;
        MessageDigest digest = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(\"SHA-256\")");
            digest = messageDigest;
            byArray = digest.digest(input);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"{\n            digest = M\u2026t.digest(input)\n        }");
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, 28, null);
        }
        return byArray;
    }

    private final BufferedInputStream validateInputStreamAndReturnBuffered(InputStream stream) {
        InputStream inputStream = stream;
        int n = 8192;
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
        CryptoModuleKt.checkMinSize(bufferedInputStream, 1, (Function1<? super Integer, Unit>)((Function1)validateInputStreamAndReturnBuffered.1.INSTANCE));
        return bufferedInputStream;
    }
}

