/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.crypto.cryptor;

import com.pubnub.api.crypto.CryptoModuleKt;
import com.pubnub.api.crypto.cryptor.Cryptor;
import com.pubnub.api.crypto.cryptor.LegacyCryptor;
import com.pubnub.api.crypto.cryptor.LegacyCryptorKt;
import com.pubnub.api.crypto.data.EncryptedData;
import com.pubnub.api.crypto.data.EncryptedStreamData;
import com.pubnub.api.crypto.exception.PubNubError;
import com.pubnub.api.crypto.exception.PubNubException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\nH\u0002J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0010H\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0019H\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010!\u001a\u00020\u0010H\u0002J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0010H\u0002J\b\u0010$\u001a\u00020\u0010H\u0016J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0010H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u0010\u0010*\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006+"}, d2={"Lcom/pubnub/api/crypto/cryptor/LegacyCryptor;", "Lcom/pubnub/api/crypto/cryptor/Cryptor;", "cipherKey", "", "useRandomIv", "", "(Ljava/lang/String;Z)V", "getCipherKey", "()Ljava/lang/String;", "newKey", "Ljavax/crypto/spec/SecretKeySpec;", "getUseRandomIv", "()Z", "createInitializedCipher", "Ljavax/crypto/Cipher;", "iv", "", "mode", "", "createNewKey", "createRandomIv", "decrypt", "encryptedData", "Lcom/pubnub/api/crypto/data/EncryptedData;", "decryptStream", "Ljava/io/InputStream;", "Lcom/pubnub/api/crypto/data/EncryptedStreamData;", "encrypt", "data", "encryptStream", "stream", "getEncryptedDataForProcessing", "getIvBytesForDecryption", "getIvBytesForEncryption", "hexEncode", "input", "id", "sha256", "validateData", "", "validateEncryptedInputStreamAndReturnBuffered", "Ljava/io/BufferedInputStream;", "validateStreamAndReturnBuffered", "pubnub-gson"})
public final class LegacyCryptor
implements Cryptor {
    @NotNull
    private final String cipherKey;
    private final boolean useRandomIv;
    @NotNull
    private final SecretKeySpec newKey;

    public LegacyCryptor(@NotNull String cipherKey, boolean useRandomIv) {
        Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
        this.cipherKey = cipherKey;
        this.useRandomIv = useRandomIv;
        this.newKey = this.createNewKey();
    }

    public /* synthetic */ LegacyCryptor(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(string, bl);
    }

    @NotNull
    public final String getCipherKey() {
        return this.cipherKey;
    }

    public final boolean getUseRandomIv() {
        return this.useRandomIv;
    }

    @Override
    @NotNull
    public byte[] id() {
        return LegacyCryptorKt.getLEGACY_CRYPTOR_ID();
    }

    @Override
    @NotNull
    public EncryptedData encrypt(@NotNull byte[] data) {
        EncryptedData encryptedData;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.validateData(data);
        try {
            byte[] ivBytes = this.getIvBytesForEncryption();
            Cipher cipher = this.createInitializedCipher(ivBytes, 1);
            byte[] byArray = cipher.doFinal(data);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(data)");
            byte[] encrypted = byArray;
            encryptedData = this.useRandomIv ? new EncryptedData(null, ArraysKt.plus((byte[])ivBytes, (byte[])encrypted), 1, null) : new EncryptedData(null, encrypted, 1, null);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, 28, null);
        }
        return encryptedData;
    }

    @Override
    @NotNull
    public byte[] decrypt(@NotNull EncryptedData encryptedData) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        this.validateData(encryptedData);
        try {
            byte[] ivBytes = this.getIvBytesForDecryption(encryptedData);
            Cipher cipher = this.createInitializedCipher(ivBytes, 2);
            byte[] encryptedDataForProcessing = this.getEncryptedDataForProcessing(encryptedData);
            byte[] decryptedData = cipher.doFinal(encryptedDataForProcessing);
            Intrinsics.checkNotNullExpressionValue((Object)decryptedData, (String)"{\n            val ivByte\u2026  decryptedData\n        }");
            byArray = decryptedData;
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, 28, null);
        }
        return byArray;
    }

    @Override
    @NotNull
    public EncryptedStreamData encryptStream(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        BufferedInputStream bufferedInputStream = this.validateStreamAndReturnBuffered(stream);
        try {
            byte[] ivBytes = this.createRandomIv();
            Cipher cipher = this.createInitializedCipher(ivBytes, 1);
            CipherInputStream cipheredStream = new CipherInputStream(bufferedInputStream, cipher);
            return new EncryptedStreamData(null, new SequenceInputStream(new ByteArrayInputStream(ivBytes), cipheredStream), 1, null);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, 28, null);
        }
    }

    @Override
    @NotNull
    public InputStream decryptStream(@NotNull EncryptedStreamData encryptedData) {
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        BufferedInputStream bufferedInputStream = this.validateEncryptedInputStreamAndReturnBuffered(encryptedData.getStream());
        try {
            byte[] ivBytes = new byte[16];
            int numberOfReadBytes = bufferedInputStream.read(ivBytes);
            if (numberOfReadBytes != 16) {
                throw new PubNubException("Could not read IV from encrypted stream", PubNubError.CRYPTO_ERROR, null, 0, null, 28, null);
            }
            Cipher cipher = this.createInitializedCipher(ivBytes, 2);
            return new CipherInputStream(bufferedInputStream, cipher);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, 28, null);
        }
    }

    private final BufferedInputStream validateEncryptedInputStreamAndReturnBuffered(InputStream stream) {
        InputStream inputStream = stream;
        int n = 8192;
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
        CryptoModuleKt.checkMinSize(bufferedInputStream, 32, (Function1<? super Integer, Unit>)((Function1)validateEncryptedInputStreamAndReturnBuffered.1.INSTANCE));
        return bufferedInputStream;
    }

    private final BufferedInputStream validateStreamAndReturnBuffered(InputStream stream) {
        InputStream inputStream = stream;
        int n = 8192;
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
        CryptoModuleKt.checkMinSize(bufferedInputStream, 1, (Function1<? super Integer, Unit>)((Function1)validateStreamAndReturnBuffered.1.INSTANCE));
        return bufferedInputStream;
    }

    private final SecretKeySpec createNewKey() {
        Object object = this.cipherKey;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        object = this.hexEncode(this.sha256(byArray));
        Charset charset = Charsets.UTF_8;
        object = new String((byte[])object, charset);
        int n = 0;
        int n2 = 32;
        String string = ((String)object).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        object = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string2 = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        object = string2;
        byte[] byArray2 = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        byte[] keyBytes = byArray2;
        return new SecretKeySpec(keyBytes, "AES");
    }

    private final byte[] sha256(byte[] input) {
        byte[] byArray;
        MessageDigest digest = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(\"SHA-256\")");
            digest = messageDigest;
            byArray = digest.digest(input);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"{\n            digest = M\u2026t.digest(input)\n        }");
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, 28, null);
        }
        return byArray;
    }

    private final byte[] hexEncode(byte[] input) {
        StringBuilder result = new StringBuilder();
        for (byte byt : input) {
            String string;
            Intrinsics.checkNotNullExpressionValue((Object)Integer.toString((byt & 0xFF) + 256, 16), (String)"toString((byt.toInt() and 0xff) + 0x100, 16)");
            int n = 1;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            result.append(string2);
        }
        try {
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
            String string3 = string;
            byte[] byArray = string3.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return byArray;
        }
        catch (UnsupportedEncodingException e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, 28, null);
        }
    }

    private final void validateData(byte[] data) {
        if (data.length == 0) {
            throw new PubNubException("Encryption/Decryption of empty data not allowed.", PubNubError.ENCRYPTION_AND_DECRYPTION_OF_EMPTY_DATA_NOT_ALLOWED, null, 0, null, 28, null);
        }
    }

    private final byte[] getIvBytesForEncryption() {
        byte[] byArray;
        if (this.useRandomIv) {
            byArray = this.createRandomIv();
        } else {
            String string = "0123456789012345";
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        }
        return byArray;
    }

    private final byte[] createRandomIv() {
        byte[] ivBytes = new byte[16];
        new SecureRandom().nextBytes(ivBytes);
        return ivBytes;
    }

    private final void validateData(EncryptedData encryptedData) {
        int encryptedDatSize = encryptedData.getData().length;
        if (this.useRandomIv ? encryptedDatSize <= 16 : encryptedDatSize == 0) {
            throw new PubNubException("Encryption/Decryption of empty data not allowed.", PubNubError.ENCRYPTION_AND_DECRYPTION_OF_EMPTY_DATA_NOT_ALLOWED, null, 0, null, 28, null);
        }
    }

    private final byte[] getIvBytesForDecryption(EncryptedData encryptedData) {
        byte[] byArray;
        if (this.useRandomIv) {
            byArray = ArraysKt.sliceArray((byte[])encryptedData.getData(), (IntRange)new IntRange(0, 15));
        } else {
            String string = "0123456789012345";
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        }
        return byArray;
    }

    private final Cipher createInitializedCipher(byte[] iv, int mode) {
        Cipher cipher;
        Cipher it = cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        boolean bl = false;
        it.init(mode, (Key)this.newKey, new IvParameterSpec(iv));
        Cipher cipher2 = cipher;
        Intrinsics.checkNotNullExpressionValue((Object)cipher2, (String)"getInstance(CIPHER_TRANS\u2026ameterSpec(iv))\n        }");
        return cipher2;
    }

    private final byte[] getEncryptedDataForProcessing(EncryptedData encryptedData) {
        byte[] encryptedDataForProcessing = this.useRandomIv ? ArraysKt.sliceArray((byte[])encryptedData.getData(), (IntRange)RangesKt.until((int)16, (int)encryptedData.getData().length)) : encryptedData.getData();
        return encryptedDataForProcessing;
    }
}

