/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.crypto.CryptoModuleKt;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.PNBoundedPage;
import com.pubnub.api.models.consumer.history.PNFetchMessageItem;
import com.pubnub.api.models.consumer.history.PNFetchMessagesResult;
import com.pubnub.api.models.server.FetchMessagesEnvelope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class FetchMessages
extends Endpoint<FetchMessagesEnvelope, PNFetchMessagesResult> {
    private static final Logger log = LoggerFactory.getLogger(FetchMessages.class);
    private static final int SINGLE_CHANNEL_DEFAULT_MESSAGES = 100;
    private static final int SINGLE_CHANNEL_MAX_MESSAGES = 100;
    private static final int MULTIPLE_CHANNEL_DEFAULT_MESSAGES = 25;
    private static final int MULTIPLE_CHANNEL_MAX_MESSAGES = 25;
    private static final int DEFAULT_MESSAGES_WITH_ACTIONS = 25;
    private static final int MAX_MESSAGES_WITH_ACTIONS = 25;
    static final String PN_OTHER = "pn_other";
    private List<String> channels = new ArrayList<String>();
    private Integer maximumPerChannel;
    private Long start;
    private Long end;
    private Boolean includeMeta;
    private Boolean includeMessageActions;
    private boolean includeMessageType = true;
    private boolean includeUUID = true;

    public FetchMessages(PubNub pubnub, TelemetryManager telemetryManager, RetrofitManager retrofit, TokenManager tokenManager) {
        super(pubnub, telemetryManager, retrofit, tokenManager);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return null;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (this.channels == null || this.channels.size() == 0) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
        if (this.includeMeta == null) {
            this.includeMeta = false;
        }
        if (this.includeMessageActions == null) {
            this.includeMessageActions = false;
        }
        if (!this.includeMessageActions.booleanValue()) {
            if (this.channels.size() == 1) {
                if (this.maximumPerChannel == null || this.maximumPerChannel < 1) {
                    this.maximumPerChannel = 100;
                    log.info("maximumPerChannel param defaulting to " + this.maximumPerChannel);
                } else if (this.maximumPerChannel > 100) {
                    this.maximumPerChannel = 100;
                    log.info("maximumPerChannel param defaulting to " + this.maximumPerChannel);
                }
            } else if (this.maximumPerChannel == null || this.maximumPerChannel < 1) {
                this.maximumPerChannel = 25;
                log.info("maximumPerChannel param defaulting to " + this.maximumPerChannel);
            } else if (this.maximumPerChannel > 25) {
                this.maximumPerChannel = 25;
                log.info("maximumPerChannel param defaulting to " + this.maximumPerChannel);
            }
        } else if (this.maximumPerChannel == null || this.maximumPerChannel < 1 || this.maximumPerChannel > 25) {
            this.maximumPerChannel = 25;
            log.info("maximumPerChannel param defaulting to " + this.maximumPerChannel);
        }
    }

    @Override
    protected Call<FetchMessagesEnvelope> doWork(Map<String, String> params) throws PubNubException {
        params.put("max", String.valueOf(this.maximumPerChannel));
        if (this.start != null) {
            params.put("start", Long.toString(this.start).toLowerCase());
        }
        if (this.end != null) {
            params.put("end", Long.toString(this.end).toLowerCase());
        }
        if (this.includeMeta.booleanValue()) {
            params.put("include_meta", String.valueOf(this.includeMeta));
        }
        params.put("include_uuid", Boolean.toString(this.includeUUID));
        params.put("include_message_type", Boolean.toString(this.includeMessageType));
        if (!this.includeMessageActions.booleanValue()) {
            return this.getRetrofit().getHistoryService().fetchMessages(this.getPubnub().getConfiguration().getSubscribeKey(), PubNubUtil.joinString(this.channels, ","), params);
        }
        if (this.channels.size() > 1) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_HISTORY_MESSAGE_ACTIONS_MULTIPLE_CHANNELS).build();
        }
        return this.getRetrofit().getHistoryService().fetchMessagesWithActions(this.getPubnub().getConfiguration().getSubscribeKey(), this.channels.get(0), params);
    }

    @Override
    protected PNFetchMessagesResult createResponse(Response<FetchMessagesEnvelope> input) throws PubNubException {
        if (input.body() == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PARSING_ERROR).build();
        }
        HashMap<String, List<PNFetchMessageItem>> channelsMap = new HashMap<String, List<PNFetchMessageItem>>();
        for (Map.Entry<String, List<PNFetchMessageItem>> entry : ((FetchMessagesEnvelope)input.body()).getChannels().entrySet()) {
            ArrayList<PNFetchMessageItem> items = new ArrayList<PNFetchMessageItem>();
            for (PNFetchMessageItem item : entry.getValue()) {
                PNFetchMessageItem.PNFetchMessageItemBuilder messageItemBuilder = item.toBuilder();
                try {
                    messageItemBuilder.message(this.processMessage(item.getMessage()));
                }
                catch (PubNubException e) {
                    if (e.getPubnubError() == PubNubErrorBuilder.PNERROBJ_PNERR_CRYPTO_IS_CONFIGURED_BUT_MESSAGE_IS_NOT_ENCRYPTED) {
                        messageItemBuilder.message(item.getMessage());
                        messageItemBuilder.error(e.getPubnubError());
                    }
                    throw e;
                }
                if (this.includeMessageActions.booleanValue()) {
                    if (item.getActions() != null) {
                        messageItemBuilder.actions(item.getActions());
                    } else {
                        messageItemBuilder.actions(new HashMap<String, HashMap<String, List<PNFetchMessageItem.Action>>>());
                    }
                } else {
                    messageItemBuilder.actions(null);
                }
                messageItemBuilder.includeMessageType(this.includeMessageType);
                items.add(messageItemBuilder.build());
            }
            channelsMap.put(entry.getKey(), items);
        }
        PNBoundedPage page = null;
        FetchMessagesEnvelope.FetchMessagesPage more = ((FetchMessagesEnvelope)input.body()).getMore();
        if (more != null) {
            page = new PNBoundedPage(more.getStart(), more.getEnd(), more.getMax());
        }
        return PNFetchMessagesResult.builder().channels(channelsMap).page(page).build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNFetchMessagesOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    JsonElement processMessage(JsonElement message) throws PubNubException {
        String outputText;
        String inputText;
        CryptoModule cryptoModule = this.getPubnub().getCryptoModule();
        if (cryptoModule == null) {
            return message;
        }
        MapperManager mapper = this.getPubnub().getMapper();
        if (mapper.isJsonObject(message)) {
            if (!mapper.hasField(message, PN_OTHER)) {
                PubNubError error = this.logAndReturnDecryptionError();
                throw new PubNubException(error.getMessage(), error, null, null, 0, null, null);
            }
            inputText = mapper.elementToString(message, PN_OTHER);
        } else {
            inputText = mapper.elementToString(message);
        }
        try {
            outputText = CryptoModuleKt.decryptString(cryptoModule, inputText);
        }
        catch (Exception e) {
            PubNubError error = this.logAndReturnDecryptionError();
            throw new PubNubException(error.getMessage(), error, null, null, 0, null, null);
        }
        JsonElement outputObject = mapper.fromJson(outputText, JsonElement.class);
        if (!mapper.isJsonObject(message)) return outputObject;
        if (!mapper.hasField(message, PN_OTHER)) return outputObject;
        JsonObject objectNode = mapper.getAsObject(message);
        mapper.putOnObject(objectNode, PN_OTHER, outputObject);
        return objectNode;
    }

    private PubNubError logAndReturnDecryptionError() {
        PubNubError error = PubNubErrorBuilder.PNERROBJ_PNERR_CRYPTO_IS_CONFIGURED_BUT_MESSAGE_IS_NOT_ENCRYPTED;
        log.warn(error.getMessage());
        return error;
    }

    public FetchMessages channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public FetchMessages maximumPerChannel(Integer maximumPerChannel) {
        this.maximumPerChannel = maximumPerChannel;
        return this;
    }

    public FetchMessages start(Long start) {
        this.start = start;
        return this;
    }

    public FetchMessages end(Long end) {
        this.end = end;
        return this;
    }

    public FetchMessages includeMeta(Boolean includeMeta) {
        this.includeMeta = includeMeta;
        return this;
    }

    public FetchMessages includeMessageActions(Boolean includeMessageActions) {
        this.includeMessageActions = includeMessageActions;
        return this;
    }

    public FetchMessages includeMessageType(boolean includeMessageType) {
        this.includeMessageType = includeMessageType;
        return this;
    }

    public FetchMessages includeUUID(boolean includeUUID) {
        this.includeUUID = includeUUID;
        return this;
    }
}

