/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.history.PNHistoryItemResult;
import com.pubnub.api.models.consumer.history.PNHistoryResult;
import com.pubnub.api.workers.SubscribeMessageProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class History
extends Endpoint<JsonElement, PNHistoryResult> {
    private static final Logger log = LoggerFactory.getLogger(History.class);
    private static final int MAX_COUNT = 100;
    private String channel;
    private Long start;
    private Long end;
    private Boolean reverse;
    private Integer count;
    private Boolean includeTimetoken;
    private Boolean includeMeta;

    public History(PubNub pubnub, TelemetryManager telemetryManager, RetrofitManager retrofit, TokenManager tokenManager) {
        super(pubnub, telemetryManager, retrofit, tokenManager);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return Collections.singletonList(this.channel);
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return null;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (this.channel == null || this.channel.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
        if (this.includeMeta == null) {
            this.includeMeta = false;
        }
        if (this.includeTimetoken == null) {
            this.includeTimetoken = false;
        }
    }

    @Override
    protected Call<JsonElement> doWork(Map<String, String> params) {
        if (this.reverse != null) {
            params.put("reverse", String.valueOf(this.reverse));
        }
        if (this.includeTimetoken != null) {
            params.put("include_token", String.valueOf(this.includeTimetoken));
        }
        if (this.includeMeta.booleanValue()) {
            params.put("include_meta", String.valueOf(this.includeMeta));
        }
        if (this.count != null && this.count > 0 && this.count <= 100) {
            params.put("count", String.valueOf(this.count));
        } else {
            params.put("count", "100");
        }
        if (this.start != null) {
            params.put("start", Long.toString(this.start).toLowerCase());
        }
        if (this.end != null) {
            params.put("end", Long.toString(this.end).toLowerCase());
        }
        return this.getRetrofit().getHistoryService().fetchHistory(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, params);
    }

    @Override
    protected PNHistoryResult createResponse(Response<JsonElement> input) throws PubNubException {
        PNHistoryResult.PNHistoryResultBuilder historyData = PNHistoryResult.builder();
        ArrayList<PNHistoryItemResult> messages = new ArrayList<PNHistoryItemResult>();
        MapperManager mapper = this.getPubnub().getMapper();
        if (input.body() != null) {
            Long startTimeToken = mapper.elementToLong(mapper.getArrayElement((JsonElement)input.body(), 1));
            Long endTimeToken = mapper.elementToLong(mapper.getArrayElement((JsonElement)input.body(), 2));
            historyData.startTimetoken(startTimeToken);
            historyData.endTimetoken(endTimeToken);
            if (mapper.getArrayElement((JsonElement)input.body(), 0).isJsonArray()) {
                Iterator<JsonElement> it = mapper.getArrayIterator(mapper.getArrayElement((JsonElement)input.body(), 0));
                while (it.hasNext()) {
                    JsonElement message;
                    JsonElement historyEntry = it.next();
                    PNHistoryItemResult.PNHistoryItemResultBuilder historyItem = PNHistoryItemResult.builder();
                    if (this.includeTimetoken.booleanValue() || this.includeMeta.booleanValue()) {
                        JsonElement messageElement = mapper.getField(historyEntry, "message");
                        try {
                            message = SubscribeMessageProcessor.tryDecryptMessage(messageElement, this.getPubnub().getCryptoModule(), mapper);
                        }
                        catch (PubNubException e) {
                            if (e.getPubnubError() == PubNubErrorBuilder.PNERROBJ_PNERR_CRYPTO_IS_CONFIGURED_BUT_MESSAGE_IS_NOT_ENCRYPTED) {
                                message = messageElement;
                                historyItem.error(e.getPubnubError());
                            }
                            throw e;
                        }
                        if (this.includeTimetoken.booleanValue()) {
                            historyItem.timetoken(mapper.elementToLong(historyEntry, "timetoken"));
                        }
                        if (this.includeMeta.booleanValue()) {
                            historyItem.meta(mapper.getField(historyEntry, "meta"));
                        }
                    } else {
                        try {
                            message = SubscribeMessageProcessor.tryDecryptMessage(historyEntry, this.getPubnub().getCryptoModule(), mapper);
                        }
                        catch (PubNubException e) {
                            if (e.getPubnubError() == PubNubErrorBuilder.PNERROBJ_PNERR_CRYPTO_IS_CONFIGURED_BUT_MESSAGE_IS_NOT_ENCRYPTED) {
                                message = historyEntry;
                                historyItem.error(e.getPubnubError());
                            }
                            throw e;
                        }
                    }
                    historyItem.entry(message);
                    messages.add(historyItem.build());
                }
            } else {
                throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_HTTP_ERROR).errormsg("History is disabled").jso((JsonElement)input.body()).build();
            }
            historyData.messages(messages);
        }
        return historyData.build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNHistoryOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public History channel(String channel) {
        this.channel = channel;
        return this;
    }

    public History start(Long start) {
        this.start = start;
        return this;
    }

    public History end(Long end) {
        this.end = end;
        return this;
    }

    public History reverse(Boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    public History count(Integer count) {
        this.count = count;
        return this;
    }

    public History includeTimetoken(Boolean includeTimetoken) {
        this.includeTimetoken = includeTimetoken;
        return this;
    }

    public History includeMeta(Boolean includeMeta) {
        this.includeMeta = includeMeta;
        return this;
    }
}

