/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.channel_groups;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.channel_group.PNChannelGroupsRemoveChannelResult;
import com.pubnub.api.models.server.Envelope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class RemoveChannelChannelGroup
extends Endpoint<Envelope, PNChannelGroupsRemoveChannelResult> {
    private String channelGroup;
    private List<String> channels = new ArrayList<String>();

    public RemoveChannelChannelGroup(PubNub pubnub, TelemetryManager telemetryManager, RetrofitManager retrofit, TokenManager tokenManager) {
        super(pubnub, telemetryManager, retrofit, tokenManager);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return Collections.singletonList(this.channelGroup);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channelGroup == null || this.channelGroup.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_GROUP_MISSING).build();
        }
        if (this.channels.size() == 0) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
    }

    @Override
    protected Call<Envelope> doWork(Map<String, String> params) {
        if (this.channels.size() > 0) {
            params.put("remove", PubNubUtil.joinString(this.channels, ","));
        }
        return this.getRetrofit().getChannelGroupService().removeChannel(this.getPubnub().getConfiguration().getSubscribeKey(), this.channelGroup, params);
    }

    @Override
    protected PNChannelGroupsRemoveChannelResult createResponse(Response<Envelope> input) throws PubNubException {
        if (input.body() == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PARSING_ERROR).build();
        }
        return PNChannelGroupsRemoveChannelResult.builder().build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNRemoveChannelsFromGroupOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public RemoveChannelChannelGroup channelGroup(String channelGroup) {
        this.channelGroup = channelGroup;
        return this;
    }

    public RemoveChannelChannelGroup channels(List<String> channels) {
        this.channels = channels;
        return this;
    }
}

