/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.files;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.endpoints.BuilderSteps;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.endpoints.files.requiredparambuilder.ChannelFileNameFileIdBuilder;
import com.pubnub.api.endpoints.files.requiredparambuilder.FilesBuilderSteps;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.files.PNDownloadFileResult;
import com.pubnub.api.vendor.FileEncryptionUtil;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class DownloadFile
extends Endpoint<ResponseBody, PNDownloadFileResult> {
    private final String channel;
    private final String fileName;
    private final String fileId;
    private String cipherKey;

    public DownloadFile(String channel, String fileName, String fileId, PubNub pubnubInstance, TelemetryManager telemetry, RetrofitManager retrofitInstance, TokenManager tokenManager) {
        super(pubnubInstance, telemetry, retrofitInstance, tokenManager);
        this.channel = channel;
        this.fileName = fileName;
        this.fileId = fileId;
    }

    @Override
    protected List<String> getAffectedChannels() {
        return Collections.singletonList(this.channel);
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return Collections.emptyList();
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (this.channel == null || this.channel.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
    }

    @Override
    protected Call<ResponseBody> doWork(Map<String, String> baseParams) throws PubNubException {
        return this.getRetrofit().getFilesService().downloadFile(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, this.fileId, this.fileName, baseParams);
    }

    @Override
    protected PNDownloadFileResult createResponse(Response<ResponseBody> input) throws PubNubException {
        if (input.body() == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INTERNAL_ERROR).build();
        }
        CryptoModule cryptoModule = FileEncryptionUtil.effectiveCryptoModule(this.getPubnub(), this.cipherKey);
        InputStream byteStream = ((ResponseBody)input.body()).byteStream();
        if (cryptoModule == null) {
            return new PNDownloadFileResult(this.fileName, byteStream);
        }
        InputStream decryptedByteStream = cryptoModule.decryptStream(byteStream);
        return new PNDownloadFileResult(this.fileName, decryptedByteStream);
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNFileAction;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public static Builder builder(PubNub pubNub, TelemetryManager telemetryManager, RetrofitManager retrofitManager, TokenManager tokenManager) {
        return new Builder(ChannelFileNameFileIdBuilder.create((channel, fileName, fileId) -> new DownloadFile((String)channel, (String)fileName, (String)fileId, pubNub, telemetryManager, retrofitManager, tokenManager)));
    }

    public DownloadFile cipherKey(String cipherKey) {
        this.cipherKey = cipherKey;
        return this;
    }

    public static class Builder
    extends ChannelFileNameFileIdBuilder<DownloadFile> {
        private Builder(BuilderSteps.ChannelStep<FilesBuilderSteps.FileNameStep<FilesBuilderSteps.FileIdStep<DownloadFile>>> builder) {
            super(builder);
        }
    }
}

