/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.files;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.crypto.CryptoModuleKt;
import com.pubnub.api.endpoints.BuilderSteps;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.endpoints.files.requiredparambuilder.ChannelFileNameFileIdBuilder;
import com.pubnub.api.endpoints.files.requiredparambuilder.FilesBuilderSteps;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.files.PNBaseFile;
import com.pubnub.api.models.consumer.files.PNPublishFileMessageResult;
import com.pubnub.api.models.server.files.FileUploadNotification;
import com.pubnub.api.services.FilesService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class PublishFileMessage
extends Endpoint<List<Object>, PNPublishFileMessageResult> {
    private Object message;
    private Object meta;
    private Integer ttl;
    private Boolean shouldStore;
    private final String channel;
    private final PNBaseFile pnFile;
    private final FilesService filesService;
    private final MapperManager mapper;
    private final PNConfiguration configuration;

    public PublishFileMessage(String channel, String fileName, String fileId, PubNub pubnubInstance, TelemetryManager telemetry, RetrofitManager retrofitInstance, TokenManager tokenManager) {
        super(pubnubInstance, telemetry, retrofitInstance, tokenManager);
        this.channel = channel;
        this.pnFile = new PNBaseFile(fileId, fileName);
        this.filesService = retrofitInstance.getFilesService();
        this.mapper = pubnubInstance.getMapper();
        this.configuration = pubnubInstance.getConfiguration();
    }

    @Override
    protected List<String> getAffectedChannels() {
        return null;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return null;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (this.channel == null || this.channel.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
    }

    @Override
    protected Call<List<Object>> doWork(Map<String, String> baseParams) throws PubNubException {
        String messageAsString;
        String stringifiedMessage = this.mapper.toJson(new FileUploadNotification(this.message, this.pnFile));
        CryptoModule cryptoModule = this.getPubnub().getCryptoModule();
        if (cryptoModule != null) {
            String encryptString = CryptoModuleKt.encryptString(cryptoModule, stringifiedMessage);
            messageAsString = "\"".concat(encryptString).concat("\"");
        } else {
            messageAsString = PubNubUtil.urlEncode(stringifiedMessage);
        }
        HashMap<String, String> params = new HashMap<String, String>(baseParams);
        if (this.meta != null) {
            String stringifiedMeta = this.mapper.toJson(this.meta);
            stringifiedMeta = PubNubUtil.urlEncode(stringifiedMeta);
            params.put("meta", stringifiedMeta);
        }
        if (this.shouldStore != null) {
            if (this.shouldStore.booleanValue()) {
                params.put("store", "1");
            } else {
                params.put("store", "0");
            }
        }
        if (this.ttl != null) {
            params.put("ttl", String.valueOf(this.ttl));
        }
        return this.filesService.notifyAboutFileUpload(this.configuration.getPublishKey(), this.configuration.getSubscribeKey(), this.channel, messageAsString, params);
    }

    @Override
    protected PNPublishFileMessageResult createResponse(Response<List<Object>> input) throws PubNubException {
        if (input.body() == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INTERNAL_ERROR).build();
        }
        long timetoken = Long.parseLong(((List)input.body()).get(2).toString());
        return new PNPublishFileMessageResult(timetoken);
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNFileAction;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public static Builder builder(PubNub pubNub, TelemetryManager telemetryManager, RetrofitManager retrofitManager, TokenManager tokenManager) {
        return new Builder(ChannelFileNameFileIdBuilder.create((channel, fileName, fileId) -> new PublishFileMessage((String)channel, (String)fileName, (String)fileId, pubNub, telemetryManager, retrofitManager, tokenManager)));
    }

    public PublishFileMessage message(Object message) {
        this.message = message;
        return this;
    }

    public PublishFileMessage meta(Object meta) {
        this.meta = meta;
        return this;
    }

    public PublishFileMessage ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public PublishFileMessage shouldStore(Boolean shouldStore) {
        this.shouldStore = shouldStore;
        return this;
    }

    public static class Builder
    extends ChannelFileNameFileIdBuilder<PublishFileMessage> {
        private Builder(BuilderSteps.ChannelStep<FilesBuilderSteps.FileNameStep<FilesBuilderSteps.FileIdStep<PublishFileMessage>>> builder) {
            super(builder);
        }
    }
}

