/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.objects_api.members;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.objects_api.CompositeParameterEnricher;
import com.pubnub.api.endpoints.objects_api.members.ManageChannelMembers;
import com.pubnub.api.endpoints.objects_api.utils.Include;
import com.pubnub.api.endpoints.objects_api.utils.ListCapabilities;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.objects_api.member.PNManageChannelMembersResult;
import com.pubnub.api.models.consumer.objects_api.member.PNMembers;
import com.pubnub.api.models.consumer.objects_api.member.PNUUID;
import com.pubnub.api.models.server.objects_api.EntityArrayEnvelope;
import com.pubnub.api.models.server.objects_api.PatchMemberPayload;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

final class ManageChannelMembersCommand
extends ManageChannelMembers
implements Include.HavingCustomInclude<ManageChannelMembers>,
Include.HavingUUIDInclude<ManageChannelMembers>,
ListCapabilities.HavingListCapabilites<ManageChannelMembers> {
    private final Collection<PNUUID> uuidsToSet;
    private final Collection<PNUUID> uuidsToRemove;

    ManageChannelMembersCommand(String channel, Collection<PNUUID> uuidsToSet, Collection<PNUUID> uuidsToRemove, PubNub pubnubInstance, TelemetryManager telemetry, RetrofitManager retrofitInstance, CompositeParameterEnricher compositeParameterEnricher, TokenManager tokenManager) {
        super(channel, pubnubInstance, telemetry, retrofitInstance, compositeParameterEnricher, tokenManager);
        this.uuidsToSet = uuidsToSet;
        this.uuidsToRemove = uuidsToRemove;
    }

    @Override
    protected Call<EntityArrayEnvelope<PNMembers>> executeCommand(Map<String, String> effectiveParams) throws PubNubException {
        PatchMemberPayload patchMemberBody = new PatchMemberPayload(this.uuidsToSet != null ? this.uuidsToSet : Collections.emptyList(), this.uuidsToRemove != null ? this.uuidsToRemove : Collections.emptyList());
        return this.getRetrofit().getChannelMetadataService().patchMembers(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, patchMemberBody, effectiveParams);
    }

    @Override
    protected PNManageChannelMembersResult createResponse(Response<EntityArrayEnvelope<PNMembers>> input) throws PubNubException {
        if (input.body() != null) {
            return new PNManageChannelMembersResult((EntityArrayEnvelope)input.body());
        }
        return new PNManageChannelMembersResult();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNManageChannelMembersOperation;
    }

    @Override
    public CompositeParameterEnricher getCompositeParameterEnricher() {
        return super.getCompositeParameterEnricher();
    }
}

