/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.objects_api.utils;

import com.pubnub.api.PubNubUtil;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.endpoints.objects_api.utils.HavingCompositeParameterEnricher;
import com.pubnub.api.endpoints.objects_api.utils.PNSortKey;
import com.pubnub.api.endpoints.objects_api.utils.ParameterEnricher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Sorter
implements ParameterEnricher {
    static final String SORT_PARAM_NAME = "sort";
    private List<PNSortKey> sortKeyList = new ArrayList<PNSortKey>();

    public void addSortKeys(List<PNSortKey> sortKeys) {
        this.sortKeyList = sortKeys;
    }

    @Override
    public Map<String, String> enrichParameters(Map<String, String> baseParams) {
        HashMap<String, String> enrichedMap = new HashMap<String, String>(baseParams);
        if (!this.sortKeyList.isEmpty()) {
            ArrayList<String> sortKeys = new ArrayList<String>();
            for (PNSortKey sortKey : this.sortKeyList) {
                sortKeys.add(sortKey.toSortParameter());
            }
            String sortKeysJoined = PubNubUtil.joinString(sortKeys, ",");
            enrichedMap.put(SORT_PARAM_NAME, sortKeysJoined);
        }
        return enrichedMap;
    }

    public static interface HavingSorter<T extends Endpoint<?, ?>>
    extends SortingAware<T>,
    HavingCompositeParameterEnricher {
        @Override
        default public T sort(PNSortKey ... sortKeys) {
            this.getCompositeParameterEnricher().getSorter().addSortKeys(Arrays.asList(sortKeys));
            return (T)((Endpoint)((Object)this));
        }
    }

    public static interface SortingAware<T extends Endpoint<?, ?>> {
        public T sort(PNSortKey ... var1);
    }
}

