/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PubNub;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.callbacks.ReconnectionCallback;
import com.pubnub.api.enums.PNReconnectionPolicy;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.PNTimeResult;
import java.util.Calendar;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectionManager {
    private static final Logger log = LoggerFactory.getLogger(ReconnectionManager.class);
    private static final int BASE_LINEAR_INTERVAL_IN_MILLISECONDS = 3000;
    private static final int MIN_EXPONENTIAL_BACKOFF = 2;
    private static final int MAX_EXPONENTIAL_BACKOFF = 32;
    private static final int BOUND = 1000;
    private static final int MILLISECONDS = 1000;
    private static final int MAXIMUM_RECONNECTION_RETRIES_DEFAULT = 10;
    private ReconnectionCallback callback;
    private PubNub pubnub;
    private int exponentialMultiplier = 1;
    private int failedCalls = 0;
    private PNReconnectionPolicy pnReconnectionPolicy;
    private int maxConnectionRetries;
    private final Random random = new Random();
    private Timer timer;

    public ReconnectionManager(PubNub pubnub) {
        this.pubnub = pubnub;
        this.pnReconnectionPolicy = pubnub.getConfiguration().getReconnectionPolicy();
        this.maxConnectionRetries = pubnub.getConfiguration().getMaximumReconnectionRetries();
    }

    public void setReconnectionListener(ReconnectionCallback reconnectionCallback) {
        this.callback = reconnectionCallback;
    }

    public void startPolling() {
        if (this.isReconnectionPolicyUndefined()) {
            return;
        }
        this.exponentialMultiplier = 1;
        this.failedCalls = 0;
        this.registerRetryTimer();
    }

    private void registerRetryTimer() {
        this.stopHeartbeatTimer();
        if (this.isReconnectionPolicyUndefined()) {
            return;
        }
        if (!this.maxConnectionIsSetToInfinite() && this.failedCalls >= this.maxConnectionRetries) {
            this.callback.onMaxReconnectionExhaustion();
            return;
        }
        this.timer = new Timer("Reconnection Manager timer", true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ReconnectionManager.this.callTime();
            }
        }, this.getNextIntervalInMilliSeconds());
    }

    private boolean maxConnectionIsSetToInfinite() {
        return this.maxConnectionRetries == -1;
    }

    int getNextIntervalInMilliSeconds() {
        int timerInterval = 0;
        ++this.failedCalls;
        if (this.pnReconnectionPolicy == PNReconnectionPolicy.EXPONENTIAL) {
            ++this.exponentialMultiplier;
            timerInterval = (int)(Math.pow(2.0, this.exponentialMultiplier) - 1.0);
            if (timerInterval > 32) {
                timerInterval = 2;
                this.exponentialMultiplier = 1;
                log.debug("timerInterval > MAXEXPONENTIALBACKOFF at: " + Calendar.getInstance().getTime());
            } else if (timerInterval < 1) {
                timerInterval = 2;
            }
            timerInterval = timerInterval * 1000 + this.getRandomDelayInMilliSeconds();
            log.debug("timerInterval = " + timerInterval + "ms at: " + Calendar.getInstance().getTime());
        }
        if (this.pnReconnectionPolicy == PNReconnectionPolicy.LINEAR) {
            timerInterval = 3000 + this.getRandomDelayInMilliSeconds();
        }
        return timerInterval;
    }

    private int getRandomDelayInMilliSeconds() {
        return this.random.nextInt(1000);
    }

    private void stopHeartbeatTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void callTime() {
        this.pubnub.time().async(new PNCallback<PNTimeResult>(){

            @Override
            public void onResponse(PNTimeResult result, @NotNull PNStatus status) {
                if (!status.isError()) {
                    ReconnectionManager.this.stopHeartbeatTimer();
                    ReconnectionManager.this.callback.onReconnection();
                } else {
                    log.debug("callTime() at: " + Calendar.getInstance().getTime().toString());
                    ReconnectionManager.this.registerRetryTimer();
                }
            }
        });
    }

    private boolean isReconnectionPolicyUndefined() {
        if (this.pnReconnectionPolicy == null || this.pnReconnectionPolicy == PNReconnectionPolicy.NONE) {
            log.warn("reconnection policy is disabled, please handle reconnection manually.");
            return true;
        }
        return false;
    }
}

