/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers.token_manager;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.models.consumer.access_manager.v3.PNToken;
import com.pubnub.api.vendor.Base64;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0010*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/pubnub/api/managers/token_manager/TokenParser;", "", "()V", "getException", "Lcom/pubnub/api/PubNubException;", "message", "", "unwrapToken", "Lcom/pubnub/api/models/consumer/access_manager/v3/PNToken;", "token", "toJvmMap", "", "Lco/nstant/in/cbor/model/Map;", "depth", "", "toMapOfStringToInt", "", "toPNTokenResources", "Lcom/pubnub/api/models/consumer/access_manager/v3/PNToken$PNTokenResources;", "Companion", "pubnub-gson"})
public final class TokenParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String VERSION_KEY = "v";
    @NotNull
    private static final String TIMESTAMP_KEY = "t";
    @NotNull
    private static final String TTL_KEY = "ttl";
    @NotNull
    private static final String AUTHORIZED_UUID_KEY = "uuid";
    @NotNull
    private static final String RESOURCES_KEY = "res";
    @NotNull
    private static final String PATTERNS_KEY = "pat";
    @NotNull
    private static final String META_KEY = "meta";
    @NotNull
    private static final String CHANNELS_KEY = "chan";
    @NotNull
    private static final String GROUPS_KEY = "grp";
    @NotNull
    private static final String UUIDS_KEY = "uuid";

    private final PubNubException getException(String message) {
        return new PubNubException(message, PubNubErrorBuilder.PNERROBJ_INVALID_ACCESS_TOKEN, null, null, 0, null, null);
    }

    @NotNull
    public final PNToken unwrapToken(@NotNull String token) throws PubNubException {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        String string = token;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byteArray = Base64.decode(byArray, 8);
        Intrinsics.checkNotNullExpressionValue((Object)byteArray, (String)"byteArray");
        List list = new CborDecoder((InputStream)new ByteArrayInputStream(byteArray)).decode();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"CborDecoder(byteArray.inputStream()).decode()");
        DataItem dataItem = (DataItem)CollectionsKt.firstOrNull((List)list);
        if (dataItem == null) {
            throw this.getException("Empty token");
        }
        DataItem firstElement = dataItem;
        Object object = firstElement instanceof Map ? (Map)firstElement : null;
        if (object == null || (object = TokenParser.toJvmMap$default(this, (Map)object, 0, 1, null)) == null) {
            throw this.getException("First element is not a map");
        }
        Object firstLevelMap = object;
        Object v = firstLevelMap.get(VERSION_KEY);
        if (v == null || (v = v.toString()) == null) {
            throw this.getException("Couldn't parse version");
        }
        int version = Integer.parseInt(v);
        Object v2 = firstLevelMap.get(TIMESTAMP_KEY);
        if (v2 == null || (v2 = v2.toString()) == null) {
            throw this.getException("Couldn't parse timestamp");
        }
        long timestamp = Long.parseLong(v2);
        Object v3 = firstLevelMap.get(TTL_KEY);
        if (v3 == null || (v3 = v3.toString()) == null) {
            throw this.getException("Couldn't parse ttl");
        }
        long ttl = Long.parseLong(v3);
        Object object2 = firstLevelMap.get(RESOURCES_KEY);
        java.util.Map map = object2 instanceof java.util.Map ? (java.util.Map)object2 : null;
        if (map == null) {
            throw this.getException("Resources are not present or are not map");
        }
        java.util.Map resourcesValue = map;
        Object v4 = firstLevelMap.get(PATTERNS_KEY);
        java.util.Map map2 = v4 instanceof java.util.Map ? (java.util.Map)v4 : null;
        if (map2 == null) {
            throw this.getException("Patterns are not present or are not map");
        }
        java.util.Map patternsValue = map2;
        try {
            Object v5 = firstLevelMap.get("uuid");
            PNToken pNToken = PNToken.of(version, timestamp, ttl, this.toPNTokenResources(resourcesValue), this.toPNTokenResources(patternsValue), v5 != null ? v5.toString() : null, firstLevelMap.get(META_KEY));
            Intrinsics.checkNotNullExpressionValue((Object)pNToken, (String)"{\n            PNToken.of\u2026,\n            )\n        }");
            object2 = pNToken;
        }
        catch (Exception e) {
            if (e instanceof PubNubException) {
                throw e;
            }
            throw this.getException("Couldn't parse token: " + e.getMessage());
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    private final java.util.Map<String, Object> toJvmMap(Map $this$toJvmMap, int depth) {
        if (depth > 3) {
            throw this.getException("Token is too deep");
        }
        java.util.Map result = new LinkedHashMap();
        for (DataItem key : $this$toJvmMap.getKeys()) {
            String string;
            Object object;
            Object object2;
            DataItem value = $this$toJvmMap.get(key);
            if (key instanceof ByteString) {
                Intrinsics.checkNotNullExpressionValue((Object)((ByteString)key).getBytes(), (String)"key.bytes");
                Intrinsics.checkNotNullExpressionValue((Object)StandardCharsets.UTF_8, (String)"UTF_8");
                string = new String((byte[])object2, (Charset)object);
            } else {
                string = key.toString();
            }
            String keyString = string;
            DataItem dataItem = value;
            if (dataItem instanceof Map) {
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                result.put(keyString, this.toJvmMap((Map)value, depth + 1));
                continue;
            }
            if (dataItem instanceof ByteString) {
                object2 = result;
                byte[] byArray = ((ByteString)value).getBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.bytes");
                object = byArray;
                object2.put(keyString, object);
                continue;
            }
            if (dataItem instanceof List) {
                void $this$mapTo$iv$iv;
                object2 = result;
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                Iterable $this$map$iv = (Iterable)value;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(String.valueOf(it));
                }
                object = (List)destination$iv$iv;
                object2.put(keyString, object);
                continue;
            }
            if (dataItem instanceof UnsignedInteger) {
                object2 = result;
                Intrinsics.checkNotNullExpressionValue((Object)((UnsignedInteger)value).getValue(), (String)"value.value");
                object2.put(keyString, object);
                continue;
            }
            if (dataItem instanceof NegativeInteger) {
                object2 = result;
                Intrinsics.checkNotNullExpressionValue((Object)((NegativeInteger)value).getValue(), (String)"value.value");
                object2.put(keyString, object);
                continue;
            }
            result.put(keyString, value.toString());
        }
        return result;
    }

    static /* synthetic */ java.util.Map toJvmMap$default(TokenParser tokenParser, Map map, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return tokenParser.toJvmMap(map, n);
    }

    /*
     * WARNING - void declaration
     */
    private final java.util.Map<String, Integer> toMapOfStringToInt(java.util.Map<?, ?> $this$toMapOfStringToInt) {
        void $this$mapNotNullTo$iv$iv;
        java.util.Map<?, ?> $this$mapNotNull$iv = $this$toMapOfStringToInt;
        boolean $i$f$mapNotNull = false;
        java.util.Map<?, ?> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (v instanceof BigInteger) {
                pair = TuplesKt.to((Object)String.valueOf(k), (Object)((BigInteger)v).intValue());
            } else {
                Integer n = StringsKt.toIntOrNull((String)String.valueOf(v));
                if (n != null) {
                    int it = ((Number)n).intValue();
                    boolean bl3 = false;
                    pair = TuplesKt.to((Object)String.valueOf(k), (Object)it);
                } else {
                    pair = null;
                }
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final PNToken.PNTokenResources toPNTokenResources(java.util.Map<?, ?> $this$toPNTokenResources) {
        PNToken.PNResourcePermissions pNResourcePermissions;
        Object object;
        int v;
        java.util.Map map;
        Object object2;
        Map.Entry it$iv$iv;
        Map.Entry entry;
        boolean bl;
        java.util.Map map2;
        java.util.Map<String, Integer> $this$mapValuesTo$iv$iv;
        Object obj;
        java.util.Map<String, Integer> map3;
        java.util.Map<String, Integer> groups;
        Object obj2;
        java.util.Map<String, Integer> map4;
        java.util.Map<String, Integer> channels;
        Object obj3 = $this$toPNTokenResources.get(CHANNELS_KEY);
        java.util.Map<String, Integer> map5 = obj3 instanceof java.util.Map ? (java.util.Map<String, Integer>)obj3 : null;
        if (map5 == null || (map5 = this.toMapOfStringToInt(map5)) == null) {
            map5 = channels = MapsKt.emptyMap();
        }
        if ((map4 = (obj2 = $this$toPNTokenResources.get(GROUPS_KEY)) instanceof java.util.Map ? (java.util.Map<String, Integer>)obj2 : null) == null || (map4 = this.toMapOfStringToInt(map4)) == null) {
            map4 = groups = MapsKt.emptyMap();
        }
        if ((map3 = (obj = $this$toPNTokenResources.get("uuid")) instanceof java.util.Map ? (java.util.Map<String, Integer>)obj : null) == null || (map3 = this.toMapOfStringToInt(map3)) == null) {
            map3 = MapsKt.emptyMap();
        }
        java.util.Map<String, Integer> uuids = map3;
        java.util.Map<String, Integer> $this$mapValues$iv = channels;
        boolean $i$f$mapValues = false;
        java.util.Map<String, Integer> map6 = $this$mapValues$iv;
        java.util.Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            bl = false;
            entry = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv.getKey();
            map = map2;
            boolean bl2 = false;
            v = ((Number)entry.getValue()).intValue();
            object = PNToken.PNResourcePermissions.of(v);
            map.put(object2, object);
        }
        $this$mapValues$iv = groups;
        map = destination$iv$iv;
        $i$f$mapValues = false;
        $this$mapValuesTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            bl = false;
            entry = (Map.Entry)element$iv$iv$iv;
            object = it$iv$iv.getKey();
            object2 = map2;
            boolean bl3 = false;
            v = ((Number)entry.getValue()).intValue();
            pNResourcePermissions = PNToken.PNResourcePermissions.of(v);
            object2.put((PNToken.PNResourcePermissions)object, (PNToken.PNResourcePermissions)pNResourcePermissions);
        }
        $this$mapValues$iv = uuids;
        object2 = destination$iv$iv;
        $i$f$mapValues = false;
        $this$mapValuesTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            bl = false;
            entry = (Map.Entry)element$iv$iv$iv;
            pNResourcePermissions = it$iv$iv.getKey();
            object = map2;
            boolean bl4 = false;
            v = ((Number)entry.getValue()).intValue();
            PNToken.PNResourcePermissions pNResourcePermissions2 = PNToken.PNResourcePermissions.of(v);
            object.put(pNResourcePermissions, pNResourcePermissions2);
        }
        object = destination$iv$iv;
        PNToken.PNTokenResources pNTokenResources = PNToken.PNTokenResources.of(map, (java.util.Map<String, PNToken.PNResourcePermissions>)object2, (java.util.Map<String, PNToken.PNResourcePermissions>)object);
        Intrinsics.checkNotNullExpressionValue((Object)pNTokenResources, (String)"of(\n            channels\u2026issions.of(v) }\n        )");
        return pNTokenResources;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/pubnub/api/managers/token_manager/TokenParser$Companion;", "", "()V", "AUTHORIZED_UUID_KEY", "", "CHANNELS_KEY", "GROUPS_KEY", "META_KEY", "PATTERNS_KEY", "RESOURCES_KEY", "TIMESTAMP_KEY", "TTL_KEY", "UUIDS_KEY", "VERSION_KEY", "pubnub-gson"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

