/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.models.consumer.access_manager.v3;

import java.util.Map;
import lombok.NonNull;

public class PNToken {
    private final int version;
    private final long timestamp;
    private final long ttl;
    private final String authorizedUUID;
    private final Object meta;
    @NonNull
    private final PNTokenResources resources;
    @NonNull
    private final PNTokenResources patterns;

    public static PNToken of(int v, long t, long ttl, PNTokenResources res, PNTokenResources pat, String uuid, Object meta) {
        return new PNToken(v, t, ttl, uuid, meta, res, pat);
    }

    public PNToken(int version, long timestamp, long ttl, String authorizedUUID, Object meta, @NonNull PNTokenResources resources, @NonNull PNTokenResources patterns) {
        if (resources == null) {
            throw new NullPointerException("resources is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        this.version = version;
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.authorizedUUID = authorizedUUID;
        this.meta = meta;
        this.resources = resources;
        this.patterns = patterns;
    }

    public int getVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getTtl() {
        return this.ttl;
    }

    public String getAuthorizedUUID() {
        return this.authorizedUUID;
    }

    public Object getMeta() {
        return this.meta;
    }

    @NonNull
    public PNTokenResources getResources() {
        return this.resources;
    }

    @NonNull
    public PNTokenResources getPatterns() {
        return this.patterns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PNToken)) {
            return false;
        }
        PNToken other = (PNToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getTtl() != other.getTtl()) {
            return false;
        }
        String this$authorizedUUID = this.getAuthorizedUUID();
        String other$authorizedUUID = other.getAuthorizedUUID();
        if (this$authorizedUUID == null ? other$authorizedUUID != null : !this$authorizedUUID.equals(other$authorizedUUID)) {
            return false;
        }
        Object this$meta = this.getMeta();
        Object other$meta = other.getMeta();
        if (this$meta == null ? other$meta != null : !this$meta.equals(other$meta)) {
            return false;
        }
        PNTokenResources this$resources = this.getResources();
        PNTokenResources other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        PNTokenResources this$patterns = this.getPatterns();
        PNTokenResources other$patterns = other.getPatterns();
        return !(this$patterns == null ? other$patterns != null : !((Object)this$patterns).equals(other$patterns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PNToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVersion();
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $ttl = this.getTtl();
        result = result * 59 + (int)($ttl >>> 32 ^ $ttl);
        String $authorizedUUID = this.getAuthorizedUUID();
        result = result * 59 + ($authorizedUUID == null ? 43 : $authorizedUUID.hashCode());
        Object $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : $meta.hashCode());
        PNTokenResources $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        PNTokenResources $patterns = this.getPatterns();
        result = result * 59 + ($patterns == null ? 43 : ((Object)$patterns).hashCode());
        return result;
    }

    public String toString() {
        return "PNToken(version=" + this.getVersion() + ", timestamp=" + this.getTimestamp() + ", ttl=" + this.getTtl() + ", authorizedUUID=" + this.getAuthorizedUUID() + ", meta=" + this.getMeta() + ", resources=" + this.getResources() + ", patterns=" + this.getPatterns() + ")";
    }

    public static class PNResourcePermissions {
        private final boolean read;
        private final boolean write;
        private final boolean manage;
        private final boolean delete;
        private final boolean get;
        private final boolean update;
        private final boolean join;

        public static PNResourcePermissions of(int grant) {
            return new PNResourcePermissions((grant & 1) != 0, (grant & 2) != 0, (grant & 4) != 0, (grant & 8) != 0, (grant & 0x20) != 0, (grant & 0x40) != 0, (grant & 0x80) != 0);
        }

        public PNResourcePermissions(boolean read, boolean write, boolean manage, boolean delete, boolean get, boolean update, boolean join) {
            this.read = read;
            this.write = write;
            this.manage = manage;
            this.delete = delete;
            this.get = get;
            this.update = update;
            this.join = join;
        }

        public boolean isRead() {
            return this.read;
        }

        public boolean isWrite() {
            return this.write;
        }

        public boolean isManage() {
            return this.manage;
        }

        public boolean isDelete() {
            return this.delete;
        }

        public boolean isGet() {
            return this.get;
        }

        public boolean isUpdate() {
            return this.update;
        }

        public boolean isJoin() {
            return this.join;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PNResourcePermissions)) {
                return false;
            }
            PNResourcePermissions other = (PNResourcePermissions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRead() != other.isRead()) {
                return false;
            }
            if (this.isWrite() != other.isWrite()) {
                return false;
            }
            if (this.isManage() != other.isManage()) {
                return false;
            }
            if (this.isDelete() != other.isDelete()) {
                return false;
            }
            if (this.isGet() != other.isGet()) {
                return false;
            }
            if (this.isUpdate() != other.isUpdate()) {
                return false;
            }
            return this.isJoin() == other.isJoin();
        }

        protected boolean canEqual(Object other) {
            return other instanceof PNResourcePermissions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRead() ? 79 : 97);
            result = result * 59 + (this.isWrite() ? 79 : 97);
            result = result * 59 + (this.isManage() ? 79 : 97);
            result = result * 59 + (this.isDelete() ? 79 : 97);
            result = result * 59 + (this.isGet() ? 79 : 97);
            result = result * 59 + (this.isUpdate() ? 79 : 97);
            result = result * 59 + (this.isJoin() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "PNToken.PNResourcePermissions(read=" + this.isRead() + ", write=" + this.isWrite() + ", manage=" + this.isManage() + ", delete=" + this.isDelete() + ", get=" + this.isGet() + ", update=" + this.isUpdate() + ", join=" + this.isJoin() + ")";
        }
    }

    public static class PNTokenResources {
        @NonNull
        private final Map<String, PNResourcePermissions> channels;
        @NonNull
        private final Map<String, PNResourcePermissions> channelGroups;
        @NonNull
        private final Map<String, PNResourcePermissions> uuids;

        public static PNTokenResources of(Map<String, PNResourcePermissions> chan, Map<String, PNResourcePermissions> grp, Map<String, PNResourcePermissions> uuid) {
            return new PNTokenResources(chan, grp, uuid);
        }

        public PNTokenResources(@NonNull Map<String, PNResourcePermissions> channels, @NonNull Map<String, PNResourcePermissions> channelGroups, @NonNull Map<String, PNResourcePermissions> uuids) {
            if (channels == null) {
                throw new NullPointerException("channels is marked non-null but is null");
            }
            if (channelGroups == null) {
                throw new NullPointerException("channelGroups is marked non-null but is null");
            }
            if (uuids == null) {
                throw new NullPointerException("uuids is marked non-null but is null");
            }
            this.channels = channels;
            this.channelGroups = channelGroups;
            this.uuids = uuids;
        }

        @NonNull
        public Map<String, PNResourcePermissions> getChannels() {
            return this.channels;
        }

        @NonNull
        public Map<String, PNResourcePermissions> getChannelGroups() {
            return this.channelGroups;
        }

        @NonNull
        public Map<String, PNResourcePermissions> getUuids() {
            return this.uuids;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PNTokenResources)) {
                return false;
            }
            PNTokenResources other = (PNTokenResources)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, PNResourcePermissions> this$channels = this.getChannels();
            Map<String, PNResourcePermissions> other$channels = other.getChannels();
            if (this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels)) {
                return false;
            }
            Map<String, PNResourcePermissions> this$channelGroups = this.getChannelGroups();
            Map<String, PNResourcePermissions> other$channelGroups = other.getChannelGroups();
            if (this$channelGroups == null ? other$channelGroups != null : !((Object)this$channelGroups).equals(other$channelGroups)) {
                return false;
            }
            Map<String, PNResourcePermissions> this$uuids = this.getUuids();
            Map<String, PNResourcePermissions> other$uuids = other.getUuids();
            return !(this$uuids == null ? other$uuids != null : !((Object)this$uuids).equals(other$uuids));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PNTokenResources;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, PNResourcePermissions> $channels = this.getChannels();
            result = result * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
            Map<String, PNResourcePermissions> $channelGroups = this.getChannelGroups();
            result = result * 59 + ($channelGroups == null ? 43 : ((Object)$channelGroups).hashCode());
            Map<String, PNResourcePermissions> $uuids = this.getUuids();
            result = result * 59 + ($uuids == null ? 43 : ((Object)$uuids).hashCode());
            return result;
        }

        public String toString() {
            return "PNToken.PNTokenResources(channels=" + this.getChannels() + ", channelGroups=" + this.getChannelGroups() + ", uuids=" + this.getUuids() + ")";
        }
    }
}

