/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.models.consumer.objects_api.membership;

import com.google.gson.annotations.JsonAdapter;
import com.pubnub.api.models.consumer.objects_api.util.CustomPayloadJsonInterceptor;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public abstract class PNChannelMembership {
    private final ChannelId channel;

    public static PNChannelMembership channel(String channelId) {
        return new JustChannel(new ChannelId(channelId));
    }

    public static PNChannelMembership channelWithCustom(String channelId, Map<String, Object> custom) {
        return new ChannelWithCustom(new ChannelId(channelId), new HashMap<String, Object>(custom));
    }

    public PNChannelMembership(ChannelId channel) {
        this.channel = channel;
    }

    public ChannelId getChannel() {
        return this.channel;
    }

    public static class ChannelWithCustom
    extends PNChannelMembership {
        @JsonAdapter(value=CustomPayloadJsonInterceptor.class)
        private final Object custom;

        ChannelWithCustom(@NonNull ChannelId channelId, @NonNull Object custom) {
            super(channelId);
            if (channelId == null) {
                throw new NullPointerException("channelId is marked non-null but is null");
            }
            if (custom == null) {
                throw new NullPointerException("custom is marked non-null but is null");
            }
            this.custom = custom;
        }

        public Object getCustom() {
            return this.custom;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelWithCustom)) {
                return false;
            }
            ChannelWithCustom other = (ChannelWithCustom)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Object this$custom = this.getCustom();
            Object other$custom = other.getCustom();
            return !(this$custom == null ? other$custom != null : !this$custom.equals(other$custom));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelWithCustom;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Object $custom = this.getCustom();
            result = result * 59 + ($custom == null ? 43 : $custom.hashCode());
            return result;
        }
    }

    public static class JustChannel
    extends PNChannelMembership {
        JustChannel(@NonNull ChannelId channelId) {
            super(channelId);
            if (channelId == null) {
                throw new NullPointerException("channelId is marked non-null but is null");
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JustChannel)) {
                return false;
            }
            JustChannel other = (JustChannel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        protected boolean canEqual(Object other) {
            return other instanceof JustChannel;
        }

        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class ChannelId {
        private String id;

        public ChannelId(String id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelId)) {
                return false;
            }
            ChannelId other = (ChannelId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public String getId() {
            return this.id;
        }
    }
}

