/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.models.consumer.pubsub.files;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNubError;
import com.pubnub.api.models.consumer.files.PNDownloadableFile;
import com.pubnub.api.models.consumer.pubsub.PNEvent;
import lombok.NonNull;

public class PNFileEventResult
implements PNEvent {
    @NonNull
    private final String channel;
    @NonNull
    private final Long timetoken;
    private final String publisher;
    private final Object message;
    @NonNull
    private final PNDownloadableFile file;
    private final JsonElement jsonMessage;
    private final PubNubError error;

    PNFileEventResult(@NonNull String channel, @NonNull Long timetoken, String publisher, Object message, @NonNull PNDownloadableFile file, JsonElement jsonMessage, PubNubError error) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (timetoken == null) {
            throw new NullPointerException("timetoken is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.channel = channel;
        this.timetoken = timetoken;
        this.publisher = publisher;
        this.message = message;
        this.file = file;
        this.jsonMessage = jsonMessage;
        this.error = error;
    }

    public static PNFileEventResultBuilder builder() {
        return new PNFileEventResultBuilder();
    }

    @NonNull
    public String getChannel() {
        return this.channel;
    }

    @NonNull
    public Long getTimetoken() {
        return this.timetoken;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public Object getMessage() {
        return this.message;
    }

    @NonNull
    public PNDownloadableFile getFile() {
        return this.file;
    }

    public JsonElement getJsonMessage() {
        return this.jsonMessage;
    }

    public PubNubError getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PNFileEventResult)) {
            return false;
        }
        PNFileEventResult other = (PNFileEventResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$timetoken = this.getTimetoken();
        Long other$timetoken = other.getTimetoken();
        if (this$timetoken == null ? other$timetoken != null : !((Object)this$timetoken).equals(other$timetoken)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        String this$publisher = this.getPublisher();
        String other$publisher = other.getPublisher();
        if (this$publisher == null ? other$publisher != null : !this$publisher.equals(other$publisher)) {
            return false;
        }
        Object this$message = this.getMessage();
        Object other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        PNDownloadableFile this$file = this.getFile();
        PNDownloadableFile other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        JsonElement this$jsonMessage = this.getJsonMessage();
        JsonElement other$jsonMessage = other.getJsonMessage();
        if (this$jsonMessage == null ? other$jsonMessage != null : !this$jsonMessage.equals(other$jsonMessage)) {
            return false;
        }
        PubNubError this$error = this.getError();
        PubNubError other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PNFileEventResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $timetoken = this.getTimetoken();
        result = result * 59 + ($timetoken == null ? 43 : ((Object)$timetoken).hashCode());
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        String $publisher = this.getPublisher();
        result = result * 59 + ($publisher == null ? 43 : $publisher.hashCode());
        Object $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        PNDownloadableFile $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        JsonElement $jsonMessage = this.getJsonMessage();
        result = result * 59 + ($jsonMessage == null ? 43 : $jsonMessage.hashCode());
        PubNubError $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    public String toString() {
        return "PNFileEventResult(channel=" + this.getChannel() + ", timetoken=" + this.getTimetoken() + ", publisher=" + this.getPublisher() + ", message=" + this.getMessage() + ", file=" + this.getFile() + ", jsonMessage=" + this.getJsonMessage() + ", error=" + this.getError() + ")";
    }

    public static class PNFileEventResultBuilder {
        private String channel;
        private Long timetoken;
        private String publisher;
        private Object message;
        private PNDownloadableFile file;
        private JsonElement jsonMessage;
        private PubNubError error;

        PNFileEventResultBuilder() {
        }

        public PNFileEventResultBuilder channel(@NonNull String channel) {
            if (channel == null) {
                throw new NullPointerException("channel is marked non-null but is null");
            }
            this.channel = channel;
            return this;
        }

        public PNFileEventResultBuilder timetoken(@NonNull Long timetoken) {
            if (timetoken == null) {
                throw new NullPointerException("timetoken is marked non-null but is null");
            }
            this.timetoken = timetoken;
            return this;
        }

        public PNFileEventResultBuilder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public PNFileEventResultBuilder message(Object message) {
            this.message = message;
            return this;
        }

        public PNFileEventResultBuilder file(@NonNull PNDownloadableFile file) {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            this.file = file;
            return this;
        }

        public PNFileEventResultBuilder jsonMessage(JsonElement jsonMessage) {
            this.jsonMessage = jsonMessage;
            return this;
        }

        public PNFileEventResultBuilder error(PubNubError error) {
            this.error = error;
            return this;
        }

        public PNFileEventResult build() {
            return new PNFileEventResult(this.channel, this.timetoken, this.publisher, this.message, this.file, this.jsonMessage, this.error);
        }

        public String toString() {
            return "PNFileEventResult.PNFileEventResultBuilder(channel=" + this.channel + ", timetoken=" + this.timetoken + ", publisher=" + this.publisher + ", message=" + this.message + ", file=" + this.file + ", jsonMessage=" + this.jsonMessage + ", error=" + this.error + ")";
        }
    }
}

