/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.vendor;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.vendor.Base64;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crypto {
    private static final Logger log = LoggerFactory.getLogger(Crypto.class);
    byte[] keyBytes = null;
    byte[] ivBytes = null;
    String initializationVector = "0123456789012345";
    String cipherKey;
    boolean INIT = false;
    boolean dynamicIV = false;

    public Crypto(String cipherKey) {
        this(cipherKey, false);
    }

    public Crypto(String cipherKey, boolean dynamicIV) {
        this.cipherKey = cipherKey;
        this.dynamicIV = dynamicIV;
    }

    public Crypto(String cipherKey, String customInitializationVector) {
        if (customInitializationVector != null) {
            this.initializationVector = customInitializationVector;
        }
        this.cipherKey = cipherKey;
    }

    private void initCiphers() throws PubNubException {
        if (this.INIT && !this.dynamicIV) {
            return;
        }
        try {
            this.keyBytes = new String(Crypto.hexEncode(Crypto.sha256(this.cipherKey.getBytes("UTF-8"))), "UTF-8").substring(0, 32).toLowerCase().getBytes("UTF-8");
            if (this.dynamicIV) {
                this.ivBytes = new byte[16];
                new Random().nextBytes(this.ivBytes);
            } else {
                this.ivBytes = this.initializationVector.getBytes("UTF-8");
                this.INIT = true;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw PubNubException.builder().pubnubError(Crypto.newCryptoError(11, e.toString())).errormsg(e.getMessage()).cause(e).build();
        }
    }

    public static byte[] hexEncode(byte[] input) throws PubNubException {
        StringBuffer result = new StringBuffer();
        for (byte byt : input) {
            result.append(Integer.toString((byt & 0xFF) + 256, 16).substring(1));
        }
        try {
            return result.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw PubNubException.builder().pubnubError(Crypto.newCryptoError(12, e.toString())).errormsg(e.getMessage()).cause(e).build();
        }
    }

    private static PubNubError newCryptoError(int code, String message) {
        return PubNubErrorBuilder.createCryptoError(code, message);
    }

    public String encrypt(String input) throws PubNubException {
        try {
            this.initCiphers();
            IvParameterSpec ivSpec = new IvParameterSpec(this.ivBytes);
            SecretKeySpec newKey = new SecretKeySpec(this.keyBytes, "AES");
            Cipher cipher = null;
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)newKey, ivSpec);
            if (this.dynamicIV) {
                byte[] encrypted = cipher.doFinal(input.getBytes("UTF-8"));
                byte[] encryptedWithIV = new byte[this.ivBytes.length + encrypted.length];
                System.arraycopy(this.ivBytes, 0, encryptedWithIV, 0, this.ivBytes.length);
                System.arraycopy(encrypted, 0, encryptedWithIV, this.ivBytes.length, encrypted.length);
                return new String(Base64.encode(encryptedWithIV, 0), Charset.forName("UTF-8"));
            }
            return new String(Base64.encode(cipher.doFinal(input.getBytes("UTF-8")), 0), Charset.forName("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
        catch (NoSuchPaddingException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
        catch (InvalidKeyException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
        catch (InvalidAlgorithmParameterException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
        catch (UnsupportedEncodingException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
        catch (IllegalBlockSizeException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
        catch (BadPaddingException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
    }

    public String decrypt(String cipher_text) throws PubNubException {
        try {
            byte[] dataBytes = null;
            this.initCiphers();
            if (this.dynamicIV) {
                dataBytes = Base64.decode(cipher_text, 0);
                System.arraycopy(dataBytes, 0, this.ivBytes, 0, 16);
                byte[] receivedCipherBytes = new byte[dataBytes.length - 16];
                System.arraycopy(dataBytes, 16, receivedCipherBytes, 0, dataBytes.length - 16);
                dataBytes = receivedCipherBytes;
            } else {
                dataBytes = Base64.decode(cipher_text, 0);
            }
            IvParameterSpec ivSpec = new IvParameterSpec(this.ivBytes);
            SecretKeySpec newKey = new SecretKeySpec(this.keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)newKey, ivSpec);
            return new String(cipher.doFinal(dataBytes), "UTF-8");
        }
        catch (IllegalArgumentException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
        catch (UnsupportedEncodingException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
        catch (IllegalBlockSizeException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
        catch (BadPaddingException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
        catch (InvalidKeyException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
        catch (InvalidAlgorithmParameterException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
        catch (NoSuchAlgorithmException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
        catch (NoSuchPaddingException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
    }

    public static byte[] sha256(byte[] input) throws PubNubException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashedBytes = digest.digest(input);
            return hashedBytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw PubNubException.builder().pubnubError(Crypto.newCryptoError(111, e.toString())).errormsg(e.getMessage()).cause(e).build();
        }
    }
}

