/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.vendor;

import com.pubnub.api.PubNub;
import com.pubnub.api.crypto.CryptoModule;
import java.util.Arrays;

public final class FileEncryptionUtil {
    private static final int IV_SIZE_BYTES = 16;
    public static final int BUFFER_SIZE_BYTES = 8192;
    static final String ENCODING_UTF_8 = "UTF-8";
    static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";

    public static CryptoModule effectiveCryptoModule(PubNub pubNub, String cipherKey) {
        return FileEncryptionUtil.effectiveCryptoModule(pubNub.getCryptoModule(), cipherKey);
    }

    public static CryptoModule effectiveCryptoModule(CryptoModule cryptoModule, String cipherKey) {
        if (cipherKey != null) {
            return CryptoModule.createLegacyCryptoModule(cipherKey, true);
        }
        return cryptoModule;
    }

    private static class IvAndData {
        final byte[] ivBytes;
        final byte[] dataToDecrypt;

        public IvAndData(byte[] ivBytes, byte[] dataToDecrypt) {
            this.ivBytes = ivBytes;
            this.dataToDecrypt = dataToDecrypt;
        }

        public byte[] getIvBytes() {
            return this.ivBytes;
        }

        public byte[] getDataToDecrypt() {
            return this.dataToDecrypt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IvAndData)) {
                return false;
            }
            IvAndData other = (IvAndData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getIvBytes(), other.getIvBytes())) {
                return false;
            }
            return Arrays.equals(this.getDataToDecrypt(), other.getDataToDecrypt());
        }

        protected boolean canEqual(Object other) {
            return other instanceof IvAndData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getIvBytes());
            result = result * 59 + Arrays.hashCode(this.getDataToDecrypt());
            return result;
        }

        public String toString() {
            return "FileEncryptionUtil.IvAndData(ivBytes=" + Arrays.toString(this.getIvBytes()) + ", dataToDecrypt=" + Arrays.toString(this.getDataToDecrypt()) + ")";
        }
    }
}

