/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal;

import com.google.gson.JsonElement;
import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.retry.RetryConfiguration;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.api.v2.PNConfiguration;
import com.pubnub.api.v2.PNConfigurationOverride;
import com.pubnub.api.v2.callbacks.Result;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.managers.RetrofitManager;
import com.pubnub.internal.retry.RetryableCallback;
import com.pubnub.internal.retry.RetryableRestCaller;
import com.pubnub.internal.v2.PNConfigurationImpl;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import kotlin.KotlinNullPointerException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u0003B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00010\u00032\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'\u00a2\u0006\u0002\b*H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00010\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016J\r\u00100\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00101J\u001b\u00102\u001a\u00028\u00012\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u000004H\u0002\u00a2\u0006\u0002\u00105J,\u00106\u001a\u00020)2\"\u00107\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00190\u0018j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0019`\u001aH\u0016J$\u00108\u001a\u001e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-09j\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-`:H\u0004J\b\u0010;\u001a\u00020)H\u0016J.\u0010<\u001a\u00020=2\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u0000042\n\b\u0002\u0010>\u001a\u0004\u0018\u00010-2\n\b\u0002\u0010?\u001a\u0004\u0018\u00010@H\u0002J\b\u0010A\u001a\u00020)H\u0016J&\u0010B\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010-\u0012\u0006\u0012\u0004\u0018\u00010@0C2\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u000004H\u0002J\u001b\u0010D\u001a\u00028\u00012\f\u0010E\u001a\b\u0012\u0004\u0012\u00028\u000004H\u0002\u00a2\u0006\u0002\u00105J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020-0GH\u0014J\u000e\u0010H\u001a\b\u0012\u0004\u0012\u00020-0GH\u0014J\b\u0010I\u001a\u00020)H\u0014J\u000e\u0010J\u001a\u00020)2\u0006\u0010\f\u001a\u00020\u000bJ2\u0010K\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c2\"\u0010L\u001a\u001e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-09j\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-`:H$J\u001b\u0010M\u001a\u00028\u00012\f\u0010E\u001a\b\u0012\u0004\u0012\u00028\u000004H$\u00a2\u0006\u0002\u00105J\b\u0010N\u001a\u00020\u001eH\u0014J\b\u0010O\u001a\u00020\u001eH\u0014J\b\u0010P\u001a\u00020\u001eH\u0014J\b\u0010Q\u001a\u00020RH$J\b\u0010S\u001a\u00020\u001eH\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R*\u0010\u0017\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00190\u0018j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0019`\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u001d\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-0,\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006T"}, d2={"Lcom/pubnub/internal/EndpointCore;", "Input", "Output", "Lcom/pubnub/api/Endpoint;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "<init>", "(Lcom/pubnub/internal/PubNubImpl;)V", "getPubnub", "()Lcom/pubnub/internal/PubNubImpl;", "configOverride", "Lcom/pubnub/api/v2/PNConfiguration;", "configuration", "getConfiguration", "()Lcom/pubnub/api/v2/PNConfiguration;", "retrofitManager", "Lcom/pubnub/internal/managers/RetrofitManager;", "getRetrofitManager", "()Lcom/pubnub/internal/managers/RetrofitManager;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "cachedCallback", "Ljava/util/function/Consumer;", "Lcom/pubnub/api/v2/callbacks/Result;", "Lcom/pubnub/api/v2/callbacks/Consumer;", "call", "Lretrofit2/Call;", "silenceFailures", "", "retryableRestCaller", "Lcom/pubnub/internal/retry/RetryableRestCaller;", "getRetryableRestCaller", "()Lcom/pubnub/internal/retry/RetryableRestCaller;", "retryableRestCaller$delegate", "Lkotlin/Lazy;", "overrideConfiguration", "action", "Lkotlin/Function1;", "Lcom/pubnub/api/v2/PNConfigurationOverride$Builder;", "", "Lkotlin/ExtensionFunctionType;", "queryParam", "", "", "getQueryParam", "()Ljava/util/Map;", "sync", "()Ljava/lang/Object;", "handleResponse", "response", "Lretrofit2/Response;", "(Lretrofit2/Response;)Ljava/lang/Object;", "async", "callback", "createBaseParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "silentCancel", "createException", "Lcom/pubnub/api/PubNubException;", "errorString", "errorBody", "Lcom/google/gson/JsonElement;", "retry", "extractErrorBody", "Lkotlin/Pair;", "checkAndCreateResponse", "input", "getAffectedChannels", "", "getAffectedChannelGroups", "validateParams", "overrideConfigurationInternal", "doWork", "queryParams", "createResponse", "isSubKeyRequired", "isPubKeyRequired", "isAuthRequired", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "isEndpointRetryable", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nEndpointCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndpointCore.kt\ncom/pubnub/internal/EndpointCore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,459:1\n1#2:460\n*E\n"})
public abstract class EndpointCore<Input, Output>
implements Endpoint<Output> {
    @NotNull
    private final PubNubImpl pubnub;
    @Nullable
    private PNConfiguration configOverride;
    private final Logger log;
    private Consumer<Result<Output>> cachedCallback;
    private Call<Input> call;
    private boolean silenceFailures;
    @NotNull
    private final Lazy retryableRestCaller$delegate;
    @NotNull
    private final Map<String, String> queryParam;

    protected EndpointCore(@NotNull PubNubImpl pubnub) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        this.pubnub = pubnub;
        this.log = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
        this.retryableRestCaller$delegate = LazyKt.lazy(() -> EndpointCore.retryableRestCaller_delegate$lambda$1(this));
        this.queryParam = new LinkedHashMap();
    }

    @NotNull
    protected final PubNubImpl getPubnub() {
        return this.pubnub;
    }

    @NotNull
    public final PNConfiguration getConfiguration() {
        PNConfiguration pNConfiguration = this.configOverride;
        if (pNConfiguration == null) {
            pNConfiguration = this.pubnub.getConfiguration();
        }
        return pNConfiguration;
    }

    @NotNull
    protected final RetrofitManager getRetrofitManager() {
        RetrofitManager retrofitManager;
        PNConfiguration pNConfiguration = this.configOverride;
        if (pNConfiguration != null) {
            PNConfiguration configOverrideNonNull = pNConfiguration;
            boolean bl = false;
            retrofitManager = new RetrofitManager(this.pubnub.getRetrofitManager$pubnub_kotlin_impl(), configOverrideNonNull);
        } else {
            retrofitManager = this.pubnub.getRetrofitManager$pubnub_kotlin_impl();
        }
        return retrofitManager;
    }

    private final RetryableRestCaller<Input> getRetryableRestCaller() {
        Lazy lazy = this.retryableRestCaller$delegate;
        return (RetryableRestCaller)lazy.getValue();
    }

    @NotNull
    public Endpoint<Output> overrideConfiguration(@NotNull Function1<? super PNConfigurationOverride.Builder, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        PNConfigurationImpl.Builder builder = new PNConfigurationImpl.Builder(this.getConfiguration());
        action.invoke((Object)builder);
        this.overrideConfigurationInternal(builder.build());
        return this;
    }

    @NotNull
    public Endpoint<Output> overrideConfiguration(@NotNull PNConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.overrideConfigurationInternal(configuration);
        return this;
    }

    @NotNull
    public final Map<String, String> getQueryParam() {
        return this.queryParam;
    }

    public Output sync() {
        this.validateParams();
        this.call = this.doWork(this.createBaseParams());
        RetryableRestCaller<Input> retryableRestCaller = this.getRetryableRestCaller();
        Call<Input> call = this.call;
        if (call == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
            call = null;
        }
        Response<Input> response = retryableRestCaller.execute$pubnub_kotlin_impl(call);
        return this.handleResponse(response);
    }

    private final Output handleResponse(Response<Input> response) {
        if (response.isSuccessful()) {
            return this.checkAndCreateResponse(response);
        }
        Pair<String, JsonElement> pair = this.extractErrorBody(response);
        String errorString = (String)pair.component1();
        JsonElement errorJson = (JsonElement)pair.component2();
        throw this.createException(response, errorString, errorJson);
    }

    public void async(@NotNull Consumer<Result<Output>> callback) {
        Call<Input> call;
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.cachedCallback = callback;
        try {
            this.validateParams();
            this.call = this.doWork(this.createBaseParams());
        }
        catch (PubNubException pubnubException) {
            callback.accept(Result.Companion.failure(pubnubException));
            return;
        }
        Call<Input> call2 = this.call;
        if (call2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
            call2 = null;
        }
        if ((call = this.call) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
            call = null;
        }
        Call<Input> call3 = call;
        RetryConfiguration retryConfiguration = this.getConfiguration().getRetryConfiguration();
        RetryableEndpointGroup retryableEndpointGroup = this.getEndpointGroupName();
        boolean bl = this.isEndpointRetryable();
        ScheduledExecutorService scheduledExecutorService = this.pubnub.getExecutorService$pubnub_kotlin_impl();
        call2.enqueue((Callback)new RetryableCallback<Input>(this, callback, call3, retryConfiguration, retryableEndpointGroup, bl, scheduledExecutorService){
            final /* synthetic */ EndpointCore<Input, Output> this$0;
            final /* synthetic */ Consumer<Result<Output>> $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                super($super_call_param$2, $super_call_param$3, $super_call_param$1, $super_call_param$4, $super_call_param$5);
            }

            public void onFinalResponse(Call<Input> call, Response<Input> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    Result result;
                    try {
                        result = Result.Companion.success(EndpointCore.access$checkAndCreateResponse(this.this$0, response));
                    }
                    catch (PubNubException e) {
                        result = Result.Companion.failure(e);
                    }
                    Consumer<Result<Output>> e = this.$callback;
                    Result result2 = result;
                    boolean bl = false;
                    e.accept(result2);
                } else {
                    Pair pair = EndpointCore.access$extractErrorBody(this.this$0, response);
                    String errorString = (String)pair.component1();
                    JsonElement errorJson = (JsonElement)pair.component2();
                    this.$callback.accept(Result.Companion.failure(EndpointCore.access$createException(this.this$0, response, errorString, errorJson)));
                }
            }

            public void onFinalFailure(Call<Input> call, Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (EndpointCore.access$getSilenceFailures$p(this.this$0)) {
                    return;
                }
                Throwable throwable = t;
                PubNubError error = throwable instanceof UnknownHostException || throwable instanceof ConnectException ? PubNubError.CONNECT_EXCEPTION : (throwable instanceof SocketTimeoutException ? PubNubError.SUBSCRIBE_TIMEOUT : (throwable instanceof IOException ? PubNubError.PARSING_ERROR : (throwable instanceof IllegalStateException ? PubNubError.PARSING_ERROR : PubNubError.HTTP_ERROR)));
                PubNubException pubnubException = new PubNubException(t.toString(), error, null, 0, null, null, null, null, t, null, (ExtendedRemoteAction)this.this$0, 764, null);
                this.$callback.accept(Result.Companion.failure(pubnubException));
            }
        });
    }

    @NotNull
    protected final HashMap<String, String> createBaseParams() {
        HashMap<String, String> map;
        block8: {
            Object token;
            Object object;
            block10: {
                block9: {
                    Object object2;
                    map = new HashMap<String, String>();
                    ((Map)map).putAll(this.queryParam);
                    ((Map)map).put("pnsdk", this.pubnub.generatePnsdk());
                    ((Map)map).put("uuid", this.getConfiguration().getUserId().getValue());
                    if (this.getConfiguration().getIncludeInstanceIdentifier()) {
                        ((Map)map).put("instanceid", this.pubnub.getInstanceId());
                    }
                    if (this.getConfiguration().getIncludeRequestIdentifier()) {
                        ((Map)map).put("requestid", this.pubnub.requestId$pubnub_kotlin_impl());
                    }
                    if (!this.isAuthRequired()) break block8;
                    object = this.configOverride;
                    if (object == null || (object = object.getAuthToken()) == null) break block9;
                    Object it = object2 = object;
                    boolean bl = false;
                    object = ((CharSequence)it).length() > 0 ? object2 : null;
                    if (object != null) break block10;
                }
                object = this.pubnub.getTokenManager$pubnub_kotlin_impl().getToken();
            }
            if ((token = object) != null) {
                ((Map)map).put("auth", token);
            } else if (PNConfiguration.Companion.isValid(this.getConfiguration().getAuthKey())) {
                ((Map)map).put("auth", this.getConfiguration().getAuthKey());
            }
        }
        return map;
    }

    public void silentCancel() {
        if (this.call != null) {
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            if (!call.isCanceled()) {
                this.silenceFailures = true;
                Call<Input> call2 = this.call;
                if (call2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                    call2 = null;
                }
                call2.cancel();
            }
        }
    }

    private final PubNubException createException(Response<Input> response, String errorString, JsonElement errorBody) {
        Collection collection;
        Collection collection2;
        Object channelGroupName;
        Iterator<JsonElement> iterator;
        List errorChannels = new ArrayList();
        List errorGroups = new ArrayList();
        if (errorBody != null && this.pubnub.getMapper().isJsonObject(errorBody) && this.pubnub.getMapper().hasField(errorBody, "payload")) {
            JsonElement jsonElement = this.pubnub.getMapper().getField(errorBody, "payload");
            Intrinsics.checkNotNull((Object)jsonElement);
            JsonElement payloadBody = jsonElement;
            if (this.pubnub.getMapper().hasField(payloadBody, "channels")) {
                iterator = this.pubnub.getMapper().getArrayIterator(payloadBody, "channels");
                while (iterator.hasNext()) {
                    String string = this.pubnub.getMapper().elementToString(iterator.next());
                    Intrinsics.checkNotNull((Object)string);
                    errorChannels.add(string);
                }
            }
            if (this.pubnub.getMapper().hasField(payloadBody, "channel-groups")) {
                iterator = this.pubnub.getMapper().getArrayIterator(payloadBody, "channel-groups");
                while (iterator.hasNext()) {
                    String string;
                    String it;
                    JsonElement node = iterator.next();
                    Intrinsics.checkNotNull((Object)this.pubnub.getMapper().elementToString(node));
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)String.valueOf(StringsKt.first((CharSequence)it)), (Object)":")) {
                        String string2 = it.substring(1);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    } else {
                        string = it;
                    }
                    channelGroupName = string;
                    errorGroups.add(channelGroupName);
                }
            }
        }
        if ((iterator = (Collection)errorChannels).isEmpty()) {
            boolean bl = false;
            try {
                channelGroupName = this.getAffectedChannels();
            }
            catch (UninitializedPropertyAccessException e) {
                channelGroupName = CollectionsKt.emptyList();
            }
            collection2 = channelGroupName;
        } else {
            collection2 = iterator;
        }
        List affectedChannels = (List)collection2;
        Collection collection3 = errorGroups;
        if (collection3.isEmpty()) {
            List list;
            boolean bl = false;
            try {
                list = this.getAffectedChannelGroups();
            }
            catch (UninitializedPropertyAccessException e) {
                list = CollectionsKt.emptyList();
            }
            collection = list;
        } else {
            collection = collection3;
        }
        List affectedChannelGroups = (List)collection;
        collection3 = PubNubError.HTTP_ERROR;
        JsonElement jsonElement = errorBody;
        String string = jsonElement != null ? jsonElement.toString() : null;
        int n = response.code();
        Call<Input> call = this.call;
        if (call == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
            call = null;
        }
        Call<Input> call2 = call;
        String string3 = response.headers().get("Retry-After");
        Integer n2 = string3 != null ? StringsKt.toIntOrNull((String)string3) : null;
        PubNubException.RequestInfo requestInfo = new PubNubException.RequestInfo(response.raw().request().url().isHttps(), response.raw().request().url().host(), response.raw().request().url().queryParameter("uuid"), response.raw().request().url().queryParameter("auth"), response.raw().request());
        return new PubNubException(errorString, (PubNubError)collection3, string, n, call2, n2, affectedChannels, affectedChannelGroups, null, requestInfo, (ExtendedRemoteAction)this, 256, null);
    }

    static /* synthetic */ PubNubException createException$default(EndpointCore endpointCore, Response response, String string, JsonElement jsonElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createException");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            jsonElement = null;
        }
        return endpointCore.createException(response, string, jsonElement);
    }

    public void retry() {
        this.silenceFailures = false;
        Consumer<Result<Output>> consumer = this.cachedCallback;
        if (consumer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedCallback");
            consumer = null;
        }
        this.async(consumer);
    }

    private final Pair<String, JsonElement> extractErrorBody(Response<Input> response) {
        JsonElement jsonElement;
        String string;
        try {
            ResponseBody responseBody = response.errorBody();
            string = responseBody != null ? responseBody.string() : null;
        }
        catch (IOException e) {
            string = "N/A";
        }
        String errorBodyString = string;
        try {
            jsonElement = this.pubnub.getMapper().fromJson(errorBodyString, JsonElement.class);
        }
        catch (PubNubException e) {
            jsonElement = null;
        }
        JsonElement errorBodyJson = jsonElement;
        return TuplesKt.to((Object)errorBodyString, (Object)errorBodyJson);
    }

    private final Output checkAndCreateResponse(Response<Input> input) {
        try {
            return this.createResponse(input);
        }
        catch (PubNubException pubnubException) {
            int n = input.code();
            String string = this.pubnub.getMapper().toJson(input.body());
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call2 = call;
            throw PubNubException.copy$default((PubNubException)pubnubException, null, null, (String)string, (int)n, call2, null, null, null, null, null, null, (int)2019, null);
        }
        catch (KotlinNullPointerException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call3 = call;
            int n = input.code();
            String string2 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string2, n, call3, null, null, null, (Throwable)e, null, null, 1760, null);
        }
        catch (IllegalStateException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call4 = call;
            int n = input.code();
            String string3 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string3, n, call4, null, null, null, (Throwable)e, null, null, 1760, null);
        }
        catch (IndexOutOfBoundsException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call5 = call;
            int n = input.code();
            String string4 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string4, n, call5, null, null, null, (Throwable)e, null, null, 1760, null);
        }
        catch (NullPointerException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call6 = call;
            int n = input.code();
            String string5 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string5, n, call6, null, null, null, (Throwable)e, null, null, 1760, null);
        }
        catch (IllegalArgumentException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call7 = call;
            int n = input.code();
            String string6 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string6, n, call7, null, null, null, (Throwable)e, null, null, 1760, null);
        }
        catch (TypeCastException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call8 = call;
            int n = input.code();
            String string7 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string7, n, call8, null, null, null, (Throwable)e, null, null, 1760, null);
        }
        catch (ClassCastException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call9 = call;
            int n = input.code();
            String string8 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string8, n, call9, null, null, null, (Throwable)e, null, null, 1760, null);
        }
        catch (UninitializedPropertyAccessException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call10 = call;
            int n = input.code();
            String string9 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string9, n, call10, null, null, null, (Throwable)e, null, null, 1760, null);
        }
    }

    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.emptyList();
    }

    protected void validateParams() {
        if (this.isSubKeyRequired() && !PNConfiguration.Companion.isValid(this.getConfiguration().getSubscribeKey())) {
            throw new PubNubException(PubNubError.SUBSCRIBE_KEY_MISSING, null, 2, null);
        }
        if (this.isPubKeyRequired() && !PNConfiguration.Companion.isValid(this.getConfiguration().getPublishKey())) {
            throw new PubNubException(PubNubError.PUBLISH_KEY_MISSING, null, 2, null);
        }
    }

    public final void overrideConfigurationInternal(@NotNull PNConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configOverride = configuration;
    }

    @NotNull
    protected abstract Call<Input> doWork(@NotNull HashMap<String, String> var1);

    protected abstract Output createResponse(@NotNull Response<Input> var1);

    protected boolean isSubKeyRequired() {
        return true;
    }

    protected boolean isPubKeyRequired() {
        return false;
    }

    protected boolean isAuthRequired() {
        return true;
    }

    @NotNull
    protected abstract RetryableEndpointGroup getEndpointGroupName();

    protected boolean isEndpointRetryable() {
        return true;
    }

    private static final RetryableRestCaller retryableRestCaller_delegate$lambda$1(EndpointCore this$0) {
        return new RetryableRestCaller(this$0.getConfiguration().getRetryConfiguration(), this$0.getEndpointGroupName(), this$0.isEndpointRetryable());
    }

    public static final /* synthetic */ Object access$checkAndCreateResponse(EndpointCore $this, Response input) {
        return $this.checkAndCreateResponse(input);
    }

    public static final /* synthetic */ Pair access$extractErrorBody(EndpointCore $this, Response response) {
        return $this.extractErrorBody(response);
    }

    public static final /* synthetic */ PubNubException access$createException(EndpointCore $this, Response response, String errorString, JsonElement errorBody) {
        return $this.createException(response, errorString, errorBody);
    }

    public static final /* synthetic */ boolean access$getSilenceFailures$p(EndpointCore $this) {
        return $this.silenceFailures;
    }
}

