/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.crypto;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.crypto.cryptor.Cryptor;
import com.pubnub.api.crypto.data.EncryptedData;
import com.pubnub.api.crypto.data.EncryptedStreamData;
import com.pubnub.internal.crypto.CryptoModuleImplKt;
import com.pubnub.internal.crypto.cryptor.HeaderParser;
import com.pubnub.internal.crypto.cryptor.LegacyCryptorKt;
import com.pubnub.internal.crypto.cryptor.ParseResult;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0018\u0010\u001b\u001a\u00020\u000f2\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/pubnub/internal/crypto/CryptoModuleImpl;", "Lcom/pubnub/api/crypto/CryptoModule;", "primaryCryptor", "Lcom/pubnub/api/crypto/cryptor/Cryptor;", "cryptorsForDecryptionOnly", "", "<init>", "(Lcom/pubnub/api/crypto/cryptor/Cryptor;Ljava/util/List;)V", "getPrimaryCryptor$pubnub_kotlin_impl", "()Lcom/pubnub/api/crypto/cryptor/Cryptor;", "getCryptorsForDecryptionOnly$pubnub_kotlin_impl", "()Ljava/util/List;", "headerParser", "Lcom/pubnub/internal/crypto/cryptor/HeaderParser;", "encrypt", "", "data", "decrypt", "encryptedData", "encryptStream", "Ljava/io/InputStream;", "stream", "decryptStream", "validateCryptorIdSize", "", "cryptorId", "getDecryptedDataForLegacyCryptor", "getDecryptedDataForCryptorWithHeader", "parsedHeader", "Lcom/pubnub/internal/crypto/cryptor/ParseResult$Success;", "getCryptorById", "validateData", "validateStreamAndReturnBuffered", "Ljava/io/BufferedInputStream;", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nCryptoModuleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CryptoModuleImpl.kt\ncom/pubnub/internal/crypto/CryptoModuleImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n295#2,2:198\n230#2,2:200\n295#2,2:202\n*S KotlinDebug\n*F\n+ 1 CryptoModuleImpl.kt\ncom/pubnub/internal/crypto/CryptoModuleImpl\n*L\n71#1:198,2\n80#1:200,2\n123#1:202,2\n*E\n"})
public final class CryptoModuleImpl
implements CryptoModule {
    @NotNull
    private final Cryptor primaryCryptor;
    @NotNull
    private final List<Cryptor> cryptorsForDecryptionOnly;
    @NotNull
    private final HeaderParser headerParser;

    public CryptoModuleImpl(@NotNull Cryptor primaryCryptor, @NotNull List<? extends Cryptor> cryptorsForDecryptionOnly) {
        Intrinsics.checkNotNullParameter((Object)primaryCryptor, (String)"primaryCryptor");
        Intrinsics.checkNotNullParameter(cryptorsForDecryptionOnly, (String)"cryptorsForDecryptionOnly");
        this.primaryCryptor = primaryCryptor;
        this.cryptorsForDecryptionOnly = cryptorsForDecryptionOnly;
        this.headerParser = new HeaderParser();
    }

    public /* synthetic */ CryptoModuleImpl(Cryptor cryptor, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(cryptor, list);
    }

    public final /* synthetic */ Cryptor getPrimaryCryptor$pubnub_kotlin_impl() {
        return this.primaryCryptor;
    }

    public final /* synthetic */ List getCryptorsForDecryptionOnly$pubnub_kotlin_impl() {
        return this.cryptorsForDecryptionOnly;
    }

    @NotNull
    public byte[] encrypt(@NotNull byte[] data) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] cryptorId = this.primaryCryptor.id();
        this.validateData(data);
        this.validateCryptorIdSize(cryptorId);
        EncryptedData encryptedData = this.primaryCryptor.encrypt(data);
        byte[] metadata = encryptedData.component1();
        byte[] encryptedData2 = encryptedData.component2();
        if (Arrays.equals(cryptorId, LegacyCryptorKt.getLEGACY_CRYPTOR_ID())) {
            byArray = encryptedData2;
        } else {
            byte[] cryptorHeader = this.headerParser.createCryptorHeader(cryptorId, metadata);
            byArray = ArraysKt.plus((byte[])cryptorHeader, (byte[])encryptedData2);
        }
        return byArray;
    }

    @NotNull
    public byte[] decrypt(@NotNull byte[] encryptedData) {
        byte[] byArray;
        ParseResult<? extends byte[]> parsedData;
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        this.validateData(encryptedData);
        ParseResult<? extends byte[]> parseResult = parsedData = this.headerParser.parseDataWithHeader(encryptedData);
        if (parseResult instanceof ParseResult.NoHeader) {
            byArray = this.getDecryptedDataForLegacyCryptor(encryptedData);
        } else if (parseResult instanceof ParseResult.Success) {
            byArray = this.getDecryptedDataForCryptorWithHeader((ParseResult.Success)parsedData);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        byte[] decryptedData = byArray;
        return decryptedData;
    }

    @NotNull
    public InputStream encryptStream(@NotNull InputStream stream) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        BufferedInputStream bufferedInputStream = this.validateStreamAndReturnBuffered(stream);
        EncryptedStreamData encryptedStreamData = this.primaryCryptor.encryptStream((InputStream)bufferedInputStream);
        byte[] metadata = encryptedStreamData.component1();
        InputStream encryptedData = encryptedStreamData.component2();
        if (Arrays.equals(this.primaryCryptor.id(), LegacyCryptorKt.getLEGACY_CRYPTOR_ID())) {
            inputStream = encryptedData;
        } else {
            byte[] cryptorHeader = this.headerParser.createCryptorHeader(this.primaryCryptor.id(), metadata);
            inputStream = new SequenceInputStream(new ByteArrayInputStream(cryptorHeader), encryptedData);
        }
        return inputStream;
    }

    @NotNull
    public InputStream decryptStream(@NotNull InputStream encryptedData) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        BufferedInputStream bufferedInputStream = this.validateStreamAndReturnBuffered(encryptedData);
        ParseResult<? extends InputStream> parsedHeader = this.headerParser.parseDataWithHeader(bufferedInputStream);
        if (Intrinsics.areEqual(parsedHeader, (Object)ParseResult.NoHeader.INSTANCE)) {
            Cryptor decryptor;
            Object v0;
            block7: {
                Iterable $this$firstOrNull$iv = this.cryptorsForDecryptionOnly;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Cryptor it = (Cryptor)element$iv;
                    boolean bl = false;
                    if (!Arrays.equals(it.id(), LegacyCryptorKt.getLEGACY_CRYPTOR_ID())) continue;
                    v0 = element$iv;
                    break block7;
                }
                v0 = null;
            }
            if ((object = (decryptor = (Cryptor)v0)) == null || (object = object.decryptStream(new EncryptedStreamData(null, (InputStream)bufferedInputStream, 1, null))) == null) {
                throw new PubNubException("LegacyCryptor not registered", PubNubError.UNKNOWN_CRYPTOR, null, 0, null, null, null, null, null, null, null, 2044, null);
            }
        } else if (parsedHeader instanceof ParseResult.Success) {
            Object element$iv2;
            block8: {
                Iterable $this$first$iv = this.cryptorsForDecryptionOnly;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Cryptor it = (Cryptor)element$iv2;
                    boolean bl = false;
                    if (!Arrays.equals(it.id(), ((ParseResult.Success)parsedHeader).getCryptoId())) continue;
                    break block8;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Cryptor decryptor = (Cryptor)element$iv2;
            object = decryptor.decryptStream(new EncryptedStreamData(((ParseResult.Success)parsedHeader).getCryptorData(), (InputStream)((ParseResult.Success)parsedHeader).getEncryptedData()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final void validateCryptorIdSize(byte[] cryptorId) {
        if (cryptorId.length != 4) {
            throw new PubNubException("CryptorId should be exactly 4 bytes long", PubNubError.UNKNOWN_CRYPTOR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    private final byte[] getDecryptedDataForLegacyCryptor(byte[] encryptedData) {
        Object object;
        block3: {
            block2: {
                object = this.getCryptorById(LegacyCryptorKt.getLEGACY_CRYPTOR_ID());
                if (object == null) break block2;
                byte[] byArray = object.decrypt(new EncryptedData(null, encryptedData, 1, null));
                object = byArray;
                if (byArray != null) break block3;
            }
            throw new PubNubException("LegacyCryptor not available", PubNubError.UNKNOWN_CRYPTOR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        return object;
    }

    private final byte[] getDecryptedDataForCryptorWithHeader(ParseResult.Success<? extends byte[]> parsedHeader) {
        Object object;
        Object decryptedData;
        block3: {
            block2: {
                decryptedData = null;
                byte[] cryptorId = parsedHeader.getCryptoId();
                byte[] cryptorData = parsedHeader.getCryptorData();
                byte[] pureEncryptedData = parsedHeader.getEncryptedData();
                Cryptor cryptor = this.getCryptorById(cryptorId);
                object = cryptor;
                if (object == null) break block2;
                byte[] byArray = object.decrypt(new EncryptedData(cryptorData, pureEncryptedData));
                object = byArray;
                if (byArray != null) break block3;
            }
            throw new PubNubException("No cryptor found", PubNubError.UNKNOWN_CRYPTOR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        decryptedData = object;
        return decryptedData;
    }

    private final Cryptor getCryptorById(byte[] cryptorId) {
        Object v0;
        block1: {
            this.validateCryptorIdSize(cryptorId);
            Iterable $this$firstOrNull$iv = this.cryptorsForDecryptionOnly;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Cryptor it = (Cryptor)element$iv;
                boolean bl = false;
                if (!Arrays.equals(it.id(), cryptorId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void validateData(byte[] data) {
        if (data.length == 0) {
            throw new PubNubException("Encryption/Decryption of empty data not allowed.", PubNubError.ENCRYPTION_AND_DECRYPTION_OF_EMPTY_DATA_NOT_ALLOWED, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    private final BufferedInputStream validateStreamAndReturnBuffered(InputStream stream) {
        InputStream inputStream = stream;
        int n = 8192;
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
        CryptoModuleImplKt.checkMinSize(bufferedInputStream, 1, (Function1<? super Integer, Unit>)((Function1)CryptoModuleImpl::validateStreamAndReturnBuffered$lambda$3));
        return bufferedInputStream;
    }

    private static final Unit validateStreamAndReturnBuffered$lambda$3(int it) {
        throw new PubNubException("Encryption/Decryption of empty data not allowed.", PubNubError.ENCRYPTION_AND_DECRYPTION_OF_EMPTY_DATA_NOT_ALLOWED, null, 0, null, null, null, null, null, null, null, 2044, null);
    }
}

