/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.crypto.cryptor;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.internal.crypto.CryptoModuleImplKt;
import com.pubnub.internal.crypto.cryptor.CryptorHeader;
import com.pubnub.internal.crypto.cryptor.CryptorHeaderVersion;
import com.pubnub.internal.crypto.cryptor.HeaderParserKt;
import com.pubnub.internal.crypto.cryptor.ParseResult;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\t2\u0006\u0010\u0012\u001a\u00020\u000eJ\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00192\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0017H\u0002J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0011H\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/pubnub/internal/crypto/cryptor/HeaderParser;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "parseDataWithHeader", "Lcom/pubnub/internal/crypto/cryptor/ParseResult;", "Ljava/io/InputStream;", "stream", "Ljava/io/BufferedInputStream;", "readExactlyNBytez", "", "bufferedInputStream", "numberOfBytesToRead", "", "data", "createCryptorHeader", "cryptorId", "cryptorData", "getCurrentCryptoHeaderVersion", "", "getCryptorDataSizeAndStartingIndex", "Lkotlin/Pair;", "cryptorDataSizeFirstByte", "validateCryptorHeaderVersion", "", "convertTwoBytesToIntBigEndian", "byte1", "byte2", "writeNumberOnTwoBytes", "number", "pubnub-kotlin-impl"})
public final class HeaderParser {
    private final Logger log = LoggerFactory.getLogger(HeaderParser.class);

    @NotNull
    public final ParseResult<? extends InputStream> parseDataWithHeader(@NotNull BufferedInputStream stream) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        InputStream inputStream = stream;
        BufferedInputStream bufferedInputStream = (BufferedInputStream)inputStream;
        bufferedInputStream.mark(Integer.MAX_VALUE);
        byte[] possibleInitialHeader = new byte[10];
        int initiallyRead = bufferedInputStream.read(possibleInitialHeader);
        if (!Arrays.equals(ArraysKt.sliceArray((byte[])possibleInitialHeader, (IntRange)new IntRange(0, 3)), HeaderParserKt.access$getSENTINEL$p())) {
            bufferedInputStream.reset();
            return ParseResult.NoHeader.INSTANCE;
        }
        if (initiallyRead < 10) {
            throw new PubNubException("Minimal size of Cryptor Data Header is: 10", PubNubError.CRYPTOR_HEADER_PARSE_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        this.validateCryptorHeaderVersion(possibleInitialHeader);
        byte[] cryptorId = ArraysKt.sliceArray((byte[])possibleInitialHeader, (IntRange)new IntRange(5, 8));
        byte cryptorDataSizeFirstByte = UByte.constructor-impl((byte)possibleInitialHeader[9]);
        if (cryptorDataSizeFirstByte == -1) {
            byte[] cryptorDataSizeBytes = this.readExactlyNBytez(bufferedInputStream, 2);
            int cryptorDataSize = this.convertTwoBytesToIntBigEndian(cryptorDataSizeBytes[0], cryptorDataSizeBytes[1]);
            byArray = this.readExactlyNBytez(bufferedInputStream, cryptorDataSize);
        } else {
            byArray = cryptorDataSizeFirstByte == 0 ? new byte[]{} : this.readExactlyNBytez(bufferedInputStream, cryptorDataSizeFirstByte & 0xFF);
        }
        byte[] cryptorData = byArray;
        return new ParseResult.Success<BufferedInputStream>(cryptorId, cryptorData, bufferedInputStream);
    }

    private final byte[] readExactlyNBytez(BufferedInputStream bufferedInputStream, int numberOfBytesToRead) {
        return CryptoModuleImplKt.readExactlyNBytez(bufferedInputStream, numberOfBytesToRead, (Function1<? super Integer, Unit>)((Function1)HeaderParser::readExactlyNBytez$lambda$0));
    }

    @NotNull
    public final ParseResult<? extends byte[]> parseDataWithHeader(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.length < HeaderParserKt.access$getSENTINEL$p().length) {
            return ParseResult.NoHeader.INSTANCE;
        }
        byte[] sentinel = ArraysKt.sliceArray((byte[])data, (IntRange)new IntRange(0, 3));
        if (!Arrays.equals(HeaderParserKt.access$getSENTINEL$p(), sentinel)) {
            return ParseResult.NoHeader.INSTANCE;
        }
        if (data.length < 10) {
            throw new PubNubException("Minimal size of encrypted data having Cryptor Data Header is: 10", PubNubError.CRYPTOR_DATA_HEADER_SIZE_TO_SMALL, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        this.validateCryptorHeaderVersion(data);
        byte[] cryptorId = ArraysKt.sliceArray((byte[])data, (IntRange)new IntRange(5, 8));
        this.log.trace("CryptoId: " + new String(cryptorId, Charsets.UTF_8));
        byte cryptorDataSizeFirstByte = data[9];
        Pair<Integer, Integer> pair = this.getCryptorDataSizeAndStartingIndex(data, cryptorDataSizeFirstByte);
        int startingIndexOfCryptorData = ((Number)pair.component1()).intValue();
        int cryptorDataSize = ((Number)pair.component2()).intValue();
        if (startingIndexOfCryptorData + cryptorDataSize > data.length) {
            throw new PubNubException("Input data size: " + data.length + " is to small to fit header of size " + startingIndexOfCryptorData + " and cryptorData of size: " + cryptorDataSize, PubNubError.CRYPTOR_HEADER_PARSE_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        byte[] cryptorData = ArraysKt.sliceArray((byte[])data, (IntRange)RangesKt.until((int)startingIndexOfCryptorData, (int)(startingIndexOfCryptorData + cryptorDataSize)));
        int sizeOfCryptorHeader = startingIndexOfCryptorData + cryptorDataSize;
        byte[] encryptedData = ArraysKt.sliceArray((byte[])data, (IntRange)RangesKt.until((int)sizeOfCryptorHeader, (int)data.length));
        return new ParseResult.Success<byte[]>(cryptorId, cryptorData, encryptedData);
    }

    @NotNull
    public final byte[] createCryptorHeader(@NotNull byte[] cryptorId, @Nullable byte[] cryptorData) {
        byte[] byArray;
        byte[] byArray2;
        int cryptorDataSize;
        Intrinsics.checkNotNullParameter((Object)cryptorId, (String)"cryptorId");
        byte[] sentinel = HeaderParserKt.access$getSENTINEL$p();
        byte cryptorHeaderVersion = this.getCurrentCryptoHeaderVersion();
        int n = cryptorDataSize = cryptorData != null ? cryptorData.length : 0;
        if (cryptorDataSize < (0xFFFFFFFF & 0xFF)) {
            byArray2 = new byte[]{(byte)cryptorDataSize};
            byArray = byArray2;
        } else if (cryptorDataSize < 65535) {
            byArray2 = new byte[]{(byte)cryptorDataSize};
            byArray = ArraysKt.plus((byte[])byArray2, (byte[])this.writeNumberOnTwoBytes(cryptorDataSize));
        } else {
            throw new PubNubException("Cryptor Data Size is: " + cryptorDataSize + " whereas max cryptor data size is: 65535", PubNubError.CRYPTOR_HEADER_PARSE_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        byte[] finalCryptorDataSize = byArray;
        byte[] byArray3 = cryptorData;
        if (cryptorData == null) {
            byArray3 = new byte[]{};
        }
        CryptorHeader cryptorHeader = new CryptorHeader(sentinel, cryptorHeaderVersion, cryptorId, finalCryptorDataSize, byArray3);
        return cryptorHeader.toByteArray();
    }

    private final byte getCurrentCryptoHeaderVersion() {
        return (byte)CryptorHeaderVersion.One.getValue();
    }

    private final Pair<Integer, Integer> getCryptorDataSizeAndStartingIndex(byte[] data, byte cryptorDataSizeFirstByte) {
        int startingIndexOfCryptorData = 0;
        int cryptorDataSize = 0;
        byte cryptoDataFirstByteAsUByte = UByte.constructor-impl((byte)cryptorDataSizeFirstByte);
        if (cryptoDataFirstByteAsUByte == -1) {
            startingIndexOfCryptorData = 12;
            this.log.trace("\"Cryptor data size\" first byte's value is 255 that mean that size is stored on two next bytes");
            byte cryptorDataSizeSecondByte = data[10];
            byte cryptorDataSizeThirdByte = data[11];
            cryptorDataSize = this.convertTwoBytesToIntBigEndian(cryptorDataSizeSecondByte, cryptorDataSizeThirdByte);
        } else {
            startingIndexOfCryptorData = 10;
            cryptorDataSize = cryptoDataFirstByteAsUByte & 0xFF;
            this.log.trace("\"Cryptor data size\" is 1 byte long and its value is: " + cryptorDataSize);
        }
        return new Pair((Object)startingIndexOfCryptorData, (Object)cryptorDataSize);
    }

    private final void validateCryptorHeaderVersion(byte[] data) {
        byte version = UByte.constructor-impl((byte)data[4]);
        int versionAsInt = version & 0xFF;
        this.log.trace("Cryptor header version is: " + versionAsInt);
        if (CryptorHeaderVersion.Companion.fromValue(versionAsInt) == null) {
            throw new PubNubException("Cryptor header version unknown. Please, update SDK", PubNubError.CRYPTOR_HEADER_VERSION_UNKNOWN, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    private final int convertTwoBytesToIntBigEndian(byte byte1, byte byte2) {
        return (byte1 & 0xFF) << 8 | byte2 & 0xFF;
    }

    private final byte[] writeNumberOnTwoBytes(int number) {
        byte[] result = new byte[]{(byte)(number >> 8), (byte)number};
        return result;
    }

    private static final Unit readExactlyNBytez$lambda$0(int n) {
        throw new PubNubException("Couldn't read " + n + " bytes", null, 2, null);
    }
}

