/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.presence;

import com.google.gson.JsonElement;
import com.pubnub.api.endpoints.presence.HereNow;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.presence.PNHereNowChannelData;
import com.pubnub.api.models.consumer.presence.PNHereNowOccupantData;
import com.pubnub.api.models.consumer.presence.PNHereNowResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.PubNubUtilKt;
import com.pubnub.internal.managers.MapperManager;
import com.pubnub.internal.models.server.Envelope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0000\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005BE\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0017\u001a\u00020\rH\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J8\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001b2\"\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001dj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`\u001eH\u0014J\u001c\u0010\u001f\u001a\u00020\u00042\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020!H\u0014J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0014J\u0016\u0010&\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0003H\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010 \u001a\u00020\u0003H\u0002J\u001c\u0010+\u001a\u00020,2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0-H\u0002R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u000e\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006."}, d2={"Lcom/pubnub/internal/endpoints/presence/HereNowEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/Envelope;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/presence/PNHereNowResult;", "Lcom/pubnub/api/endpoints/presence/HereNow;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "channels", "", "", "channelGroups", "includeState", "", "includeUUIDs", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/util/List;Ljava/util/List;ZZ)V", "getChannels", "()Ljava/util/List;", "getChannelGroups", "getIncludeState", "()Z", "getIncludeUUIDs", "isGlobalHereNow", "getAffectedChannels", "getAffectedChannelGroups", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNHereNowOperation;", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "parseSingleChannelResponse", "parseMultipleChannelResponse", "prepareOccupantData", "", "Lcom/pubnub/api/models/consumer/presence/PNHereNowOccupantData;", "addQueryParams", "", "", "pubnub-kotlin-impl"})
public final class HereNowEndpoint
extends EndpointCore<Envelope<JsonElement>, PNHereNowResult>
implements HereNow {
    @NotNull
    private final List<String> channels;
    @NotNull
    private final List<String> channelGroups;
    private final boolean includeState;
    private final boolean includeUUIDs;

    public HereNowEndpoint(@NotNull PubNubImpl pubnub, @NotNull List<String> channels, @NotNull List<String> channelGroups, boolean includeState, boolean includeUUIDs) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        super(pubnub);
        this.channels = channels;
        this.channelGroups = channelGroups;
        this.includeState = includeState;
        this.includeUUIDs = includeUUIDs;
    }

    public /* synthetic */ HereNowEndpoint(PubNubImpl pubNubImpl, List list, List list2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        this(pubNubImpl, list, list2, bl, bl2);
    }

    @NotNull
    public List<String> getChannels() {
        return this.channels;
    }

    @NotNull
    public List<String> getChannelGroups() {
        return this.channelGroups;
    }

    public boolean getIncludeState() {
        return this.includeState;
    }

    public boolean getIncludeUUIDs() {
        return this.includeUUIDs;
    }

    private final boolean isGlobalHereNow() {
        return this.getChannels().isEmpty() && this.getChannelGroups().isEmpty();
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.getChannels();
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return this.getChannelGroups();
    }

    @Override
    @NotNull
    protected Call<Envelope<JsonElement>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return !this.isGlobalHereNow() ? this.getRetrofitManager().getPresenceService$pubnub_kotlin_impl().hereNow(this.getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.getChannels()), (Map<String, String>)queryParams) : this.getRetrofitManager().getPresenceService$pubnub_kotlin_impl().globalHereNow(this.getConfiguration().getSubscribeKey(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNHereNowResult createResponse(@NotNull Response<Envelope<JsonElement>> input) {
        PNHereNowResult pNHereNowResult;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        if (this.isGlobalHereNow() || this.getChannels().size() > 1 || !((Collection)this.getChannelGroups()).isEmpty()) {
            Envelope envelope = (Envelope)input.body();
            Object object = envelope != null ? (JsonElement)envelope.getPayload$pubnub_kotlin_impl() : null;
            Intrinsics.checkNotNull((Object)object);
            pNHereNowResult = this.parseMultipleChannelResponse((JsonElement)object);
        } else {
            Object object = input.body();
            Intrinsics.checkNotNull((Object)object);
            pNHereNowResult = this.parseSingleChannelResponse((Envelope)object);
        }
        return pNHereNowResult;
    }

    @NotNull
    public PNOperationType.PNHereNowOperation operationType() {
        return PNOperationType.PNHereNowOperation.INSTANCE;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PRESENCE;
    }

    private final PNHereNowResult parseSingleChannelResponse(Envelope<JsonElement> input) {
        PNHereNowResult pnHereNowResult = new PNHereNowResult(1, input.getOccupancy$pubnub_kotlin_impl(), null, 4, null);
        PNHereNowChannelData pnHereNowChannelData = new PNHereNowChannelData(this.getChannels().get(0), input.getOccupancy$pubnub_kotlin_impl(), null, 4, null);
        if (this.getIncludeUUIDs()) {
            JsonElement jsonElement = input.getUuids$pubnub_kotlin_impl();
            Intrinsics.checkNotNull((Object)jsonElement);
            pnHereNowChannelData.setOccupants(this.prepareOccupantData(jsonElement));
            pnHereNowResult.getChannels().put(this.getChannels().get(0), pnHereNowChannelData);
        }
        return pnHereNowResult;
    }

    private final PNHereNowResult parseMultipleChannelResponse(JsonElement input) {
        PNHereNowResult pnHereNowResult = new PNHereNowResult(this.getPubnub().getMapper().elementToInt(input, "total_channels"), this.getPubnub().getMapper().elementToInt(input, "total_occupancy"), null, 4, null);
        Iterator<Map.Entry<String, JsonElement>> it = this.getPubnub().getMapper().getObjectIterator(input, "channels");
        while (it.hasNext()) {
            Map.Entry<String, JsonElement> entry = it.next();
            String string = entry.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-key>(...)");
            MapperManager mapperManager = this.getPubnub().getMapper();
            JsonElement jsonElement = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"<get-value>(...)");
            PNHereNowChannelData pnHereNowChannelData = new PNHereNowChannelData(string, mapperManager.elementToInt(jsonElement, "occupancy"), null, 4, null);
            if (this.getIncludeUUIDs()) {
                JsonElement jsonElement2 = this.getPubnub().getMapper().getField(entry.getValue(), "uuids");
                Intrinsics.checkNotNull((Object)jsonElement2);
                pnHereNowChannelData.setOccupants(this.prepareOccupantData(jsonElement2));
            }
            pnHereNowResult.getChannels().put(entry.getKey(), pnHereNowChannelData);
        }
        return pnHereNowResult;
    }

    private final List<PNHereNowOccupantData> prepareOccupantData(JsonElement input) {
        List occupantsResults = new ArrayList();
        Iterator<JsonElement> it = this.getPubnub().getMapper().getArrayIterator(input);
        while (true) {
            PNHereNowOccupantData pNHereNowOccupantData;
            Iterator<JsonElement> iterator = it;
            Boolean bl = iterator != null ? Boolean.valueOf(iterator.hasNext()) : null;
            Intrinsics.checkNotNull((Object)bl);
            if (!bl.booleanValue()) break;
            JsonElement occupant = it.next();
            if (this.getIncludeState()) {
                String string = this.getPubnub().getMapper().elementToString(occupant, "uuid");
                Intrinsics.checkNotNull((Object)string);
                pNHereNowOccupantData = new PNHereNowOccupantData(string, this.getPubnub().getMapper().getField(occupant, "state"));
            } else {
                String string = this.getPubnub().getMapper().elementToString(occupant);
                Intrinsics.checkNotNull((Object)string);
                pNHereNowOccupantData = new PNHereNowOccupantData(string, null, 2, null);
            }
            occupantsResults.add(pNHereNowOccupantData);
        }
        return occupantsResults;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        if (this.getIncludeState()) {
            queryParams.put("state", "1");
        }
        if (!this.getIncludeUUIDs()) {
            queryParams.put("disable_uuids", "1");
        }
        if (!((Collection)this.getChannelGroups()).isEmpty()) {
            queryParams.put("channel-group", PubNubUtilKt.toCsv(this.getChannelGroups()));
        }
    }
}

