/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.push;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.push.ListPushProvisions;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNPushEnvironment;
import com.pubnub.api.enums.PNPushType;
import com.pubnub.api.models.consumer.push.PNPushListProvisionsResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005B7\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0017\u001a\u00020\u0018H\u0014J8\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001a2\"\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001cj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u001dH\u0014J\u001c\u0010\u001e\u001a\u00020\u00042\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020 H\u0014J\b\u0010!\u001a\u00020\"H\u0016J\u001c\u0010#\u001a\u00020\u00182\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030$H\u0002J\b\u0010%\u001a\u00020&H\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Lcom/pubnub/internal/endpoints/push/ListPushProvisionsEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "", "", "Lcom/pubnub/api/models/consumer/push/PNPushListProvisionsResult;", "Lcom/pubnub/api/endpoints/push/ListPushProvisions;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "pushType", "Lcom/pubnub/api/enums/PNPushType;", "deviceId", "topic", "environment", "Lcom/pubnub/api/enums/PNPushEnvironment;", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Lcom/pubnub/api/enums/PNPushType;Ljava/lang/String;Ljava/lang/String;Lcom/pubnub/api/enums/PNPushEnvironment;)V", "getPushType", "()Lcom/pubnub/api/enums/PNPushType;", "getDeviceId", "()Ljava/lang/String;", "getTopic", "getEnvironment", "()Lcom/pubnub/api/enums/PNPushEnvironment;", "validateParams", "", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNPushNotificationEnabledChannelsOperation;", "addQueryParams", "", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nListPushProvisionsEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListPushProvisionsEndpoint.kt\ncom/pubnub/internal/endpoints/push/ListPushProvisionsEndpoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class ListPushProvisionsEndpoint
extends EndpointCore<List<? extends String>, PNPushListProvisionsResult>
implements ListPushProvisions {
    @NotNull
    private final PNPushType pushType;
    @NotNull
    private final String deviceId;
    @Nullable
    private final String topic;
    @NotNull
    private final PNPushEnvironment environment;

    public ListPushProvisionsEndpoint(@NotNull PubNubImpl pubnub, @NotNull PNPushType pushType, @NotNull String deviceId, @Nullable String topic, @NotNull PNPushEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)pushType, (String)"pushType");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super(pubnub);
        this.pushType = pushType;
        this.deviceId = deviceId;
        this.topic = topic;
        this.environment = environment;
    }

    public /* synthetic */ ListPushProvisionsEndpoint(PubNubImpl pubNubImpl, PNPushType pNPushType, String string, String string2, PNPushEnvironment pNPushEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            pNPushEnvironment = PNPushEnvironment.DEVELOPMENT;
        }
        this(pubNubImpl, pNPushType, string, string2, pNPushEnvironment);
    }

    @NotNull
    public PNPushType getPushType() {
        return this.pushType;
    }

    @NotNull
    public String getDeviceId() {
        return this.deviceId;
    }

    @Nullable
    public String getTopic() {
        return this.topic;
    }

    @NotNull
    public PNPushEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    protected void validateParams() {
        CharSequence charSequence;
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.getDeviceId())) {
            throw new PubNubException(PubNubError.DEVICE_ID_MISSING, null, 2, null);
        }
        if (this.getPushType() == PNPushType.APNS2 && ((charSequence = (CharSequence)this.getTopic()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            throw new PubNubException(PubNubError.PUSH_TOPIC_MISSING, null, 2, null);
        }
    }

    @Override
    @NotNull
    protected Call<List<String>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getPushType() != PNPushType.APNS2 ? this.getRetrofitManager().getPushService$pubnub_kotlin_impl().listChannelsForDevice(this.getConfiguration().getSubscribeKey(), this.getDeviceId(), (Map<String, String>)queryParams) : this.getRetrofitManager().getPushService$pubnub_kotlin_impl().listChannelsForDeviceApns2(this.getConfiguration().getSubscribeKey(), this.getDeviceId(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNPushListProvisionsResult createResponse(@NotNull Response<List<String>> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        return new PNPushListProvisionsResult((List)object);
    }

    @NotNull
    public PNOperationType.PNPushNotificationEnabledChannelsOperation operationType() {
        return PNOperationType.PNPushNotificationEnabledChannelsOperation.INSTANCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        block1: {
            if (this.getPushType() != PNPushType.APNS2) {
                queryParams.put("type", this.getPushType().toParamString());
                return;
            }
            Map<String, String> map = queryParams;
            String string = "environment";
            String string2 = this.getEnvironment().name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            string2 = string3;
            map.put(string, string2);
            String string4 = this.getTopic();
            if (string4 == null) break block1;
            String $this$addQueryParams_u24lambda_u240 = string4;
            boolean bl = false;
            queryParams.put("topic", $this$addQueryParams_u24lambda_u240);
        }
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PUSH_NOTIFICATION;
    }
}

