/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.managers;

import com.pubnub.api.PubNub;
import com.pubnub.api.callbacks.Listener;
import com.pubnub.api.callbacks.SubscribeCallback;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.pubsub.PNEvent;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.files.PNFileEventResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNObjectEventResult;
import com.pubnub.api.v2.callbacks.EventEmitter;
import com.pubnub.api.v2.callbacks.EventListener;
import com.pubnub.api.v2.callbacks.StatusEmitter;
import com.pubnub.api.v2.callbacks.StatusListener;
import com.pubnub.internal.managers.AnnouncementCallback;
import com.pubnub.internal.managers.AnnouncementEnvelope;
import com.pubnub.internal.subscribe.eventengine.effect.MessagesConsumer;
import com.pubnub.internal.subscribe.eventengine.effect.StatusConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020%J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0010H\u0016J\u0015\u0010&\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020 H\u0000\u00a2\u0006\u0002\b'J\u0015\u0010(\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020 H\u0000\u00a2\u0006\u0002\b)J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u0010*\u001a\u00020\u001b2\u0006\u00101\u001a\u000202H\u0016J\u0010\u0010*\u001a\u00020\u001b2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010*\u001a\u00020\u001b2\u0006\u00105\u001a\u000206H\u0016J\u0010\u0010*\u001a\u00020\u001b2\u0006\u00107\u001a\u000208H\u0016J-\u00109\u001a\u00020\u001b\"\u0004\b\u0000\u0010:*\b\u0012\u0004\u0012\u0002H:0;2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u0002H:\u0012\u0004\u0012\u00020\u001b0=H\u0082\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0018\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010!\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010 0 0\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0012R\"\u0010#\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010 0 0\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0012\u00a8\u0006>"}, d2={"Lcom/pubnub/internal/managers/ListenerManager;", "Lcom/pubnub/internal/subscribe/eventengine/effect/MessagesConsumer;", "Lcom/pubnub/internal/subscribe/eventengine/effect/StatusConsumer;", "Lcom/pubnub/api/v2/callbacks/EventEmitter;", "Lcom/pubnub/api/v2/callbacks/StatusEmitter;", "pubnub", "Lcom/pubnub/api/PubNub;", "<init>", "(Lcom/pubnub/api/PubNub;)V", "getPubnub", "()Lcom/pubnub/api/PubNub;", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/pubnub/api/callbacks/Listener;", "statusListeners", "", "Lcom/pubnub/api/v2/callbacks/StatusListener;", "getStatusListeners", "()Ljava/util/List;", "eventListeners", "Lcom/pubnub/api/v2/callbacks/EventListener;", "getEventListeners", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "addListener", "", "listener", "removeListener", "removeAllListeners", "announcementCallbacks", "Lcom/pubnub/internal/managers/AnnouncementCallback;", "subscriptionCallbacks", "getSubscriptionCallbacks", "setCallbacks", "getSetCallbacks", "Lcom/pubnub/api/callbacks/SubscribeCallback;", "addAnnouncementCallback", "addAnnouncementCallback$pubnub_kotlin_impl", "removeAnnouncementCallback", "removeAnnouncementCallback$pubnub_kotlin_impl", "announce", "status", "Lcom/pubnub/api/models/consumer/PNStatus;", "message", "Lcom/pubnub/api/models/consumer/pubsub/PNMessageResult;", "presence", "Lcom/pubnub/api/models/consumer/pubsub/PNPresenceEventResult;", "signal", "Lcom/pubnub/api/models/consumer/pubsub/PNSignalResult;", "messageAction", "Lcom/pubnub/api/models/consumer/pubsub/message_actions/PNMessageActionResult;", "pnObjectEventResult", "Lcom/pubnub/api/models/consumer/pubsub/objects/PNObjectEventResult;", "pnFileEventResult", "Lcom/pubnub/api/models/consumer/pubsub/files/PNFileEventResult;", "safeForEach", "T", "", "action", "Lkotlin/Function1;", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nListenerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListenerManager.kt\ncom/pubnub/internal/managers/ListenerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n117#1,8:197\n117#1,8:205\n117#1,8:213\n117#1,8:221\n117#1,8:229\n117#1,8:237\n117#1,8:245\n117#1,8:253\n117#1,8:261\n117#1,8:269\n117#1,8:277\n117#1,8:285\n117#1,8:293\n117#1,8:301\n117#1,8:309\n117#1,8:317\n117#1,8:325\n117#1,8:333\n117#1,8:341\n808#2,11:169\n808#2,11:180\n774#2:191\n865#2,2:192\n774#2:194\n865#2,2:195\n*S KotlinDebug\n*F\n+ 1 ListenerManager.kt\ncom/pubnub/internal/managers/ListenerManager\n*L\n71#1:197,8\n75#1:205,8\n77#1:213,8\n78#1:221,8\n82#1:229,8\n84#1:237,8\n85#1:245,8\n89#1:253,8\n91#1:261,8\n92#1:269,8\n96#1:277,8\n98#1:285,8\n99#1:293,8\n103#1:301,8\n105#1:309,8\n106#1:317,8\n110#1:325,8\n112#1:333,8\n113#1:341,8\n27#1:169,11\n28#1:180,11\n51#1:191\n51#1:192,2\n52#1:194\n52#1:195,2\n*E\n"})
public final class ListenerManager
implements MessagesConsumer,
StatusConsumer,
EventEmitter,
StatusEmitter {
    @NotNull
    private final PubNub pubnub;
    @NotNull
    private final CopyOnWriteArrayList<Listener> listeners;
    private final Logger log;
    @NotNull
    private final CopyOnWriteArrayList<AnnouncementCallback> announcementCallbacks;

    public ListenerManager(@NotNull PubNub pubnub) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        this.pubnub = pubnub;
        this.listeners = new CopyOnWriteArrayList();
        this.log = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
        this.announcementCallbacks = new CopyOnWriteArrayList();
    }

    @NotNull
    public final PubNub getPubnub() {
        return this.pubnub;
    }

    /*
     * WARNING - void declaration
     */
    private final List<StatusListener> getStatusListeners() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.listeners;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof StatusListener)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EventListener> getEventListeners() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.listeners;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof EventListener)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void addListener(@NotNull EventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add((Listener)listener);
    }

    public void removeListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final List<AnnouncementCallback> getSubscriptionCallbacks() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.announcementCallbacks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AnnouncementCallback it = (AnnouncementCallback)element$iv$iv;
            boolean bl = false;
            if (!(it.getPhase() == AnnouncementCallback.Phase.SUBSCRIPTION)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AnnouncementCallback> getSetCallbacks() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.announcementCallbacks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AnnouncementCallback it = (AnnouncementCallback)element$iv$iv;
            boolean bl = false;
            if (!(it.getPhase() == AnnouncementCallback.Phase.SET)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void addListener(@NotNull SubscribeCallback listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add((Listener)listener);
    }

    public void addListener(@NotNull StatusListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add((Listener)listener);
    }

    public final void addAnnouncementCallback$pubnub_kotlin_impl(@NotNull AnnouncementCallback listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.announcementCallbacks.add(listener);
    }

    public final void removeAnnouncementCallback$pubnub_kotlin_impl(@NotNull AnnouncementCallback listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.announcementCallbacks.remove(listener);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void announce(@NotNull PNStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        ListenerManager listenerManager = this;
        Iterable $this$safeForEach$iv = this.getStatusListeners();
        boolean $i$f$safeForEach = false;
        for (Object element$iv : $this$safeForEach$iv) {
            try {
                StatusListener it = (StatusListener)element$iv;
                boolean bl = false;
                it.status(this.pubnub, status);
            }
            catch (Throwable e$iv) {
                void this_$iv;
                this_$iv.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void announce(@NotNull PNMessageResult message) {
        ListenerManager this_$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ListenerManager listenerManager = this;
        Object $this$safeForEach$iv = this.getEventListeners();
        boolean $i$f$safeForEach = false;
        Iterator iterator = $this$safeForEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            try {
                EventListener it = (EventListener)element$iv;
                boolean bl = false;
                it.message(this.pubnub, message);
            }
            catch (Throwable e$iv) {
                void this_$iv2;
                this_$iv2.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
        AnnouncementEnvelope<PNEvent> envelope = new AnnouncementEnvelope<PNEvent>((PNEvent)message);
        $this$safeForEach$iv = this;
        Iterable $this$safeForEach$iv2 = this.getSubscriptionCallbacks();
        boolean $i$f$safeForEach2 = false;
        for (Object element$iv : $this$safeForEach$iv2) {
            try {
                AnnouncementCallback it = (AnnouncementCallback)element$iv;
                boolean bl = false;
                it.message(this.pubnub, envelope);
            }
            catch (Throwable e$iv) {
                this_$iv.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
        this_$iv = this;
        $this$safeForEach$iv2 = this.getSetCallbacks();
        $i$f$safeForEach2 = false;
        for (Object element$iv : $this$safeForEach$iv2) {
            try {
                AnnouncementCallback it = (AnnouncementCallback)element$iv;
                boolean bl = false;
                it.message(this.pubnub, envelope);
            }
            catch (Throwable e$iv) {
                this_$iv.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void announce(@NotNull PNPresenceEventResult presence) {
        ListenerManager this_$iv;
        Intrinsics.checkNotNullParameter((Object)presence, (String)"presence");
        ListenerManager listenerManager = this;
        Object $this$safeForEach$iv = this.getEventListeners();
        boolean $i$f$safeForEach = false;
        Iterator iterator = $this$safeForEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            try {
                EventListener it = (EventListener)element$iv;
                boolean bl = false;
                it.presence(this.pubnub, presence);
            }
            catch (Throwable e$iv) {
                void this_$iv2;
                this_$iv2.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
        AnnouncementEnvelope<PNEvent> envelope = new AnnouncementEnvelope<PNEvent>((PNEvent)presence);
        $this$safeForEach$iv = this;
        Iterable $this$safeForEach$iv2 = this.getSubscriptionCallbacks();
        boolean $i$f$safeForEach2 = false;
        for (Object element$iv : $this$safeForEach$iv2) {
            try {
                AnnouncementCallback it = (AnnouncementCallback)element$iv;
                boolean bl = false;
                it.presence(this.pubnub, envelope);
            }
            catch (Throwable e$iv) {
                this_$iv.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
        this_$iv = this;
        $this$safeForEach$iv2 = this.getSetCallbacks();
        $i$f$safeForEach2 = false;
        for (Object element$iv : $this$safeForEach$iv2) {
            try {
                AnnouncementCallback it = (AnnouncementCallback)element$iv;
                boolean bl = false;
                it.presence(this.pubnub, envelope);
            }
            catch (Throwable e$iv) {
                this_$iv.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void announce(@NotNull PNSignalResult signal) {
        ListenerManager this_$iv;
        Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
        ListenerManager listenerManager = this;
        Object $this$safeForEach$iv = this.getEventListeners();
        boolean $i$f$safeForEach = false;
        Iterator iterator = $this$safeForEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            try {
                EventListener it = (EventListener)element$iv;
                boolean bl = false;
                it.signal(this.pubnub, signal);
            }
            catch (Throwable e$iv) {
                void this_$iv2;
                this_$iv2.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
        AnnouncementEnvelope<PNEvent> envelope = new AnnouncementEnvelope<PNEvent>((PNEvent)signal);
        $this$safeForEach$iv = this;
        Iterable $this$safeForEach$iv2 = this.getSubscriptionCallbacks();
        boolean $i$f$safeForEach2 = false;
        for (Object element$iv : $this$safeForEach$iv2) {
            try {
                AnnouncementCallback it = (AnnouncementCallback)element$iv;
                boolean bl = false;
                it.signal(this.pubnub, envelope);
            }
            catch (Throwable e$iv) {
                this_$iv.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
        this_$iv = this;
        $this$safeForEach$iv2 = this.getSetCallbacks();
        $i$f$safeForEach2 = false;
        for (Object element$iv : $this$safeForEach$iv2) {
            try {
                AnnouncementCallback it = (AnnouncementCallback)element$iv;
                boolean bl = false;
                it.signal(this.pubnub, envelope);
            }
            catch (Throwable e$iv) {
                this_$iv.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void announce(@NotNull PNMessageActionResult messageAction) {
        ListenerManager this_$iv;
        Intrinsics.checkNotNullParameter((Object)messageAction, (String)"messageAction");
        ListenerManager listenerManager = this;
        Object $this$safeForEach$iv = this.getEventListeners();
        boolean $i$f$safeForEach = false;
        Iterator iterator = $this$safeForEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            try {
                EventListener it = (EventListener)element$iv;
                boolean bl = false;
                it.messageAction(this.pubnub, messageAction);
            }
            catch (Throwable e$iv) {
                void this_$iv2;
                this_$iv2.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
        AnnouncementEnvelope<PNEvent> envelope = new AnnouncementEnvelope<PNEvent>((PNEvent)messageAction);
        $this$safeForEach$iv = this;
        Iterable $this$safeForEach$iv2 = this.getSubscriptionCallbacks();
        boolean $i$f$safeForEach2 = false;
        for (Object element$iv : $this$safeForEach$iv2) {
            try {
                AnnouncementCallback it = (AnnouncementCallback)element$iv;
                boolean bl = false;
                it.messageAction(this.pubnub, envelope);
            }
            catch (Throwable e$iv) {
                this_$iv.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
        this_$iv = this;
        $this$safeForEach$iv2 = this.getSetCallbacks();
        $i$f$safeForEach2 = false;
        for (Object element$iv : $this$safeForEach$iv2) {
            try {
                AnnouncementCallback it = (AnnouncementCallback)element$iv;
                boolean bl = false;
                it.messageAction(this.pubnub, envelope);
            }
            catch (Throwable e$iv) {
                this_$iv.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void announce(@NotNull PNObjectEventResult pnObjectEventResult) {
        ListenerManager this_$iv;
        Intrinsics.checkNotNullParameter((Object)pnObjectEventResult, (String)"pnObjectEventResult");
        ListenerManager listenerManager = this;
        Object $this$safeForEach$iv = this.getEventListeners();
        boolean $i$f$safeForEach = false;
        Iterator iterator = $this$safeForEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            try {
                EventListener it = (EventListener)element$iv;
                boolean bl = false;
                it.objects(this.pubnub, pnObjectEventResult);
            }
            catch (Throwable e$iv) {
                void this_$iv2;
                this_$iv2.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
        AnnouncementEnvelope<PNEvent> envelope = new AnnouncementEnvelope<PNEvent>((PNEvent)pnObjectEventResult);
        $this$safeForEach$iv = this;
        Iterable $this$safeForEach$iv2 = this.getSubscriptionCallbacks();
        boolean $i$f$safeForEach2 = false;
        for (Object element$iv : $this$safeForEach$iv2) {
            try {
                AnnouncementCallback it = (AnnouncementCallback)element$iv;
                boolean bl = false;
                it.objects(this.pubnub, envelope);
            }
            catch (Throwable e$iv) {
                this_$iv.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
        this_$iv = this;
        $this$safeForEach$iv2 = this.getSetCallbacks();
        $i$f$safeForEach2 = false;
        for (Object element$iv : $this$safeForEach$iv2) {
            try {
                AnnouncementCallback it = (AnnouncementCallback)element$iv;
                boolean bl = false;
                it.objects(this.pubnub, envelope);
            }
            catch (Throwable e$iv) {
                this_$iv.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void announce(@NotNull PNFileEventResult pnFileEventResult) {
        ListenerManager this_$iv;
        Intrinsics.checkNotNullParameter((Object)pnFileEventResult, (String)"pnFileEventResult");
        ListenerManager listenerManager = this;
        Object $this$safeForEach$iv = this.getEventListeners();
        boolean $i$f$safeForEach = false;
        Iterator iterator = $this$safeForEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            try {
                EventListener it = (EventListener)element$iv;
                boolean bl = false;
                it.file(this.pubnub, pnFileEventResult);
            }
            catch (Throwable e$iv) {
                void this_$iv2;
                this_$iv2.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
        AnnouncementEnvelope<PNEvent> envelope = new AnnouncementEnvelope<PNEvent>((PNEvent)pnFileEventResult);
        $this$safeForEach$iv = this;
        Iterable $this$safeForEach$iv2 = this.getSubscriptionCallbacks();
        boolean $i$f$safeForEach2 = false;
        for (Object element$iv : $this$safeForEach$iv2) {
            try {
                AnnouncementCallback it = (AnnouncementCallback)element$iv;
                boolean bl = false;
                it.file(this.pubnub, envelope);
            }
            catch (Throwable e$iv) {
                this_$iv.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
        this_$iv = this;
        $this$safeForEach$iv2 = this.getSetCallbacks();
        $i$f$safeForEach2 = false;
        for (Object element$iv : $this$safeForEach$iv2) {
            try {
                AnnouncementCallback it = (AnnouncementCallback)element$iv;
                boolean bl = false;
                it.file(this.pubnub, envelope);
            }
            catch (Throwable e$iv) {
                this_$iv.log.warn("Uncaught exception in listener.", e$iv);
            }
        }
    }

    private final <T> void safeForEach(Iterable<? extends T> $this$safeForEach, Function1<? super T, Unit> action) {
        boolean $i$f$safeForEach = false;
        for (T element : $this$safeForEach) {
            try {
                action.invoke(element);
            }
            catch (Throwable e) {
                this.log.warn("Uncaught exception in listener.", e);
            }
        }
    }
}

