/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.managers;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.models.consumer.access_manager.v3.PNToken;
import com.pubnub.internal.vendor.Base64;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\t*\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000e*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/pubnub/internal/managers/TokenParser;", "", "<init>", "()V", "unwrapToken", "Lcom/pubnub/api/models/consumer/access_manager/v3/PNToken;", "token", "", "toJvmMap", "", "Lco/nstant/in/cbor/model/Map;", "depth", "", "toMapOfStringToInt", "", "toPNTokenResources", "Lcom/pubnub/api/models/consumer/access_manager/v3/PNToken$PNTokenResources;", "Companion", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nTokenParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenParser.kt\ncom/pubnub/internal/managers/TokenParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,134:1\n1557#2:135\n1628#2,3:136\n1246#2,4:155\n1246#2,4:161\n1246#2,4:167\n136#3,9:139\n216#3:148\n217#3:151\n145#3:152\n1#4:149\n1#4:150\n462#5:153\n412#5:154\n462#5:159\n412#5:160\n462#5:165\n412#5:166\n*S KotlinDebug\n*F\n+ 1 TokenParser.kt\ncom/pubnub/internal/managers/TokenParser\n*L\n91#1:135\n91#1:136,3\n115#1:155,4\n116#1:161,4\n117#1:167,4\n101#1:139,9\n101#1:148\n101#1:151\n101#1:152\n101#1:150\n115#1:153\n115#1:154\n116#1:159\n116#1:160\n117#1:165\n117#1:166\n*E\n"})
public final class TokenParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String VERSION_KEY = "v";
    @NotNull
    private static final String TIMESTAMP_KEY = "t";
    @NotNull
    private static final String TTL_KEY = "ttl";
    @NotNull
    private static final String AUTHORIZED_UUID_KEY = "uuid";
    @NotNull
    private static final String RESOURCES_KEY = "res";
    @NotNull
    private static final String PATTERNS_KEY = "pat";
    @NotNull
    private static final String META_KEY = "meta";
    @NotNull
    private static final String CHANNELS_KEY = "chan";
    @NotNull
    private static final String GROUPS_KEY = "grp";
    @NotNull
    private static final String UUIDS_KEY = "uuid";

    @NotNull
    public final PNToken unwrapToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        String string = token;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byteArray = Base64.decode(byArray, 8);
        Intrinsics.checkNotNull((Object)byteArray);
        List list = new CborDecoder((InputStream)new ByteArrayInputStream(byteArray)).decode();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"decode(...)");
        DataItem dataItem = (DataItem)CollectionsKt.firstOrNull((List)list);
        if (dataItem == null) {
            PubNubError pubNubError = PubNubError.INVALID_ACCESS_TOKEN;
            throw new PubNubException("Empty token", pubNubError, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        DataItem firstElement = dataItem;
        Object object = firstElement instanceof Map ? (Map)firstElement : null;
        if (object == null || (object = TokenParser.toJvmMap$default(this, (Map)object, 0, 1, null)) == null) {
            PubNubError pubNubError = PubNubError.INVALID_ACCESS_TOKEN;
            throw new PubNubException("First element is not a map", pubNubError, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        Object firstLevelMap = object;
        Object v = firstLevelMap.get(VERSION_KEY);
        if (v == null || (v = v.toString()) == null) {
            PubNubError pubNubError = PubNubError.INVALID_ACCESS_TOKEN;
            throw new PubNubException("Couldn't parse version", pubNubError, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        int version = Integer.parseInt(v);
        Object v2 = firstLevelMap.get(TIMESTAMP_KEY);
        if (v2 == null || (v2 = v2.toString()) == null) {
            PubNubError pubNubError = PubNubError.INVALID_ACCESS_TOKEN;
            throw new PubNubException("Couldn't parse timestamp", pubNubError, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        long timestamp = Long.parseLong(v2);
        Object v3 = firstLevelMap.get(TTL_KEY);
        if (v3 == null || (v3 = v3.toString()) == null) {
            PubNubError pubNubError = PubNubError.INVALID_ACCESS_TOKEN;
            throw new PubNubException("Couldn't parse ttl", pubNubError, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        long ttl = Long.parseLong(v3);
        Object object2 = firstLevelMap.get(RESOURCES_KEY);
        java.util.Map map = object2 instanceof java.util.Map ? (java.util.Map)object2 : null;
        if (map == null) {
            object2 = PubNubError.INVALID_ACCESS_TOKEN;
            throw new PubNubException("Resources are not present or are not map", object2, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        java.util.Map resourcesValue = map;
        Object object3 = firstLevelMap.get(PATTERNS_KEY);
        java.util.Map map2 = object3 instanceof java.util.Map ? (java.util.Map)object3 : null;
        if (map2 == null) {
            object3 = PubNubError.INVALID_ACCESS_TOKEN;
            throw new PubNubException("Patterns are not present or are not map", object3, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        java.util.Map patternsValue = map2;
        try {
            Object v4 = firstLevelMap.get("uuid");
            object2 = new PNToken(version, timestamp, ttl, v4 != null ? v4.toString() : null, this.toPNTokenResources(resourcesValue), this.toPNTokenResources(patternsValue), firstLevelMap.get(META_KEY));
        }
        catch (Exception e) {
            if (e instanceof PubNubException) {
                throw e;
            }
            PubNubError pubNubError = PubNubError.INVALID_ACCESS_TOKEN;
            String string2 = "Couldn't parse token: " + e.getMessage();
            throw new PubNubException(string2, pubNubError, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    private final java.util.Map<String, Object> toJvmMap(Map $this$toJvmMap, int depth) {
        if (depth > 3) {
            PubNubError pubNubError = PubNubError.INVALID_ACCESS_TOKEN;
            throw new PubNubException("Token is too deep", pubNubError, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        java.util.Map result = new LinkedHashMap();
        for (DataItem key : $this$toJvmMap.getKeys()) {
            String string;
            List list;
            Object object;
            DataItem value = $this$toJvmMap.get(key);
            if (key instanceof ByteString) {
                Intrinsics.checkNotNullExpressionValue((Object)((ByteString)key).getBytes(), (String)"getBytes(...)");
                Intrinsics.checkNotNullExpressionValue((Object)StandardCharsets.UTF_8, (String)"UTF_8");
                string = new String((byte[])object, (Charset)((Object)list));
            } else {
                string = key.toString();
            }
            String keyString = string;
            DataItem dataItem = value;
            if (dataItem instanceof Map) {
                result.put(keyString, this.toJvmMap((Map)value, depth + 1));
                continue;
            }
            if (dataItem instanceof ByteString) {
                result.put(keyString, ((ByteString)value).getBytes());
                continue;
            }
            if (dataItem instanceof List) {
                void $this$mapTo$iv$iv;
                object = result;
                Iterable $this$map$iv = (Iterable)value;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(String.valueOf(it));
                }
                list = (List)destination$iv$iv;
                object.put(keyString, list);
                continue;
            }
            if (dataItem instanceof UnsignedInteger) {
                result.put(keyString, ((UnsignedInteger)value).getValue());
                continue;
            }
            if (dataItem instanceof NegativeInteger) {
                result.put(keyString, ((NegativeInteger)value).getValue());
                continue;
            }
            result.put(keyString, value.toString());
        }
        return result;
    }

    static /* synthetic */ java.util.Map toJvmMap$default(TokenParser tokenParser, Map map, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return tokenParser.toJvmMap(map, n);
    }

    /*
     * WARNING - void declaration
     */
    private final java.util.Map<String, Integer> toMapOfStringToInt(java.util.Map<?, ?> $this$toMapOfStringToInt) {
        void $this$mapNotNullTo$iv$iv;
        java.util.Map<?, ?> $this$mapNotNull$iv = $this$toMapOfStringToInt;
        boolean $i$f$mapNotNull = false;
        java.util.Map<?, ?> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (v instanceof BigInteger) {
                pair = TuplesKt.to((Object)String.valueOf(k), (Object)((BigInteger)v).intValue());
            } else {
                Integer n = StringsKt.toIntOrNull((String)String.valueOf(v));
                if (n != null) {
                    int it = ((Number)n).intValue();
                    boolean bl3 = false;
                    pair = TuplesKt.to((Object)String.valueOf(k), (Object)it);
                } else {
                    pair = null;
                }
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final PNToken.PNTokenResources toPNTokenResources(java.util.Map<?, ?> $this$toPNTokenResources) {
        Object object;
        Object object2;
        int v;
        java.util.Map map;
        Object object3;
        Map.Entry it$iv$iv;
        Map.Entry entry;
        boolean bl;
        java.util.Map map2;
        java.util.Map<String, Integer> $this$mapValuesTo$iv$iv;
        Object obj;
        java.util.Map<String, Integer> map3;
        java.util.Map<String, Integer> groups;
        Object obj2;
        java.util.Map<String, Integer> map4;
        java.util.Map<String, Integer> channels;
        Object obj3 = $this$toPNTokenResources.get(CHANNELS_KEY);
        java.util.Map<String, Integer> map5 = obj3 instanceof java.util.Map ? (java.util.Map<String, Integer>)obj3 : null;
        if (map5 == null || (map5 = this.toMapOfStringToInt(map5)) == null) {
            map5 = channels = MapsKt.emptyMap();
        }
        if ((map4 = (obj2 = $this$toPNTokenResources.get(GROUPS_KEY)) instanceof java.util.Map ? (java.util.Map<String, Integer>)obj2 : null) == null || (map4 = this.toMapOfStringToInt(map4)) == null) {
            map4 = groups = MapsKt.emptyMap();
        }
        if ((map3 = (obj = $this$toPNTokenResources.get("uuid")) instanceof java.util.Map ? (java.util.Map<String, Integer>)obj : null) == null || (map3 = this.toMapOfStringToInt(map3)) == null) {
            map3 = MapsKt.emptyMap();
        }
        java.util.Map<String, Integer> uuids = map3;
        java.util.Map<String, Integer> $this$mapValues$iv = channels;
        boolean $i$f$mapValues = false;
        java.util.Map<String, Integer> map6 = $this$mapValues$iv;
        java.util.Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            bl = false;
            entry = (Map.Entry)element$iv$iv$iv;
            object3 = it$iv$iv.getKey();
            map = map2;
            boolean bl2 = false;
            v = ((Number)entry.getValue()).intValue();
            object2 = new PNToken.PNResourcePermissions(v);
            map.put(object3, object2);
        }
        $this$mapValues$iv = groups;
        map = destination$iv$iv;
        $i$f$mapValues = false;
        $this$mapValuesTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            bl = false;
            entry = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv.getKey();
            object3 = map2;
            boolean bl3 = false;
            v = ((Number)entry.getValue()).intValue();
            object = new PNToken.PNResourcePermissions(v);
            object3.put((PNToken.PNResourcePermissions)object2, (PNToken.PNResourcePermissions)object);
        }
        $this$mapValues$iv = uuids;
        object3 = destination$iv$iv;
        $i$f$mapValues = false;
        $this$mapValuesTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            bl = false;
            entry = (Map.Entry)element$iv$iv$iv;
            object = it$iv$iv.getKey();
            object2 = map2;
            boolean bl4 = false;
            v = ((Number)entry.getValue()).intValue();
            PNToken.PNResourcePermissions pNResourcePermissions = new PNToken.PNResourcePermissions(v);
            object2.put(object, pNResourcePermissions);
        }
        object2 = destination$iv$iv;
        Object object4 = object2;
        Object object5 = object3;
        java.util.Map map7 = map;
        return new PNToken.PNTokenResources(map7, (java.util.Map)object5, (java.util.Map)object4);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/pubnub/internal/managers/TokenParser$Companion;", "", "<init>", "()V", "VERSION_KEY", "", "TIMESTAMP_KEY", "TTL_KEY", "AUTHORIZED_UUID_KEY", "RESOURCES_KEY", "PATTERNS_KEY", "META_KEY", "CHANNELS_KEY", "GROUPS_KEY", "UUIDS_KEY", "pubnub-kotlin-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

