/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.retry;

import com.pubnub.api.retry.RetryConfiguration;
import com.pubnub.api.retry.RetryableEndpointGroup;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import retrofit2.Response;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010 \n\u0002\b\u0002\b \u0018\u0000 3*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u00013B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b \u0010!J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u001f\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001bH\u0004\u00a2\u0006\u0004\b)\u0010\u001eJ\u001d\u0010*\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0002\u00a2\u0006\u0004\b+\u0010\u0018J\u0019\u0010,\u001a\u00020\u00142\b\u0010-\u001a\u0004\u0018\u00010\u001bH\u0002\u00a2\u0006\u0004\b.\u0010/J\u0016\u00100\u001a\u00020\u00102\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000602H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\"\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00064"}, d2={"Lcom/pubnub/internal/retry/RetryableBase;", "T", "", "retryConfiguration", "Lcom/pubnub/api/retry/RetryConfiguration;", "endpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "<init>", "(Lcom/pubnub/api/retry/RetryConfiguration;Lcom/pubnub/api/retry/RetryableEndpointGroup;)V", "exponentialMultiplier", "", "random", "Lkotlin/random/Random$Default;", "getRandom", "()Lkotlin/random/Random$Default;", "isRetryConfSetForThisRestCall", "", "isRetryConfSetForThisRestCall$pubnub_kotlin_impl", "()Z", "getDelayBasedOnResponse", "Lkotlin/time/Duration;", "response", "Lretrofit2/Response;", "getDelayBasedOnResponse-5sfh64U$pubnub_kotlin_impl", "(Lretrofit2/Response;)J", "getDelayBasedOnErrorCode", "errorCode", "", "retryAfterHeaderValueInSec", "getDelayBasedOnErrorCode-3nIYWDw", "(II)J", "getDelayFromRetryConfiguration", "getDelayFromRetryConfiguration-UwyO8pc$pubnub_kotlin_impl", "()J", "maxRetryNumberFromConfiguration", "getMaxRetryNumberFromConfiguration", "()I", "isErrorCodeRetryable", "getEffectiveDelay", "statusCode", "retryAfterHeaderValue", "getEffectiveDelay-3nIYWDw", "calculateDelayForTooManyRequestError", "calculateDelayForTooManyRequestError-5sfh64U", "getDelayForRetryAfterHeaderValue", "delayInSeconds", "getDelayForRetryAfterHeaderValue-5sfh64U", "(Ljava/lang/Integer;)J", "endpointIsNotExcludedFromRetryConfiguration", "excludedOperations", "", "Companion", "pubnub-kotlin-impl"})
public abstract class RetryableBase<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RetryConfiguration retryConfiguration;
    @NotNull
    private final RetryableEndpointGroup endpointGroupName;
    private double exponentialMultiplier;
    @NotNull
    private final Random.Default random;
    private final boolean isRetryConfSetForThisRestCall;
    private final int maxRetryNumberFromConfiguration;
    public static final int MAX_RANDOM_DELAY_IN_MILLIS = 1000;
    private static final int TOO_MANY_REQUESTS = 429;
    public static final int SERVICE_UNAVAILABLE = 503;
    @NotNull
    public static final String RETRY_AFTER_HEADER_NAME = "Retry-After";
    @NotNull
    private static final Map<Integer, String> retryableStatusCodes;
    @NotNull
    private static final List<Class<? extends IOException>> retryableExceptions;

    public RetryableBase(@NotNull RetryConfiguration retryConfiguration, @NotNull RetryableEndpointGroup endpointGroupName) {
        int n;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)retryConfiguration, (String)"retryConfiguration");
        Intrinsics.checkNotNullParameter((Object)endpointGroupName, (String)"endpointGroupName");
        this.retryConfiguration = retryConfiguration;
        this.endpointGroupName = endpointGroupName;
        this.random = Random.Default;
        RetryConfiguration retryConfiguration2 = this.retryConfiguration;
        if (retryConfiguration2 instanceof RetryConfiguration.None) {
            bl = false;
        } else if (retryConfiguration2 instanceof RetryConfiguration.Linear) {
            List excludedOperations = ((RetryConfiguration.Linear)this.retryConfiguration).getExcludedOperations();
            bl = this.endpointIsNotExcludedFromRetryConfiguration(excludedOperations);
        } else if (retryConfiguration2 instanceof RetryConfiguration.Exponential) {
            List excludedOperations = ((RetryConfiguration.Exponential)this.retryConfiguration).getExcludedOperations();
            bl = this.endpointIsNotExcludedFromRetryConfiguration(excludedOperations);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.isRetryConfSetForThisRestCall = bl;
        retryConfiguration2 = this.retryConfiguration;
        if (retryConfiguration2 instanceof RetryConfiguration.None) {
            n = 0;
        } else if (retryConfiguration2 instanceof RetryConfiguration.Linear) {
            n = ((RetryConfiguration.Linear)this.retryConfiguration).getMaxRetryNumber();
        } else if (retryConfiguration2 instanceof RetryConfiguration.Exponential) {
            n = ((RetryConfiguration.Exponential)this.retryConfiguration).getMaxRetryNumber();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.maxRetryNumberFromConfiguration = n;
    }

    @NotNull
    protected final Random.Default getRandom() {
        return this.random;
    }

    public final boolean isRetryConfSetForThisRestCall$pubnub_kotlin_impl() {
        return this.isRetryConfSetForThisRestCall;
    }

    public final long getDelayBasedOnResponse-5sfh64U$pubnub_kotlin_impl(@NotNull Response<T> response) {
        Intrinsics.checkNotNullParameter(response, (String)"response");
        long effectiveDelay = response.raw().code() == 429 ? this.calculateDelayForTooManyRequestError-5sfh64U(response) : this.getDelayFromRetryConfiguration-UwyO8pc$pubnub_kotlin_impl();
        return effectiveDelay;
    }

    private final long getDelayBasedOnErrorCode-3nIYWDw(int errorCode, int retryAfterHeaderValueInSec) {
        return errorCode == 429 ? this.getDelayForRetryAfterHeaderValue-5sfh64U(retryAfterHeaderValueInSec) : this.getDelayFromRetryConfiguration-UwyO8pc$pubnub_kotlin_impl();
    }

    public final long getDelayFromRetryConfiguration-UwyO8pc$pubnub_kotlin_impl() {
        long l;
        RetryConfiguration retryConfiguration = this.retryConfiguration;
        if (retryConfiguration instanceof RetryConfiguration.None) {
            l = DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.SECONDS);
        } else if (retryConfiguration instanceof RetryConfiguration.Linear) {
            l = ((RetryConfiguration.Linear)this.retryConfiguration).getDelayInSec-UwyO8pc();
        } else if (retryConfiguration instanceof RetryConfiguration.Exponential) {
            long delay = Duration.times-UwyO8pc((long)((RetryConfiguration.Exponential)this.retryConfiguration).getMinDelayInSec-UwyO8pc(), (double)Math.pow(2.0, this.exponentialMultiplier));
            double d = this.exponentialMultiplier;
            this.exponentialMultiplier = d + 1.0;
            l = ((Duration)ComparisonsKt.minOf((Comparable)Duration.box-impl((long)delay), (Comparable)Duration.box-impl((long)((RetryConfiguration.Exponential)this.retryConfiguration).getMaxDelayInSec-UwyO8pc()))).unbox-impl();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return l;
    }

    protected final int getMaxRetryNumberFromConfiguration() {
        return this.maxRetryNumberFromConfiguration;
    }

    protected final boolean isErrorCodeRetryable(int errorCode) {
        return retryableStatusCodes.containsKey(errorCode);
    }

    protected final long getEffectiveDelay-3nIYWDw(int statusCode, int retryAfterHeaderValue) {
        long delayBasedOnStatusCode = this.getDelayBasedOnErrorCode-3nIYWDw(statusCode, retryAfterHeaderValue);
        long randomDelayInMillis = DurationKt.toDuration((int)this.random.nextInt(1000), (DurationUnit)DurationUnit.MILLISECONDS);
        return Duration.plus-LRDsOJo((long)delayBasedOnStatusCode, (long)randomDelayInMillis);
    }

    private final long calculateDelayForTooManyRequestError-5sfh64U(Response<T> response) {
        String retryAfterInSec;
        String string = retryAfterInSec = response.headers().get(RETRY_AFTER_HEADER_NAME);
        Integer delayInSeconds = string != null ? StringsKt.toIntOrNull((String)string) : null;
        return this.getDelayForRetryAfterHeaderValue-5sfh64U(delayInSeconds);
    }

    private final long getDelayForRetryAfterHeaderValue-5sfh64U(Integer delayInSeconds) {
        return delayInSeconds != null && delayInSeconds > 0 ? DurationKt.toDuration((int)delayInSeconds, (DurationUnit)DurationUnit.SECONDS) : this.getDelayFromRetryConfiguration-UwyO8pc$pubnub_kotlin_impl();
    }

    private final boolean endpointIsNotExcludedFromRetryConfiguration(List<? extends RetryableEndpointGroup> excludedOperations) {
        return !excludedOperations.contains(this.endpointGroupName);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)429, (Object)"TOO_MANY_REQUESTS"), TuplesKt.to((Object)500, (Object)"HTTP_INTERNAL_ERROR"), TuplesKt.to((Object)502, (Object)"HTTP_BAD_GATEWAY"), TuplesKt.to((Object)503, (Object)"HTTP_UNAVAILABLE"), TuplesKt.to((Object)504, (Object)"HTTP_GATEWAY_TIMEOUT"), TuplesKt.to((Object)507, (Object)"INSUFFICIENT_STORAGE"), TuplesKt.to((Object)508, (Object)"LOOP_DETECTED"), TuplesKt.to((Object)510, (Object)"NOT_EXTENDED"), TuplesKt.to((Object)511, (Object)"NETWORK_AUTHENTICATION_REQUIRED")};
        retryableStatusCodes = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new Class[]{UnknownHostException.class, SocketTimeoutException.class, ConnectException.class, SSLHandshakeException.class, IOException.class};
        retryableExceptions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/pubnub/internal/retry/RetryableBase$Companion;", "", "<init>", "()V", "MAX_RANDOM_DELAY_IN_MILLIS", "", "TOO_MANY_REQUESTS", "SERVICE_UNAVAILABLE", "RETRY_AFTER_HEADER_NAME", "", "retryableStatusCodes", "", "retryableExceptions", "", "Ljava/lang/Class;", "Ljava/io/IOException;", "getRetryableExceptions$pubnub_kotlin_impl", "()Ljava/util/List;", "pubnub-kotlin-impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Class<? extends IOException>> getRetryableExceptions$pubnub_kotlin_impl() {
            return retryableExceptions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

