/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.workers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.pubnub.api.PubNubError;
import com.pubnub.api.models.consumer.files.PNDownloadableFile;
import com.pubnub.api.models.consumer.message_actions.PNMessageAction;
import com.pubnub.api.models.consumer.pubsub.BasePubSubResult;
import com.pubnub.api.models.consumer.pubsub.PNEvent;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.PubSubResult;
import com.pubnub.api.models.consumer.pubsub.files.PNFileEventResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.api.models.consumer.pubsub.objects.ObjectPayload;
import com.pubnub.api.models.consumer.pubsub.objects.PNObjectEventResult;
import com.pubnub.api.v2.PNConfiguration;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.PubNubUtil;
import com.pubnub.internal.extension.JsonElementKt;
import com.pubnub.internal.managers.DuplicationManager;
import com.pubnub.internal.models.consumer.pubsub.objects.PNObjectEventMessage;
import com.pubnub.internal.models.consumer.pubsub.objects.PNObjectEventResultKt;
import com.pubnub.internal.models.server.PresenceEnvelope;
import com.pubnub.internal.models.server.PublishMetaData;
import com.pubnub.internal.models.server.SubscribeMessage;
import com.pubnub.internal.models.server.files.FileUploadNotification;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J*\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/pubnub/internal/workers/SubscribeMessageProcessor;", "", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "duplicationManager", "Lcom/pubnub/internal/managers/DuplicationManager;", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Lcom/pubnub/internal/managers/DuplicationManager;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "processIncomingPayload", "Lcom/pubnub/api/models/consumer/pubsub/PNEvent;", "message", "Lcom/pubnub/internal/models/server/SubscribeMessage;", "formatFriendlyGetFileUrl", "", "buildFileUrl", "channel", "fileId", "fileName", "generateSignature", "configuration", "Lcom/pubnub/api/v2/PNConfiguration;", "url", "authToken", "timestamp", "", "getDelta", "", "delta", "Lcom/google/gson/JsonElement;", "Companion", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nSubscribeMessageProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscribeMessageProcessor.kt\ncom/pubnub/internal/workers/SubscribeMessageProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n1#2:258\n1863#3,2:259\n*S KotlinDebug\n*F\n+ 1 SubscribeMessageProcessor.kt\ncom/pubnub/internal/workers/SubscribeMessageProcessor\n*L\n248#1:259,2\n*E\n"})
public final class SubscribeMessageProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PubNubImpl pubnub;
    @NotNull
    private final DuplicationManager duplicationManager;
    private final Logger log;
    @NotNull
    private final String formatFriendlyGetFileUrl;
    public static final int TYPE_MESSAGE = 0;
    public static final int TYPE_SIGNAL = 1;
    public static final int TYPE_OBJECT = 2;
    public static final int TYPE_MESSAGE_ACTION = 3;
    public static final int TYPE_FILES = 4;

    public SubscribeMessageProcessor(@NotNull PubNubImpl pubnub, @NotNull DuplicationManager duplicationManager) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)duplicationManager, (String)"duplicationManager");
        this.pubnub = pubnub;
        this.duplicationManager = duplicationManager;
        this.log = LoggerFactory.getLogger((String)"SubscribeMessageProcessor");
        CharSequence charSequence = "/v1/files/{subKey}/channels/{channel}/files/{fileId}/{fileName}";
        Regex regex = new Regex("\\{.*?\\}");
        String string = "%s";
        this.formatFriendlyGetFileUrl = "%s" + regex.replace(charSequence, string);
    }

    @Nullable
    public final PNEvent processIncomingPayload(@NotNull SubscribeMessage message) {
        PNEvent pNEvent;
        block14: {
            block19: {
                Object object;
                Long l;
                String string;
                PNDownloadableFile pNDownloadableFile;
                Object object2;
                String string2;
                String customMessageType;
                PubNubError error;
                block21: {
                    block20: {
                        Integer n;
                        BasePubSubResult result;
                        JsonElement extractedMessage;
                        block18: {
                            int n22;
                            block17: {
                                block16: {
                                    block15: {
                                        block13: {
                                            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                            if (message.getChannel$pubnub_kotlin_impl() == null) {
                                                return null;
                                            }
                                            String channel = message.getChannel$pubnub_kotlin_impl();
                                            String subscriptionMatch = message.getSubscriptionMatch$pubnub_kotlin_impl();
                                            PublishMetaData publishMetaData = message.getPublishMetaData$pubnub_kotlin_impl();
                                            if (Intrinsics.areEqual((Object)channel, (Object)subscriptionMatch)) {
                                                subscriptionMatch = null;
                                            }
                                            if (this.pubnub.getConfiguration().getDedupOnSubscribe()) {
                                                if (this.duplicationManager.isDuplicate(message)) {
                                                    return null;
                                                }
                                                this.duplicationManager.addEntry(message);
                                            }
                                            if (StringsKt.endsWith$default((String)message.getChannel$pubnub_kotlin_impl(), (String)"-pnpres", (boolean)false, (int)2, null)) {
                                                JsonElement jsonElement;
                                                JsonElement jsonElement2;
                                                JsonElement jsonElement3;
                                                String string3;
                                                PresenceEnvelope presencePayload = this.pubnub.getMapper().convertValue(message.getPayload$pubnub_kotlin_impl(), PresenceEnvelope.class);
                                                String strippedPresenceChannel = PubNubUtil.INSTANCE.replaceLast(channel, "-pnpres", "");
                                                String string4 = subscriptionMatch;
                                                if (string4 != null) {
                                                    String it = string4;
                                                    boolean n22 = false;
                                                    string3 = PubNubUtil.INSTANCE.replaceLast(it, "-pnpres", "");
                                                } else {
                                                    string3 = null;
                                                }
                                                String strippedPresenceSubscription = string3;
                                                JsonElement jsonElement4 = message.getPayload$pubnub_kotlin_impl();
                                                JsonElement isHereNowRefresh = jsonElement4 != null && (jsonElement4 = jsonElement4.getAsJsonObject()) != null ? jsonElement4.get("here_now_refresh") : null;
                                                PublishMetaData publishMetaData2 = publishMetaData;
                                                return (PNEvent)new PNPresenceEventResult(presencePayload.getAction$pubnub_kotlin_impl(), presencePayload.getUuid$pubnub_kotlin_impl(), presencePayload.getTimestamp$pubnub_kotlin_impl(), presencePayload.getOccupancy$pubnub_kotlin_impl(), presencePayload.getData$pubnub_kotlin_impl(), strippedPresenceChannel, strippedPresenceSubscription, publishMetaData2 != null ? publishMetaData2.getPublishTimetoken$pubnub_kotlin_impl() : null, this.getDelta((jsonElement3 = message.getPayload$pubnub_kotlin_impl()) != null && (jsonElement3 = jsonElement3.getAsJsonObject()) != null ? jsonElement3.get("join") : null), this.getDelta((jsonElement2 = message.getPayload$pubnub_kotlin_impl()) != null && (jsonElement2 = jsonElement2.getAsJsonObject()) != null ? jsonElement2.get("leave") : null), this.getDelta((jsonElement = message.getPayload$pubnub_kotlin_impl()) != null && (jsonElement = jsonElement.getAsJsonObject()) != null ? jsonElement.get("timeout") : null), Boolean.valueOf(isHereNowRefresh != null && isHereNowRefresh.getAsBoolean()), null, 4096, null);
                                            }
                                            Pair<JsonElement, PubNubError> pair = message.getPayload$pubnub_kotlin_impl();
                                            if (pair == null || (pair = JsonElementKt.tryDecryptMessage((JsonElement)pair, this.pubnub.getConfiguration().getCryptoModule(), this.pubnub.getMapper())) == null) {
                                                pair = TuplesKt.to(null, null);
                                            }
                                            Pair<JsonElement, PubNubError> pair2 = pair;
                                            extractedMessage = (JsonElement)pair2.component1();
                                            error = (PubNubError)pair2.component2();
                                            if (extractedMessage == null) {
                                                this.log.debug("unable to parse payload on #processIncomingMessages");
                                            }
                                            customMessageType = message.getCustomMessageType$pubnub_kotlin_impl();
                                            PublishMetaData publishMetaData3 = publishMetaData;
                                            result = new BasePubSubResult(channel, subscriptionMatch, publishMetaData3 != null ? publishMetaData3.getPublishTimetoken$pubnub_kotlin_impl() : null, message.getUserMetadata$pubnub_kotlin_impl(), message.getIssuingClientId$pubnub_kotlin_impl());
                                            n = message.getType$pubnub_kotlin_impl();
                                            if (n != null) break block13;
                                            PubSubResult pubSubResult = (PubSubResult)result;
                                            JsonElement jsonElement = extractedMessage;
                                            Intrinsics.checkNotNull((Object)jsonElement);
                                            pNEvent = (PNEvent)new PNMessageResult(pubSubResult, jsonElement, customMessageType, error);
                                            break block14;
                                        }
                                        if (n != 0) break block15;
                                        PubSubResult pubSubResult = (PubSubResult)result;
                                        JsonElement jsonElement = extractedMessage;
                                        Intrinsics.checkNotNull((Object)jsonElement);
                                        pNEvent = (PNEvent)new PNMessageResult(pubSubResult, jsonElement, customMessageType, error);
                                        break block14;
                                    }
                                    n22 = 1;
                                    if (n != n22) break block16;
                                    PubSubResult pubSubResult = (PubSubResult)result;
                                    JsonElement jsonElement = extractedMessage;
                                    Intrinsics.checkNotNull((Object)jsonElement);
                                    pNEvent = (PNEvent)new PNSignalResult(pubSubResult, jsonElement, customMessageType);
                                    break block14;
                                }
                                n22 = 2;
                                if (n != n22) break block17;
                                pNEvent = (PNEvent)new PNObjectEventResult(result, PNObjectEventResultKt.toApi(this.pubnub.getMapper().convertValue(extractedMessage, PNObjectEventMessage.class)));
                                break block14;
                            }
                            n22 = 3;
                            if (n != n22) break block18;
                            ObjectPayload objectPayload = this.pubnub.getMapper().convertValue(extractedMessage, ObjectPayload.class);
                            JsonObject data = objectPayload.getData().getAsJsonObject();
                            if (!data.has("uuid")) {
                                data.addProperty("uuid", result.getPublisher());
                            }
                            pNEvent = (PNEvent)new PNMessageActionResult(result, objectPayload.getEvent(), this.pubnub.getMapper().convertValue((JsonElement)data, PNMessageAction.class));
                            break block14;
                        }
                        int objectPayload = 4;
                        if (n != objectPayload) break block19;
                        FileUploadNotification fileUploadNotification = this.pubnub.getMapper().convertValue(extractedMessage, FileUploadNotification.class);
                        string2 = message.getChannel$pubnub_kotlin_impl();
                        object2 = fileUploadNotification.getMessage();
                        pNDownloadableFile = new PNDownloadableFile(fileUploadNotification.getFile().getId(), fileUploadNotification.getFile().getName(), this.buildFileUrl(message.getChannel$pubnub_kotlin_impl(), fileUploadNotification.getFile().getId(), fileUploadNotification.getFile().getName()));
                        string = message.getIssuingClientId$pubnub_kotlin_impl();
                        l = result.getTimetoken();
                        object = fileUploadNotification.getMessage();
                        if (object == null) break block20;
                        Object it = object;
                        boolean bl = false;
                        JsonElement jsonElement = this.pubnub.getMapper().toJsonTree(it);
                        object = jsonElement;
                        if (jsonElement != null) break block21;
                    }
                    object = (JsonElement)JsonNull.INSTANCE;
                }
                Object object3 = object;
                Intrinsics.checkNotNull((Object)object3);
                Object object4 = object3;
                pNEvent = (PNEvent)new PNFileEventResult(string2, l, string, object2, pNDownloadableFile, (JsonElement)object4, null, error, customMessageType, 64, null);
                break block14;
            }
            pNEvent = null;
        }
        return pNEvent;
    }

    private final String buildFileUrl(String channel, String fileId, String fileName) {
        ArrayList<String> queryParams;
        String basePath;
        block1: {
            String authToken;
            Object[] objectArray = new Object[]{this.pubnub.baseUrl$pubnub_kotlin_impl(), this.pubnub.getConfiguration().getSubscribeKey(), channel, fileId, fileName};
            String string = String.format(this.formatFriendlyGetFileUrl, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            basePath = string;
            queryParams = new ArrayList<String>();
            String string2 = this.pubnub.getTokenManager$pubnub_kotlin_impl().getToken() != null ? this.pubnub.getTokenManager$pubnub_kotlin_impl().getToken() : (authToken = PNConfiguration.Companion.isValid(this.pubnub.getConfiguration().getAuthKey()) ? this.pubnub.getConfiguration().getAuthKey() : null);
            if (PubNubUtil.INSTANCE.shouldSignRequest(this.pubnub.getConfiguration())) {
                int timestamp = PubNubImpl.Companion.timestamp();
                String signature = this.generateSignature(this.pubnub.getConfiguration(), basePath, authToken, timestamp);
                queryParams.add("timestamp=" + timestamp);
                queryParams.add("signature=" + signature);
            }
            String string3 = authToken;
            if (string3 == null) break block1;
            String $this$buildFileUrl_u24lambda_u242 = string3;
            boolean bl = false;
            queryParams.add("auth=" + authToken);
        }
        return queryParams.isEmpty() ? basePath : basePath + '?' + CollectionsKt.joinToString$default((Iterable)queryParams, (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    private final String generateSignature(PNConfiguration configuration, String url, String authToken, int timestamp) {
        Map queryParams = new LinkedHashMap();
        if (authToken != null) {
            queryParams.put("auth", authToken);
        }
        return PubNubUtil.INSTANCE.generateSignature(url, queryParams, "get", null, timestamp, configuration.getSubscribeKey(), configuration.getPublishKey(), configuration.getSecretKey());
    }

    private final List<String> getDelta(JsonElement delta) {
        List list;
        block1: {
            list = new ArrayList();
            JsonElement jsonElement = delta;
            if (jsonElement == null) break block1;
            JsonElement it = jsonElement;
            boolean bl = false;
            JsonArray jsonArray = it.getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
            Iterable $this$forEach$iv = (Iterable)jsonArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonElement it2;
                JsonElement item = (JsonElement)element$iv;
                boolean bl2 = false;
                if (item == null) continue;
                boolean bl3 = false;
                String string = it2.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
                list.add(string);
            }
        }
        return list;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/pubnub/internal/workers/SubscribeMessageProcessor$Companion;", "", "<init>", "()V", "TYPE_MESSAGE", "", "TYPE_SIGNAL", "TYPE_OBJECT", "TYPE_MESSAGE_ACTION", "TYPE_FILES", "pubnub-kotlin-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

