/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.crypto;

import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.internal.vendor.Base64;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u001a(\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\fH\u0000\u001a(\u0010\r\u001a\u00020\u000e*\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\fH\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u000e*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"SIZE_OF_CRYPTOR_ID", "", "encryptString", "", "Lcom/pubnub/api/crypto/CryptoModule;", "inputString", "decryptString", "checkMinSize", "", "Ljava/io/BufferedInputStream;", "size", "exceptionBlock", "Lkotlin/Function1;", "readExactlyNBytez", "", "readNBytez", "Ljava/io/InputStream;", "len", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nCryptoModuleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CryptoModuleImpl.kt\ncom/pubnub/internal/crypto/CryptoModuleImplKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1#2:198\n*E\n"})
public final class CryptoModuleImplKt {
    private static final int SIZE_OF_CRYPTOR_ID = 4;

    @NotNull
    public static final String encryptString(@NotNull CryptoModule $this$encryptString, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)$this$encryptString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        String string = inputString;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = Base64.encode($this$encryptString.encrypt(byArray), 2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encode(...)");
        byte[] byArray3 = byArray2;
        return new String(byArray3, Charsets.UTF_8);
    }

    @NotNull
    public static final String decryptString(@NotNull CryptoModule $this$decryptString, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)$this$decryptString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        byte[] byArray = Base64.decode(inputString, 2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = $this$decryptString.decrypt(byArray);
        Charset charset = Charsets.UTF_8;
        return new String(byArray2, charset);
    }

    public static final void checkMinSize(@NotNull BufferedInputStream $this$checkMinSize, int size, @NotNull Function1<? super Integer, Unit> exceptionBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$checkMinSize, (String)"<this>");
        Intrinsics.checkNotNullParameter(exceptionBlock, (String)"exceptionBlock");
        $this$checkMinSize.mark(size + 1);
        byte[] readBytes = CryptoModuleImplKt.readNBytez($this$checkMinSize, size);
        $this$checkMinSize.reset();
        if (readBytes.length < size) {
            exceptionBlock.invoke((Object)size);
        }
    }

    @NotNull
    public static final byte[] readExactlyNBytez(@NotNull BufferedInputStream $this$readExactlyNBytez, int size, @NotNull Function1<? super Integer, Unit> exceptionBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$readExactlyNBytez, (String)"<this>");
        Intrinsics.checkNotNullParameter(exceptionBlock, (String)"exceptionBlock");
        byte[] readBytes = CryptoModuleImplKt.readNBytez($this$readExactlyNBytez, size);
        if (readBytes.length < size) {
            exceptionBlock.invoke((Object)size);
        }
        return readBytes;
    }

    @NotNull
    public static final byte[] readNBytez(@NotNull InputStream $this$readNBytez, int len) {
        Intrinsics.checkNotNullParameter((Object)$this$readNBytez, (String)"<this>");
        int remaining = len;
        int n = 0;
        byte[] originalArray = new byte[remaining];
        int nread = 0;
        while (true) {
            int n2;
            int it = n2 = $this$readNBytez.read(originalArray, nread, Integer.min(originalArray.length - nread, remaining));
            boolean bl = false;
            n = it;
            if (n2 <= 0) break;
            nread += n;
            remaining -= n;
        }
        byte[] byArray = Arrays.copyOf(originalArray, nread);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }
}

